/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.opentracing.deployment;

import io.opentracing.Tracer;
import io.opentracing.contrib.interceptors.OpenTracingInterceptor;
import io.opentracing.contrib.jaxrs2.server.SpanFinishingFilter;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveMethodBuildItem;
import io.quarkus.resteasy.common.spi.ResteasyJaxrsProviderBuildItem;
import io.quarkus.resteasy.reactive.spi.CustomContainerResponseFilterBuildItem;
import io.quarkus.resteasy.reactive.spi.DynamicFeatureBuildItem;
import io.quarkus.resteasy.reactive.spi.WriterInterceptorBuildItem;
import io.quarkus.smallrye.opentracing.runtime.QuarkusSmallRyeTracingDynamicFeature;
import io.quarkus.smallrye.opentracing.runtime.QuarkusSmallRyeTracingStandaloneContainerResponseFilter;
import io.quarkus.smallrye.opentracing.runtime.QuarkusSmallRyeTracingStandaloneVertxDynamicFeature;
import io.quarkus.smallrye.opentracing.runtime.TracerProducer;
import io.quarkus.undertow.deployment.FilterBuildItem;
import java.lang.reflect.Method;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.servlet.DispatcherType;

public class SmallRyeOpenTracingProcessor {
    @BuildStep
    AdditionalBeanBuildItem registerBeans(BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{Tracer.class}));
        return new AdditionalBeanBuildItem(new Class[]{OpenTracingInterceptor.class, TracerProducer.class});
    }

    @BuildStep
    ReflectiveMethodBuildItem registerMethod() throws Exception {
        Method isAsync = ObserverMethod.class.getMethod("isAsync", new Class[0]);
        return new ReflectiveMethodBuildItem(isAsync);
    }

    @BuildStep
    void setupFilter(BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<ResteasyJaxrsProviderBuildItem> providers, BuildProducer<FilterBuildItem> filterProducer, BuildProducer<FeatureBuildItem> feature, BuildProducer<CustomContainerResponseFilterBuildItem> customResponseFilters, BuildProducer<DynamicFeatureBuildItem> dynamicFeatures, BuildProducer<WriterInterceptorBuildItem> writerInterceptors, Capabilities capabilities) {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.SMALLRYE_OPENTRACING));
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{QuarkusSmallRyeTracingDynamicFeature.class}));
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(QuarkusSmallRyeTracingDynamicFeature.class.getName()));
        if (capabilities.isPresent("io.quarkus.servlet")) {
            FilterBuildItem filterInfo = FilterBuildItem.builder((String)"tracingFilter", (String)SpanFinishingFilter.class.getName()).setAsyncSupported(true).addFilterUrlMapping("*", DispatcherType.FORWARD).addFilterUrlMapping("*", DispatcherType.INCLUDE).addFilterUrlMapping("*", DispatcherType.REQUEST).addFilterUrlMapping("*", DispatcherType.ASYNC).addFilterUrlMapping("*", DispatcherType.ERROR).build();
            filterProducer.produce((BuildItem)filterInfo);
        } else if (capabilities.isPresent("io.quarkus.resteasy")) {
            providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(QuarkusSmallRyeTracingStandaloneVertxDynamicFeature.class.getName()));
        } else if (capabilities.isPresent("io.quarkus.resteasy.reactive")) {
            customResponseFilters.produce((BuildItem)new CustomContainerResponseFilterBuildItem(QuarkusSmallRyeTracingStandaloneContainerResponseFilter.class.getName()));
            dynamicFeatures.produce((BuildItem)new DynamicFeatureBuildItem(QuarkusSmallRyeTracingDynamicFeature.class.getName()));
            writerInterceptors.produce((BuildItem)new WriterInterceptorBuildItem.Builder(QuarkusSmallRyeTracingStandaloneContainerResponseFilter.class.getName()).build());
        }
    }
}

