/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit.classloading;

import io.quarkus.bootstrap.BootstrapException;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.StartupAction;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.test.junit.AppMakerHelper;
import io.quarkus.test.junit.QuarkusIntegrationTest;
import io.quarkus.test.junit.QuarkusTestExtension;
import io.quarkus.test.junit.TestProfile;
import io.quarkus.test.junit.TestResourceUtil;
import io.quarkus.test.junit.classloading.ParentLastURLClassLoader;
import io.quarkus.test.junit.classloading.QuarkusTestConfigProviderResolver;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.HierarchyTraversalMode;

public final class FacadeClassLoader
extends ClassLoader
implements Closeable {
    private static final Logger log = Logger.getLogger(FacadeClassLoader.class);
    private static final String NAME = "FacadeLoader";
    public static final String VALUE = "value";
    public static final String KEY_PREFIX = "QuarkusTest-";
    public static final String DISPLAY_NAME_PREFIX = "JUnit";
    private static final Map<String, CuratedApplication> curatedApplications = new HashMap<String, CuratedApplication>();
    private final Map<String, QuarkusClassLoader> runtimeClassLoaders = new HashMap<String, QuarkusClassLoader>();
    private static final String NO_PROFILE = "no-profile";
    private URLClassLoader peekingClassLoader;
    private boolean isServiceLoaderMechanism;
    private Method osIsCurrent;
    private Class<? extends Annotation> quarkusTestAnnotation;
    private Class<? extends Annotation> disabledAnnotation;
    private Class<? extends Annotation> disabledOnOsAnnotation;
    private Method disabledOnOsAnnotationValue;
    private Class<? extends Annotation> quarkusIntegrationTestAnnotation;
    private Class<? extends Annotation> profileAnnotation;
    private Class<? extends Annotation> extendWithAnnotation;
    private Class<? extends Annotation> registerExtensionAnnotation;
    private Class<? extends Annotation> testAnnotation;
    private final Map<String, Class<?>> profiles;
    private final Set<String> quarkusTestClasses;
    private final boolean isAuxiliaryApplication;
    private QuarkusClassLoader keyMakerClassLoader;

    public FacadeClassLoader(ClassLoader parent) {
        this(parent, false, null, null, null, System.getProperty("java.class.path"));
    }

    public FacadeClassLoader(ClassLoader parent, boolean isAuxiliaryApplication, CuratedApplication curatedApplication, Map<String, String> profileNames, Set<String> quarkusTestClasses, String classesPath) {
        super(parent);
        ClassLoader annotationLoader;
        boolean launcherClassloader;
        curatedApplications.put(FacadeClassLoader.getProfileKey(null), curatedApplication);
        this.quarkusTestClasses = quarkusTestClasses;
        this.isAuxiliaryApplication = isAuxiliaryApplication;
        URL[] urls = (URL[])Arrays.stream(classesPath.split(File.pathSeparator)).map(spec -> {
            try {
                if (!((String)spec).endsWith("jar") && !((String)spec).endsWith(File.separator)) {
                    spec = (String)spec + File.separator;
                }
                return Path.of((String)spec, new String[0]).toUri().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }).toArray(URL[]::new);
        boolean bl = launcherClassloader = !classesPath.contains(File.pathSeparator);
        if (launcherClassloader) {
            this.peekingClassLoader = new URLClassLoader(urls, null);
            annotationLoader = parent;
        } else {
            this.peekingClassLoader = new ParentLastURLClassLoader(urls, parent);
            annotationLoader = this.peekingClassLoader;
        }
        try {
            this.extendWithAnnotation = annotationLoader.loadClass(ExtendWith.class.getName());
            this.disabledAnnotation = annotationLoader.loadClass(Disabled.class.getName());
            this.disabledOnOsAnnotation = annotationLoader.loadClass(DisabledOnOs.class.getName());
            Class<?> osClass = annotationLoader.loadClass(OS.class.getName());
            this.osIsCurrent = osClass.getMethod("isCurrentOs", new Class[0]);
            this.disabledOnOsAnnotationValue = this.disabledOnOsAnnotation.getMethod(VALUE, new Class[0]);
            this.registerExtensionAnnotation = annotationLoader.loadClass(RegisterExtension.class.getName());
            this.quarkusTestAnnotation = annotationLoader.loadClass("io.quarkus.test.junit.QuarkusTest");
            this.quarkusIntegrationTestAnnotation = annotationLoader.loadClass(QuarkusIntegrationTest.class.getName());
            this.profileAnnotation = annotationLoader.loadClass(TestProfile.class.getName());
            this.testAnnotation = annotationLoader.loadClass(Test.class.getName());
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            log.debug((Object)("Could not load annotations for FacadeClassLoader: " + String.valueOf(e)));
        }
        try {
            Enumeration<URL> declaredExtensions = annotationLoader.getResources("META-INF/services/org.junit.jupiter.api.extension.Extension");
            while (declaredExtensions.hasMoreElements()) {
                URL url = declaredExtensions.nextElement();
                InputStream in = url.openStream();
                try {
                    String contents = new String(in.readAllBytes(), StandardCharsets.UTF_8).trim();
                    if (!QuarkusTestExtension.class.getName().equals(contents)) continue;
                    this.isServiceLoaderMechanism = true;
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
        catch (IOException e) {
            log.debug((Object)("Could not check service loader registrations: " + String.valueOf(e)));
            throw new RuntimeException(e);
        }
        if (profileNames != null) {
            this.profiles = new HashMap();
            profileNames.forEach((k, profileName) -> {
                if (profileName != null) {
                    Class<?> profile;
                    try {
                        profile = this.peekingClassLoader.loadClass((String)profileName);
                    }
                    catch (ClassNotFoundException e1) {
                        throw new RuntimeException(e1);
                    }
                    this.profiles.put((String)k, profile);
                }
            });
        } else {
            this.profiles = null;
        }
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        log.debugf("Facade classloader loading %s", (Object)name);
        if (this.peekingClassLoader == null) {
            throw new RuntimeException("Attempted to load classes with a closed classloader: " + String.valueOf(this));
        }
        boolean isQuarkusTest = false;
        boolean isIntegrationTest = false;
        Class<?> inspectionClass = null;
        if (this.isServiceLoaderMechanism && name.equals(QuarkusTestExtension.class.getName())) {
            try {
                QuarkusClassLoader runtimeClassLoader = this.getOrCreateBaseClassLoader(FacadeClassLoader.getProfileKey(null), null);
                return runtimeClassLoader.loadClass(name);
            }
            catch (BootstrapException | AppModelResolverException | IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Class profile = null;
            if (this.profiles != null && !this.isServiceLoaderMechanism) {
                isQuarkusTest = this.quarkusTestClasses.contains(name);
                profile = this.profiles.get(name);
                if (isQuarkusTest) {
                    try {
                        inspectionClass = this.peekingClassLoader.loadClass(name);
                    }
                    catch (ClassNotFoundException | NoClassDefFoundError e) {
                        return super.loadClass(name);
                    }
                }
            } else if (this.quarkusTestAnnotation != null) {
                try {
                    inspectionClass = this.peekingClassLoader.loadClass(name);
                }
                catch (ClassNotFoundException | NoClassDefFoundError e) {
                    return super.loadClass(name);
                }
                if (!inspectionClass.isAnnotation()) {
                    boolean isDisabled;
                    if (this.isServiceLoaderMechanism) {
                        List anns = AnnotationSupport.findAnnotatedMethods(inspectionClass, this.testAnnotation, (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP);
                        isQuarkusTest = !anns.isEmpty();
                    }
                    boolean bl = isDisabled = AnnotationSupport.isAnnotated(inspectionClass, this.disabledAnnotation) || this.isDisabledOnOs(inspectionClass);
                    if (!isDisabled) {
                        boolean bl2 = isQuarkusTest = isQuarkusTest || AnnotationSupport.isAnnotated(inspectionClass, this.quarkusTestAnnotation) || this.registersQuarkusTestExtensionWithExtendsWith(inspectionClass) || this.registersQuarkusTestExtensionOnField(inspectionClass);
                        if (isQuarkusTest) {
                            isIntegrationTest = !inspectionClass.isAnnotation() && AnnotationSupport.isAnnotated(inspectionClass, this.quarkusIntegrationTestAnnotation);
                            Optional profileDeclaration = AnnotationSupport.findAnnotation(inspectionClass, this.profileAnnotation);
                            if (profileDeclaration.isPresent()) {
                                Method m = ((Annotation)profileDeclaration.get()).getClass().getMethod(VALUE, new Class[0]);
                                profile = (Class)m.invoke(profileDeclaration.get(), new Object[0]);
                            }
                        }
                    }
                }
            }
            if (isQuarkusTest && !isIntegrationTest) {
                this.preloadTestResourceClasses(inspectionClass);
                QuarkusClassLoader runtimeClassLoader = this.getQuarkusClassLoader(inspectionClass, profile);
                Class clazz = runtimeClassLoader.loadClass(name);
                return clazz;
            }
            return super.loadClass(name);
        }
        catch (NoSuchMethodException e) {
            System.err.println("Could not get method " + String.valueOf(e));
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            System.err.println("Could not invoke " + String.valueOf(e));
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            System.err.println("Could not access " + String.valueOf(e));
            throw new RuntimeException(e);
        }
    }

    private boolean isDisabledOnOs(Class<?> inspectionClass) {
        Optional ma = AnnotationSupport.findAnnotation(inspectionClass, this.disabledOnOsAnnotation);
        if (ma.isPresent()) {
            Annotation a = (Annotation)ma.get();
            try {
                Object values = this.disabledOnOsAnnotationValue.invoke((Object)a, new Object[0]);
                if (values.getClass().isArray()) {
                    int length = Array.getLength(values);
                    for (int i = 0; i < length; ++i) {
                        Object value = Array.get(values, i);
                        boolean matches = (Boolean)this.osIsCurrent.invoke(value, new Object[0]);
                        if (!matches) continue;
                        return true;
                    }
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    private boolean registersQuarkusTestExtensionWithExtendsWith(Class<?> inspectionClass) {
        Optional a = AnnotationSupport.findAnnotation(inspectionClass, this.extendWithAnnotation);
        return a.isPresent() && ((Annotation)a.get()).toString().contains(QuarkusTestExtension.class.getName());
    }

    private void preloadTestResourceClasses(Class<?> fromCanary) {
        try {
            Class<?> ca = this.peekingClassLoader.loadClass("io.quarkus.test.common.QuarkusTestResource");
            List ans = AnnotationSupport.findRepeatableAnnotations(fromCanary, ca);
            for (Annotation a : ans) {
                Method m = a.getClass().getMethod(VALUE, new Class[0]);
                Class resourceClass = (Class)m.invoke((Object)a, new Object[0]);
                if (!resourceClass.getName().contains("Kubernetes")) continue;
                this.getParent().loadClass(resourceClass.getName());
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.debug((Object)("Canary classloader could not preload test resources:" + String.valueOf(e)));
        }
    }

    private boolean registersQuarkusTestExtensionOnField(Class<?> inspectionClass) {
        try {
            List fields = AnnotationSupport.findAnnotatedFields(inspectionClass, this.registerExtensionAnnotation, f -> f.getType().getName().equals(QuarkusTestExtension.class.getName()));
            return fields != null && !fields.isEmpty();
        }
        catch (NoClassDefFoundError e) {
            log.warn((Object)("Could not discover field annotations: " + String.valueOf(e)));
            return false;
        }
    }

    private QuarkusClassLoader getQuarkusClassLoader(Class<?> requiredTestClass, Class<?> profile) {
        String profileKey = FacadeClassLoader.getProfileKey(profile);
        try {
            String key;
            QuarkusClassLoader classLoader;
            if (this.keyMakerClassLoader == null) {
                this.keyMakerClassLoader = classLoader = this.getOrCreateRuntimeClassLoader(profileKey, requiredTestClass, profile);
                String resourceKey = requiredTestClass != null ? this.getResourceKey(requiredTestClass, profile) : null;
                key = profileKey + resourceKey;
            } else {
                String resourceKey = requiredTestClass != null ? this.getResourceKey(requiredTestClass, profile) : null;
                key = profileKey + resourceKey;
                classLoader = this.runtimeClassLoaders.get(key);
                if (classLoader == null) {
                    classLoader = this.getOrCreateRuntimeClassLoader(profileKey, requiredTestClass, profile);
                }
            }
            this.runtimeClassLoaders.put(key, classLoader);
            return classLoader;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private static String getProfileKey(Class<?> profile) {
        String profileName = profile != null ? profile.getName() : NO_PROFILE;
        String profileKey = KEY_PREFIX + profileName;
        return profileKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResourceKey(Class<?> requiredTestClass, Class<?> profile) throws NoSuchMethodException, ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        String resourceKey;
        QuarkusClassLoader classLoader = this.keyMakerClassLoader;
        Method method = Class.forName(TestResourceUtil.class.getName(), true, (ClassLoader)classLoader).getMethod("getReloadGroupIdentifier", Class.class, Class.class);
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.keyMakerClassLoader);
            Class transliteratedProfile = profile != null ? this.keyMakerClassLoader.loadClass(profile.getName()) : null;
            resourceKey = (String)method.invoke(null, requiredTestClass, transliteratedProfile);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
        return resourceKey;
    }

    private CuratedApplication getOrCreateCuratedApplication(String key, Class<?> requiredTestClass) throws IOException, AppModelResolverException, BootstrapException {
        CuratedApplication curatedApplication = curatedApplications.get(key);
        if (curatedApplication == null) {
            String displayName = DISPLAY_NAME_PREFIX + key;
            curatedApplication = AppMakerHelper.makeCuratedApplication(requiredTestClass, displayName, this.isAuxiliaryApplication);
            curatedApplications.put(key, curatedApplication);
        }
        return curatedApplication;
    }

    private QuarkusClassLoader getOrCreateBaseClassLoader(String key, Class<?> requiredTestClass) throws AppModelResolverException, BootstrapException, IOException {
        CuratedApplication curatedApplication = this.getOrCreateCuratedApplication(key, requiredTestClass);
        return curatedApplication.getOrCreateBaseRuntimeClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QuarkusClassLoader getOrCreateRuntimeClassLoader(String key, Class<?> requiredTestClass, Class<?> profile) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException, AppModelResolverException, BootstrapException, IOException {
        StartupAction startupAction;
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        CuratedApplication curatedApplication = this.getOrCreateCuratedApplication(key, requiredTestClass);
        try {
            if (profile != null) {
                Thread.currentThread().setContextClassLoader(profile.getClassLoader());
            }
            startupAction = AppMakerHelper.getStartupAction(requiredTestClass, curatedApplication, profile);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        QuarkusClassLoader loader = startupAction.getClassLoader();
        Class configProviderResolverClass = loader.loadClass(ConfigProviderResolver.class.getName());
        Class testConfigProviderResolverClass = loader.loadClass(QuarkusTestConfigProviderResolver.class.getName());
        Object testConfigProviderResolver = testConfigProviderResolverClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        configProviderResolverClass.getDeclaredMethod("setInstance", configProviderResolverClass).invoke(null, testConfigProviderResolver);
        return loader;
    }

    public boolean isServiceLoaderMechanism() {
        return this.isServiceLoaderMechanism;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void close() throws IOException {
        if (this.peekingClassLoader != null) {
            this.peekingClassLoader.close();
            this.peekingClassLoader = null;
        }
        this.keyMakerClassLoader = null;
        this.runtimeClassLoaders.clear();
    }
}

