/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jaeger.runtime.graal;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import io.jaegertracing.internal.metrics.Counter;
import io.jaegertracing.internal.metrics.Gauge;
import io.jaegertracing.spi.MetricsFactory;
import java.util.Collections;
import java.util.HashMap;

@TargetClass(className="io.jaegertracing.internal.metrics.Metrics")
public final class Target_Metrics {
    @Alias
    public Counter traceStartedSampled;
    @Alias
    public Counter traceStartedNotSampled;
    @Alias
    public Counter tracesJoinedSampled;
    @Alias
    public Counter tracesJoinedNotSampled;
    @Alias
    public Counter spansStartedSampled;
    @Alias
    public Counter spansStartedNotSampled;
    @Alias
    public Counter spansFinished;
    @Alias
    public Counter decodingErrors;
    @Alias
    public Counter reporterSuccess;
    @Alias
    public Counter reporterFailure;
    @Alias
    public Counter reporterDropped;
    @Alias
    public Gauge reporterQueueLength;
    @Alias
    public Counter samplerRetrieved;
    @Alias
    public Counter samplerQueryFailure;
    @Alias
    public Counter samplerUpdated;
    @Alias
    public Counter samplerParsingFailure;
    @Alias
    public Counter baggageUpdateSuccess;
    @Alias
    public Counter baggageUpdateFailure;
    @Alias
    public Counter baggageTruncate;
    @Alias
    public Counter baggageRestrictionsUpdateSuccess;
    @Alias
    public Counter baggageRestrictionsUpdateFailure;

    @Substitute
    private void createMetrics(MetricsFactory factory, String metricsPrefix) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("state", "started");
        tags.put("sampled", "y");
        this.traceStartedSampled = factory.createCounter(metricsPrefix + "traces", tags);
        tags = new HashMap();
        tags.put("state", "started");
        tags.put("sampled", "n");
        this.traceStartedNotSampled = factory.createCounter(metricsPrefix + "traces", tags);
        tags = new HashMap();
        tags.put("state", "joined");
        tags.put("sampled", "y");
        this.tracesJoinedSampled = factory.createCounter(metricsPrefix + "traces", tags);
        tags = new HashMap();
        tags.put("state", "joined");
        tags.put("sampled", "n");
        this.tracesJoinedNotSampled = factory.createCounter(metricsPrefix + "traces", tags);
        tags = new HashMap();
        tags.put("sampled", "y");
        this.spansStartedSampled = factory.createCounter(metricsPrefix + "started_spans", tags);
        tags = new HashMap();
        tags.put("sampled", "n");
        this.spansStartedNotSampled = factory.createCounter(metricsPrefix + "started_spans", tags);
        this.spansFinished = factory.createCounter(metricsPrefix + "finished_spans", Collections.emptyMap());
        this.decodingErrors = factory.createCounter(metricsPrefix + "span_context_decoding_errors", Collections.emptyMap());
        tags = new HashMap();
        tags.put("result", "ok");
        this.reporterSuccess = factory.createCounter(metricsPrefix + "reporter_spans", tags);
        tags = new HashMap();
        tags.put("result", "err");
        this.reporterFailure = factory.createCounter(metricsPrefix + "reporter_spans", tags);
        tags = new HashMap();
        tags.put("result", "dropped");
        this.reporterDropped = factory.createCounter(metricsPrefix + "reporter_spans", tags);
        this.reporterQueueLength = factory.createGauge(metricsPrefix + "reporter_queue_length", Collections.emptyMap());
        tags = new HashMap();
        tags.put("result", "ok");
        this.samplerRetrieved = factory.createCounter(metricsPrefix + "sampler_queries", tags);
        tags = new HashMap();
        tags.put("result", "err");
        this.samplerQueryFailure = factory.createCounter(metricsPrefix + "sampler_queries", tags);
        tags = new HashMap();
        tags.put("result", "ok");
        this.samplerUpdated = factory.createCounter(metricsPrefix + "sampler_updates", tags);
        tags = new HashMap();
        tags.put("result", "err");
        this.samplerParsingFailure = factory.createCounter(metricsPrefix + "sampler_updates", tags);
        tags = new HashMap();
        tags.put("result", "ok");
        this.baggageUpdateSuccess = factory.createCounter(metricsPrefix + "baggage_updates", tags);
        tags = new HashMap();
        tags.put("result", "err");
        this.baggageUpdateFailure = factory.createCounter(metricsPrefix + "baggage_updates", tags);
        this.baggageTruncate = factory.createCounter(metricsPrefix + "baggage_truncations", Collections.emptyMap());
        tags = new HashMap();
        tags.put("result", "ok");
        this.baggageRestrictionsUpdateSuccess = factory.createCounter(metricsPrefix + "baggage_restrictions_updates", tags);
        tags = new HashMap();
        tags.put("result", "err");
        this.baggageRestrictionsUpdateFailure = factory.createCounter(metricsPrefix + "baggage_restrictions_updates", tags);
    }
}

