/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.generate_doc;

import io.quarkus.annotation.processor.generate_doc.FsMap;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FsMultiMap {
    private final Path dir;

    public FsMultiMap(Path dir) {
        this.dir = FsMap.safeCreateDirectories(dir);
    }

    public List<String> get(String key) {
        Path entryDir = this.dir.resolve(key);
        if (Files.exists(entryDir, new LinkOption[0])) {
            List<String> list;
            block9: {
                Stream<Path> files = Files.list(entryDir);
                try {
                    list = files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(f -> f.getFileName().toString()).collect(Collectors.toList());
                    if (files == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (files != null) {
                            try {
                                files.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Could not list " + entryDir, e);
                    }
                }
                files.close();
            }
            return list;
        }
        return Collections.emptyList();
    }

    public void put(String key, String value) {
        Path entryDir = this.dir.resolve(key);
        FsMap.safeCreateDirectories(entryDir);
        Path itemPath = entryDir.resolve(value);
        try {
            Files.write(itemPath, value.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write to " + itemPath, e);
        }
    }
}

