/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.util;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;

public final class JandexUtil {
    private static final DotName OBJECT = DotName.createSimple((String)Object.class.getName());

    private JandexUtil() {
    }

    public static List<Type> resolveTypeParameters(DotName input, DotName target, IndexView index) {
        ClassInfo targetClassInfo;
        ClassInfo inputClassInfo = JandexUtil.fetchFromIndex(input, index);
        RecursiveMatchResult recursiveMatchResult = JandexUtil.matchParametersRecursively(inputClassInfo, target, Modifier.isInterface((targetClassInfo = JandexUtil.fetchFromIndex(target, index)).flags()), index, new LinkedList<RecursiveMatchLevel>());
        if (recursiveMatchResult == null) {
            return Collections.emptyList();
        }
        List<Type> result = JandexUtil.resolveTypeParameters(recursiveMatchResult);
        if (result.size() != recursiveMatchResult.argumentsOfMatch.size()) {
            throw new IllegalStateException("Unable to properly match generic types");
        }
        return result;
    }

    private static List<Type> resolveTypeParameters(RecursiveMatchResult recursiveMatchResult) {
        ArrayList<Type> result = new ArrayList<Type>();
        for (int i = 0; i < recursiveMatchResult.argumentsOfMatch.size(); ++i) {
            Type typeFromTypeVariable;
            ArrayType argumentAsArrayType;
            Type componentType;
            Type argument = (Type)recursiveMatchResult.argumentsOfMatch.get(i);
            if (argument instanceof ClassType) {
                result.add(argument);
                continue;
            }
            if (argument instanceof ParameterizedType) {
                ParameterizedType argumentParameterizedType = argument.asParameterizedType();
                ArrayList<Type> resolvedTypes = new ArrayList<Type>(argumentParameterizedType.arguments().size());
                for (Type argType : argumentParameterizedType.arguments()) {
                    if (argType instanceof TypeVariable) {
                        resolvedTypes.add(JandexUtil.findTypeFromTypeVariable(recursiveMatchResult, argType.asTypeVariable()));
                        continue;
                    }
                    resolvedTypes.add(argType);
                }
                result.add((Type)ParameterizedType.create((DotName)argumentParameterizedType.name(), (Type[])resolvedTypes.toArray(new Type[0]), (Type)argumentParameterizedType.owner()));
                continue;
            }
            if (argument instanceof TypeVariable) {
                Type typeFromTypeVariable2 = JandexUtil.findTypeFromTypeVariable(recursiveMatchResult, argument.asTypeVariable());
                if (typeFromTypeVariable2 == null) continue;
                result.add(typeFromTypeVariable2);
                continue;
            }
            if (!(argument instanceof ArrayType) || !((componentType = (argumentAsArrayType = argument.asArrayType()).component()) instanceof TypeVariable) || (typeFromTypeVariable = JandexUtil.findTypeFromTypeVariable(recursiveMatchResult, componentType.asTypeVariable())) == null) continue;
            result.add((Type)ArrayType.create((Type)typeFromTypeVariable, (int)argumentAsArrayType.dimensions()));
        }
        return result;
    }

    private static Type findTypeFromTypeVariable(RecursiveMatchResult recursiveMatchResult, TypeVariable typeVariable) {
        String unmatchedParameter = typeVariable.identifier();
        for (RecursiveMatchLevel recursiveMatchLevel : recursiveMatchResult.recursiveMatchLevels) {
            Type matchingCapturedType = null;
            for (int j = 0; j < recursiveMatchLevel.definitions.size(); ++j) {
                Type definition = (Type)recursiveMatchLevel.definitions.get(j);
                if (!(definition instanceof TypeVariable) || !unmatchedParameter.equals(definition.asTypeVariable().identifier())) continue;
                matchingCapturedType = (Type)recursiveMatchLevel.captures.get(j);
                break;
            }
            if (matchingCapturedType == null) {
                throw new IllegalStateException("Error retrieving generic types");
            }
            if (JandexUtil.isDirectlyHandledType(matchingCapturedType)) {
                return matchingCapturedType;
            }
            if (!(matchingCapturedType instanceof TypeVariable)) continue;
            unmatchedParameter = matchingCapturedType.asTypeVariable().identifier();
        }
        return null;
    }

    private static boolean isDirectlyHandledType(Type matchingCapturedType) {
        return matchingCapturedType instanceof ClassType || matchingCapturedType instanceof ParameterizedType;
    }

    private static RecursiveMatchResult matchParametersRecursively(ClassInfo inputClassInfo, DotName target, boolean isTargetAnInterface, IndexView index, List<RecursiveMatchLevel> visitedTypes) {
        Type superClassType;
        if (isTargetAnInterface) {
            List interfaceTypes = inputClassInfo.interfaceTypes();
            ArrayList<Type> nonMatchingInterfaces = new ArrayList<Type>();
            for (Type interfaceType : interfaceTypes) {
                if (target.equals((Object)interfaceType.name())) {
                    return JandexUtil.getRecursiveMatchResult(visitedTypes, interfaceType);
                }
                nonMatchingInterfaces.add(interfaceType);
            }
            for (Type otherInterface : nonMatchingInterfaces) {
                RecursiveMatchResult recursiveMatchResult = JandexUtil.matchParametersRecursively(JandexUtil.fetchFromIndex(otherInterface.name(), index), target, isTargetAnInterface, index, JandexUtil.addArgumentIfNeeded(otherInterface, index, visitedTypes));
                if (recursiveMatchResult == null) continue;
                return recursiveMatchResult;
            }
        }
        if (target.equals((Object)(superClassType = inputClassInfo.superClassType()).name())) {
            return JandexUtil.getRecursiveMatchResult(visitedTypes, superClassType);
        }
        if (OBJECT.equals((Object)superClassType.name())) {
            return null;
        }
        return JandexUtil.matchParametersRecursively(JandexUtil.fetchFromIndex(superClassType.name(), index), target, isTargetAnInterface, index, JandexUtil.addArgumentIfNeeded(superClassType, index, visitedTypes));
    }

    private static RecursiveMatchResult getRecursiveMatchResult(List<RecursiveMatchLevel> visitedTypes, Type superClassType) {
        if (superClassType instanceof ParameterizedType) {
            return new RecursiveMatchResult(superClassType.asParameterizedType().arguments(), visitedTypes);
        }
        return null;
    }

    private static ClassInfo fetchFromIndex(DotName dotName, IndexView index) {
        ClassInfo classInfo = index.getClassByName(dotName);
        if (classInfo == null) {
            throw new IllegalArgumentException("Class " + dotName + " was not found in the index");
        }
        return classInfo;
    }

    private static List<RecursiveMatchLevel> addArgumentIfNeeded(Type type, IndexView index, List<RecursiveMatchLevel> visitedTypes) {
        ClassInfo classInfo;
        LinkedList<RecursiveMatchLevel> newVisitedTypes = new LinkedList<RecursiveMatchLevel>(visitedTypes);
        if (type instanceof ParameterizedType) {
            ClassInfo classInfo2 = JandexUtil.fetchFromIndex(type.name(), index);
            RecursiveMatchLevel recursiveMatchLevel = new RecursiveMatchLevel(classInfo2.typeParameters(), type.asParameterizedType().arguments());
            newVisitedTypes.add(0, recursiveMatchLevel);
        } else if (type instanceof ClassType && (classInfo = index.getClassByName(type.name())) != null && !classInfo.typeParameters().isEmpty()) {
            ArrayList captures = new ArrayList(classInfo.typeParameters().size());
            for (TypeVariable typeParameter : classInfo.typeParameters()) {
                captures.add(typeParameter.bounds().get(0));
            }
            RecursiveMatchLevel recursiveMatchLevel = new RecursiveMatchLevel(classInfo.typeParameters(), captures);
            newVisitedTypes.add(0, recursiveMatchLevel);
        }
        return newVisitedTypes;
    }

    private static class RecursiveMatchLevel {
        private final List<? extends Type> definitions;
        private final List<? extends Type> captures;

        public RecursiveMatchLevel(List<? extends Type> definitions, List<? extends Type> captures) {
            this.definitions = definitions;
            this.captures = captures;
        }
    }

    private static class RecursiveMatchResult {
        private final List<Type> argumentsOfMatch;
        private final List<RecursiveMatchLevel> recursiveMatchLevels;

        public RecursiveMatchResult(List<Type> argumentsOfMatch, List<RecursiveMatchLevel> recursiveMatchLevels) {
            this.argumentsOfMatch = argumentsOfMatch;
            this.recursiveMatchLevels = recursiveMatchLevels;
        }
    }
}

