/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.nativeimage.NativeImageSystemPropertyBuildItem;
import io.quarkus.deployment.pkg.NativeConfig;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.BuildSystemTargetBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageSourceJarBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.pkg.builditem.ProcessInheritIODisabled;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.deployment.pkg.steps.NativeImageBuildLocalContainerRunner;
import io.quarkus.deployment.pkg.steps.NativeImageBuildLocalRunner;
import io.quarkus.deployment.pkg.steps.NativeImageBuildRemoteContainerRunner;
import io.quarkus.deployment.pkg.steps.NativeImageBuildRunner;
import io.quarkus.deployment.pkg.steps.NativeSourcesBuild;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.SystemUtils;
import org.jboss.logging.Logger;

public class NativeImageBuildStep {
    private static final Logger log = Logger.getLogger(NativeImageBuildStep.class);
    public static final String DEBUG_BUILD_PROCESS_PORT = "5005";
    private static final String JAVA_HOME_SYS = "java.home";
    private static final String JAVA_HOME_ENV = "JAVA_HOME";
    private static final String PATH = "PATH";
    private static final int OOM_ERROR_VALUE = 137;
    private static final String QUARKUS_XMX_PROPERTY = "quarkus.native.native-image-xmx";
    public static final String CONTAINER_BUILD_VOLUME_PATH = "/project";
    private static final String TRUST_STORE_SYSTEM_PROPERTY_MARKER = "-Djavax.net.ssl.trustStore=";
    private static final String MOVED_TRUST_STORE_NAME = "trustStore";
    public static final String APP_SOURCES = "app-sources";

    @BuildStep(onlyIf={NativeBuild.class})
    ArtifactResultBuildItem result(NativeImageBuildItem image) {
        return new ArtifactResultBuildItem(image.getPath(), "native", Collections.emptyMap());
    }

    @BuildStep(onlyIf={NativeSourcesBuild.class})
    ArtifactResultBuildItem nativeSourcesResult(NativeConfig nativeConfig, BuildSystemTargetBuildItem buildSystemTargetBuildItem, NativeImageSourceJarBuildItem nativeImageSourceJarBuildItem, OutputTargetBuildItem outputTargetBuildItem, PackageConfig packageConfig, List<NativeImageSystemPropertyBuildItem> nativeImageProperties) {
        Path outputDir;
        try {
            outputDir = buildSystemTargetBuildItem.getOutputDirectory().resolve("native-sources");
            IoUtils.createOrEmptyDir((Path)outputDir);
            IoUtils.copy((Path)nativeImageSourceJarBuildItem.getPath().getParent(), (Path)outputDir);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to create native-sources output directory", e);
        }
        Path runnerJar = outputDir.resolve(nativeImageSourceJarBuildItem.getPath().getFileName());
        String nativeImageName = this.getNativeImageName(outputTargetBuildItem, packageConfig);
        NativeImageInvokerInfo nativeImageArgs = new NativeImageInvokerInfo.Builder().setNativeConfig(nativeConfig).setOutputTargetBuildItem(outputTargetBuildItem).setNativeImageProperties(nativeImageProperties).setOutputDir(outputDir).setRunnerJarName(runnerJar.getFileName().toString()).setNativeImageName(nativeImageName).setContainerBuild(nativeConfig.containerRuntime.isPresent() || nativeConfig.containerBuild).build();
        List<String> command = nativeImageArgs.getArgs();
        try (FileOutputStream commandFOS = new FileOutputStream(outputDir.resolve("native-image.args").toFile());){
            String commandStr = String.join((CharSequence)" ", command);
            commandFOS.write(commandStr.getBytes(StandardCharsets.UTF_8));
            log.info((Object)("The sources for a subsequent native-image run along with the necessary arguments can be found in " + outputDir));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to build native image sources", e);
        }
        IoUtils.recursiveDelete((Path)nativeImageSourceJarBuildItem.getPath().getParent());
        return new ArtifactResultBuildItem(nativeImageSourceJarBuildItem.getPath(), "native-sources", Collections.emptyMap());
    }

    @BuildStep
    public NativeImageBuildItem build(NativeConfig nativeConfig, NativeImageSourceJarBuildItem nativeImageSourceJarBuildItem, OutputTargetBuildItem outputTargetBuildItem, PackageConfig packageConfig, CurateOutcomeBuildItem curateOutcomeBuildItem, List<NativeImageSystemPropertyBuildItem> nativeImageProperties, Optional<ProcessInheritIODisabled> processInheritIODisabled) {
        if (nativeConfig.debug.enabled) {
            this.copyJarSourcesToLib(outputTargetBuildItem, curateOutcomeBuildItem);
            NativeImageBuildStep.copySourcesToSourceCache(outputTargetBuildItem);
        }
        Path runnerJar = nativeImageSourceJarBuildItem.getPath();
        log.info((Object)("Building native image from " + runnerJar));
        Path outputDir = nativeImageSourceJarBuildItem.getPath().getParent();
        String runnerJarName = runnerJar.getFileName().toString();
        String noPIE = "";
        boolean isContainerBuild = NativeImageBuildStep.isContainerBuild(nativeConfig);
        if (!isContainerBuild && SystemUtils.IS_OS_LINUX) {
            noPIE = NativeImageBuildStep.detectNoPIE();
        }
        String nativeImageName = this.getNativeImageName(outputTargetBuildItem, packageConfig);
        String resultingExecutableName = this.getResultingExecutableName(nativeImageName, isContainerBuild);
        NativeImageBuildRunner buildRunner = NativeImageBuildStep.getNativeImageBuildRunner(nativeConfig, outputDir, resultingExecutableName);
        buildRunner.setup(processInheritIODisabled.isPresent());
        GraalVM.Version graalVMVersion = buildRunner.getGraalVMVersion();
        if (graalVMVersion.isDetected()) {
            this.checkGraalVMVersion(graalVMVersion);
        } else {
            log.error((Object)"Unable to get GraalVM version from the native-image binary.");
        }
        try {
            NativeImageInvokerInfo commandAndExecutable;
            List nativeImageArgs;
            int exitCode;
            if (nativeConfig.cleanupServer && !graalVMVersion.isMandrel()) {
                buildRunner.cleanupServer(outputDir.toFile());
            }
            if ((exitCode = buildRunner.build(nativeImageArgs = (commandAndExecutable = new NativeImageInvokerInfo.Builder().setNativeConfig(nativeConfig).setOutputTargetBuildItem(outputTargetBuildItem).setNativeImageProperties(nativeImageProperties).setOutputDir(outputDir).setRunnerJarName(runnerJarName).setNativeImageName(nativeImageName).setNoPIE(noPIE).setContainerBuild(isContainerBuild).setGraalVMVersion(graalVMVersion).build()).args, outputDir, processInheritIODisabled.isPresent())) != 0) {
                throw this.imageGenerationFailed(exitCode, nativeImageArgs);
            }
            Path generatedExecutablePath = outputDir.resolve(resultingExecutableName);
            Path finalExecutablePath = outputTargetBuildItem.getOutputDirectory().resolve(resultingExecutableName);
            IoUtils.copy((Path)generatedExecutablePath, (Path)finalExecutablePath);
            Files.delete(generatedExecutablePath);
            if (nativeConfig.debug.enabled) {
                String sources = "sources";
                Path generatedSources = outputDir.resolve("sources");
                Path finalSources = outputTargetBuildItem.getOutputDirectory().resolve("sources");
                IoUtils.copy((Path)generatedSources, (Path)finalSources);
                IoUtils.recursiveDelete((Path)generatedSources);
            }
            System.setProperty("native.image.path", finalExecutablePath.toAbsolutePath().toString());
            if (this.objcopyExists()) {
                if (nativeConfig.debug.enabled) {
                    this.splitDebugSymbols(finalExecutablePath);
                }
                NativeImageBuildStep.objcopy("--strip-debug", finalExecutablePath.toString());
            } else {
                log.warn((Object)"objcopy executable not found in PATH. Debug symbols will not be separated from executable.");
                log.warn((Object)"That will result in a larger native image with debug symbols embedded in it.");
            }
            NativeImageBuildItem nativeImageBuildItem = new NativeImageBuildItem(finalExecutablePath);
            return nativeImageBuildItem;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to build native image", e);
        }
        finally {
            if (nativeConfig.debug.enabled) {
                this.removeJarSourcesFromLib(outputTargetBuildItem);
                IoUtils.recursiveDelete((Path)outputDir.resolve(Paths.get(APP_SOURCES, new String[0])));
            }
        }
    }

    private String getNativeImageName(OutputTargetBuildItem outputTargetBuildItem, PackageConfig packageConfig) {
        return outputTargetBuildItem.getBaseName() + packageConfig.runnerSuffix;
    }

    private String getResultingExecutableName(String nativeImageName, boolean isContainerBuild) {
        String resultingExecutableName = nativeImageName;
        if (SystemUtils.IS_OS_WINDOWS && !isContainerBuild) {
            resultingExecutableName = resultingExecutableName + ".exe";
        }
        return resultingExecutableName;
    }

    public static boolean isContainerBuild(NativeConfig nativeConfig) {
        return nativeConfig.containerRuntime.isPresent() || nativeConfig.containerBuild || nativeConfig.remoteContainerBuild;
    }

    private static NativeImageBuildRunner getNativeImageBuildRunner(NativeConfig nativeConfig, Path outputDir, String resultingExecutableName) {
        if (!NativeImageBuildStep.isContainerBuild(nativeConfig)) {
            NativeImageBuildLocalRunner localRunner = NativeImageBuildStep.getNativeImageBuildLocalRunner(nativeConfig);
            if (localRunner != null) {
                return localRunner;
            }
            String executableName = NativeImageBuildStep.getNativeImageExecutableName();
            String errorMessage = "Cannot find the `" + executableName + "` in the GRAALVM_HOME, JAVA_HOME and System PATH. Install it using `gu install native-image`";
            if (!SystemUtils.IS_OS_LINUX) {
                throw new RuntimeException(errorMessage);
            }
            log.warn((Object)(errorMessage + " Attempting to fall back to container build."));
        }
        if (nativeConfig.remoteContainerBuild) {
            return new NativeImageBuildRemoteContainerRunner(nativeConfig, outputDir, resultingExecutableName);
        }
        return new NativeImageBuildLocalContainerRunner(nativeConfig, outputDir);
    }

    private void copyJarSourcesToLib(OutputTargetBuildItem outputTargetBuildItem, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        Path targetDirectory = outputTargetBuildItem.getOutputDirectory().resolve(outputTargetBuildItem.getBaseName() + "-native-image-source-jar");
        Path libDir = targetDirectory.resolve("lib");
        File libDirFile = libDir.toFile();
        if (!libDirFile.exists()) {
            libDirFile.mkdirs();
        }
        List appDeps = curateOutcomeBuildItem.getEffectiveModel().getUserDependencies();
        for (AppDependency appDep : appDeps) {
            AppArtifact depArtifact = appDep.getArtifact();
            if (!depArtifact.getType().equals("jar")) continue;
            for (Path resolvedDep : depArtifact.getPaths()) {
                Path jarSourceDep;
                if (Files.isDirectory(resolvedDep, new LinkOption[0]) || !(jarSourceDep = NativeImageBuildStep.toJarSource(resolvedDep)).toFile().exists()) continue;
                String fileName = depArtifact.getGroupId() + "." + jarSourceDep.getFileName();
                Path targetPath = libDir.resolve(fileName);
                try {
                    Files.copy(jarSourceDep, targetPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to copy from " + jarSourceDep + " to " + targetPath, e);
                }
            }
        }
    }

    private static Path toJarSource(Path path) {
        Path parent = path.getParent();
        String fileName = path.getFileName().toString();
        int extensionIndex = fileName.lastIndexOf(46);
        String sourcesFileName = String.format("%s-sources.jar", fileName.substring(0, extensionIndex));
        return parent.resolve(sourcesFileName);
    }

    private void removeJarSourcesFromLib(OutputTargetBuildItem outputTargetBuildItem) {
        Path targetDirectory = outputTargetBuildItem.getOutputDirectory().resolve(outputTargetBuildItem.getBaseName() + "-native-image-source-jar");
        Path libDir = targetDirectory.resolve("lib");
        File[] jarSources = libDir.toFile().listFiles((file, name) -> name.endsWith("-sources.jar"));
        Stream.of((Object[])Objects.requireNonNull(jarSources)).forEach(File::delete);
    }

    private static void copySourcesToSourceCache(OutputTargetBuildItem outputTargetBuildItem) {
        Path javaSourcesPath;
        Path targetDirectory = outputTargetBuildItem.getOutputDirectory().resolve(outputTargetBuildItem.getBaseName() + "-native-image-source-jar");
        Path targetSrc = targetDirectory.resolve(Paths.get(APP_SOURCES, new String[0]));
        File targetSrcFile = targetSrc.toFile();
        if (!targetSrcFile.exists()) {
            targetSrcFile.mkdirs();
        }
        if (Files.exists(javaSourcesPath = outputTargetBuildItem.getOutputDirectory().resolve(Paths.get("..", "src", "main", "java")), new LinkOption[0])) {
            try (Stream<Path> paths = Files.walk(javaSourcesPath, new FileVisitOption[0]);){
                paths.forEach(path -> {
                    Path targetPath = Paths.get(targetSrc.toString(), path.toString().substring(javaSourcesPath.toString().length()));
                    try {
                        Files.copy(path, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("Unable to copy from " + path + " to " + targetPath, e);
                    }
                });
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to walk path " + javaSourcesPath, e);
            }
        }
    }

    private RuntimeException imageGenerationFailed(int exitValue, List<String> command) {
        if (exitValue == 137) {
            if (command.contains("docker") && !SystemUtils.IS_OS_LINUX) {
                return new RuntimeException("Image generation failed. Exit code was " + exitValue + " which indicates an out of memory error. The most likely cause is Docker not being given enough memory. Also consider increasing the Xmx value for native image generation by setting the \"" + QUARKUS_XMX_PROPERTY + "\" property");
            }
            return new RuntimeException("Image generation failed. Exit code was " + exitValue + " which indicates an out of memory error. Consider increasing the Xmx value for native image generation by setting the \"" + QUARKUS_XMX_PROPERTY + "\" property");
        }
        return new RuntimeException("Image generation failed. Exit code: " + exitValue);
    }

    private void checkGraalVMVersion(GraalVM.Version version) {
        log.info((Object)("Running Quarkus native-image plugin on " + version.getFullVersion()));
        if (version.isObsolete()) {
            int major = GraalVM.Version.CURRENT.major;
            int minor = GraalVM.Version.CURRENT.minor;
            throw new IllegalStateException("Out of date version of GraalVM detected: " + version.getFullVersion() + ". Quarkus currently supports " + major + "." + minor + ". Please upgrade GraalVM to this version.");
        }
    }

    private static NativeImageBuildLocalRunner getNativeImageBuildLocalRunner(NativeConfig nativeConfig) {
        File file;
        File file2;
        String executableName = NativeImageBuildStep.getNativeImageExecutableName();
        if (nativeConfig.graalvmHome.isPresent() && (file2 = Paths.get(nativeConfig.graalvmHome.get(), "bin", executableName).toFile()).exists()) {
            return new NativeImageBuildLocalRunner(file2.getAbsolutePath());
        }
        File javaHome = nativeConfig.javaHome;
        if (javaHome == null) {
            String home = System.getProperty(JAVA_HOME_SYS);
            if (home == null) {
                home = System.getenv(JAVA_HOME_ENV);
            }
            if (home != null) {
                javaHome = new File(home);
            }
        }
        if (javaHome != null && (file = new File(javaHome, "bin/" + executableName)).exists()) {
            return new NativeImageBuildLocalRunner(file.getAbsolutePath());
        }
        String systemPath = System.getenv(PATH);
        if (systemPath != null) {
            String[] pathDirs;
            for (String pathDir : pathDirs = systemPath.split(File.pathSeparator)) {
                File file3;
                File dir = new File(pathDir);
                if (!dir.isDirectory() || !(file3 = new File(dir, executableName)).exists()) continue;
                return new NativeImageBuildLocalRunner(file3.getAbsolutePath());
            }
        }
        return null;
    }

    private static String getNativeImageExecutableName() {
        return SystemUtils.IS_OS_WINDOWS ? "native-image.cmd" : "native-image";
    }

    private static String detectNoPIE() {
        String argument = NativeImageBuildStep.testGCCArgument("-no-pie");
        return argument.length() == 0 ? NativeImageBuildStep.testGCCArgument("-nopie") : argument;
    }

    private static String testGCCArgument(String argument) {
        try {
            Process gcc = new ProcessBuilder("cc", "-v", "-E", argument, "-").start();
            gcc.getOutputStream().close();
            if (gcc.waitFor() == 0) {
                return argument;
            }
        }
        catch (IOException | InterruptedException exception) {
            // empty catch block
        }
        return "";
    }

    private boolean objcopyExists() {
        String systemPath = System.getenv(PATH);
        if (systemPath != null) {
            String[] pathDirs;
            for (String pathDir : pathDirs = systemPath.split(File.pathSeparator)) {
                File file;
                File dir = new File(pathDir);
                if (!dir.isDirectory() || !(file = new File(dir, "objcopy")).exists()) continue;
                return true;
            }
        }
        return false;
    }

    private void splitDebugSymbols(Path executable) {
        Path symbols = Paths.get(String.format("%s.debug", executable.toString()), new String[0]);
        NativeImageBuildStep.objcopy("--only-keep-debug", executable.toString(), symbols.toString());
        NativeImageBuildStep.objcopy(String.format("--add-gnu-debuglink=%s", symbols.toString()), executable.toString());
    }

    private static void objcopy(String ... args) {
        ArrayList<String> command = new ArrayList<String>(args.length + 1);
        command.add("objcopy");
        command.addAll(Arrays.asList(args));
        if (log.isDebugEnabled()) {
            log.debugf("Execute %s", (Object)String.join((CharSequence)" ", command));
        }
        Process process = null;
        try {
            process = new ProcessBuilder(command).start();
            process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Unable to invoke objcopy", e);
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }

    private static class NativeImageInvokerInfo {
        private final List<String> args;

        private NativeImageInvokerInfo(List<String> args) {
            this.args = args;
        }

        List<String> getArgs() {
            return this.args;
        }

        static class Builder {
            private NativeConfig nativeConfig;
            private OutputTargetBuildItem outputTargetBuildItem;
            private List<NativeImageSystemPropertyBuildItem> nativeImageProperties;
            private Path outputDir;
            private String runnerJarName;
            private String noPIE = "";
            private boolean isContainerBuild = false;
            private GraalVM.Version graalVMVersion = GraalVM.Version.UNVERSIONED;
            private String nativeImageName;

            Builder() {
            }

            public Builder setNativeConfig(NativeConfig nativeConfig) {
                this.nativeConfig = nativeConfig;
                return this;
            }

            public Builder setOutputTargetBuildItem(OutputTargetBuildItem outputTargetBuildItem) {
                this.outputTargetBuildItem = outputTargetBuildItem;
                return this;
            }

            public Builder setNativeImageProperties(List<NativeImageSystemPropertyBuildItem> nativeImageProperties) {
                this.nativeImageProperties = nativeImageProperties;
                return this;
            }

            public Builder setOutputDir(Path outputDir) {
                this.outputDir = outputDir;
                return this;
            }

            public Builder setRunnerJarName(String runnerJarName) {
                this.runnerJarName = runnerJarName;
                return this;
            }

            public Builder setNoPIE(String noPIE) {
                this.noPIE = noPIE;
                return this;
            }

            public Builder setContainerBuild(boolean containerBuild) {
                this.isContainerBuild = containerBuild;
                return this;
            }

            public Builder setGraalVMVersion(GraalVM.Version graalVMVersion) {
                this.graalVMVersion = graalVMVersion;
                return this;
            }

            public Builder setNativeImageName(String nativeImageName) {
                this.nativeImageName = nativeImageName;
                return this;
            }

            public NativeImageInvokerInfo build() {
                ArrayList<String> nativeImageArgs = new ArrayList<String>();
                boolean enableSslNative = false;
                boolean enableAllSecurityServices = this.nativeConfig.enableAllSecurityServices;
                boolean addAllCharsets = this.nativeConfig.addAllCharsets;
                boolean enableHttpsUrlHandler = this.nativeConfig.enableHttpsUrlHandler;
                for (NativeImageSystemPropertyBuildItem prop : this.nativeImageProperties) {
                    if (prop.getKey().equals("quarkus.ssl.native") && prop.getValue() != null) {
                        enableSslNative = Boolean.parseBoolean(prop.getValue());
                        continue;
                    }
                    if (prop.getKey().equals("quarkus.jni.enable") && prop.getValue().equals("false")) {
                        log.warn((Object)"Your application is setting the deprecated 'quarkus.jni.enable' configuration key to false. Please consider removing this configuration key as it is ignored (JNI is always enabled) and it will be removed in a future Quarkus version.");
                        continue;
                    }
                    if (prop.getKey().equals("quarkus.native.enable-all-security-services") && prop.getValue() != null) {
                        enableAllSecurityServices |= Boolean.parseBoolean(prop.getValue());
                        continue;
                    }
                    if (prop.getKey().equals("quarkus.native.enable-all-charsets") && prop.getValue() != null) {
                        addAllCharsets |= Boolean.parseBoolean(prop.getValue());
                        continue;
                    }
                    if (prop.getValue() == null) {
                        nativeImageArgs.add("-J-D" + prop.getKey());
                        continue;
                    }
                    nativeImageArgs.add("-J-D" + prop.getKey() + "=" + prop.getValue());
                }
                if (this.nativeConfig.userLanguage.isPresent()) {
                    nativeImageArgs.add("-J-Duser.language=" + this.nativeConfig.userLanguage.get());
                }
                if (this.nativeConfig.userCountry.isPresent()) {
                    nativeImageArgs.add("-J-Duser.country=" + this.nativeConfig.userCountry.get());
                }
                nativeImageArgs.add("-J-Dfile.encoding=" + this.nativeConfig.fileEncoding);
                if (enableSslNative) {
                    enableHttpsUrlHandler = true;
                    enableAllSecurityServices = true;
                }
                this.handleAdditionalProperties(this.nativeConfig, nativeImageArgs, this.isContainerBuild, this.outputDir);
                nativeImageArgs.add("--initialize-at-build-time=");
                nativeImageArgs.add("-H:InitialCollectionPolicy=com.oracle.svm.core.genscavenge.CollectionPolicy$BySpaceAndTime");
                nativeImageArgs.add("-H:+JNI");
                nativeImageArgs.add("-H:+AllowFoldMethods");
                nativeImageArgs.add("-jar");
                nativeImageArgs.add(this.runnerJarName);
                if (this.nativeConfig.enableFallbackImages) {
                    nativeImageArgs.add("-H:FallbackThreshold=5");
                } else {
                    nativeImageArgs.add("-H:FallbackThreshold=0");
                }
                if (this.nativeConfig.reportErrorsAtRuntime) {
                    nativeImageArgs.add("-H:+ReportUnsupportedElementsAtRuntime");
                }
                if (this.nativeConfig.reportExceptionStackTraces) {
                    nativeImageArgs.add("-H:+ReportExceptionStackTraces");
                }
                if (this.nativeConfig.debug.enabled) {
                    nativeImageArgs.add("-g");
                    nativeImageArgs.add("-H:DebugInfoSourceSearchPath=app-sources");
                }
                if (this.nativeConfig.debugBuildProcess) {
                    nativeImageArgs.add("-J-Xrunjdwp:transport=dt_socket,address=5005,server=y,suspend=y");
                }
                if (this.nativeConfig.enableReports) {
                    nativeImageArgs.add("-H:+PrintAnalysisCallTree");
                }
                if (this.nativeConfig.dumpProxies) {
                    nativeImageArgs.add("-Dsun.misc.ProxyGenerator.saveGeneratedFiles=true");
                    if (this.nativeConfig.enableServer) {
                        log.warn((Object)"Options dumpProxies and enableServer are both enabled: this will get the proxies dumped in an unknown external working directory");
                    }
                }
                if (this.nativeConfig.nativeImageXmx.isPresent()) {
                    nativeImageArgs.add("-J-Xmx" + this.nativeConfig.nativeImageXmx.get());
                }
                ArrayList<String> protocols = new ArrayList<String>(2);
                if (this.nativeConfig.enableHttpUrlHandler) {
                    protocols.add("http");
                }
                if (enableHttpsUrlHandler) {
                    protocols.add("https");
                }
                if (addAllCharsets) {
                    nativeImageArgs.add("-H:+AddAllCharsets");
                } else {
                    nativeImageArgs.add("-H:-AddAllCharsets");
                }
                if (!protocols.isEmpty()) {
                    nativeImageArgs.add("-H:EnableURLProtocols=" + String.join((CharSequence)",", protocols));
                }
                if (enableAllSecurityServices) {
                    nativeImageArgs.add("--enable-all-security-services");
                }
                if (!this.noPIE.isEmpty()) {
                    nativeImageArgs.add("-H:NativeLinkerOption=" + this.noPIE);
                }
                if (!this.nativeConfig.enableIsolates) {
                    nativeImageArgs.add("-H:-SpawnIsolates");
                }
                if (!this.nativeConfig.enableJni) {
                    log.warn((Object)"Your application is setting the deprecated 'quarkus.native.enable-jni' configuration key to false. Please consider removing this configuration key as it is ignored (JNI is always enabled) and it will be removed in a future Quarkus version.");
                }
                if (!(this.nativeConfig.enableServer || SystemUtils.IS_OS_WINDOWS || this.graalVMVersion.isMandrel())) {
                    nativeImageArgs.add("--no-server");
                }
                if (this.nativeConfig.enableVmInspection) {
                    nativeImageArgs.add("-H:+AllowVMInspection");
                }
                if (this.nativeConfig.autoServiceLoaderRegistration) {
                    nativeImageArgs.add("-H:+UseServiceLoaderFeature");
                    nativeImageArgs.add("-H:+TraceServiceLoaderFeature");
                } else {
                    nativeImageArgs.add("-H:-UseServiceLoaderFeature");
                }
                if (this.nativeConfig.fullStackTraces) {
                    nativeImageArgs.add("-H:+StackTrace");
                } else {
                    nativeImageArgs.add("-H:-StackTrace");
                }
                if (this.nativeConfig.enableDashboardDump) {
                    nativeImageArgs.add("-H:DashboardDump=" + this.outputTargetBuildItem.getBaseName() + "_dashboard.dump");
                    nativeImageArgs.add("-H:+DashboardAll");
                }
                nativeImageArgs.add(this.nativeImageName);
                return new NativeImageInvokerInfo(nativeImageArgs);
            }

            private void handleAdditionalProperties(NativeConfig nativeConfig, List<String> command, boolean isContainerBuild, Path outputDir) {
                if (nativeConfig.additionalBuildArgs.isPresent()) {
                    List<String> strings = nativeConfig.additionalBuildArgs.get();
                    for (String buildArg : strings) {
                        String trimmedBuildArg = buildArg.trim();
                        if (trimmedBuildArg.contains(NativeImageBuildStep.TRUST_STORE_SYSTEM_PROPERTY_MARKER) && isContainerBuild) {
                            int index = trimmedBuildArg.indexOf(NativeImageBuildStep.TRUST_STORE_SYSTEM_PROPERTY_MARKER);
                            if (trimmedBuildArg.length() <= index + 2) continue;
                            String configuredTrustStorePath = trimmedBuildArg.substring(index + NativeImageBuildStep.TRUST_STORE_SYSTEM_PROPERTY_MARKER.length());
                            try {
                                IoUtils.copy((Path)Paths.get(configuredTrustStorePath, new String[0]), (Path)outputDir.resolve(NativeImageBuildStep.MOVED_TRUST_STORE_NAME));
                                command.add(trimmedBuildArg.substring(0, index) + NativeImageBuildStep.TRUST_STORE_SYSTEM_PROPERTY_MARKER + NativeImageBuildStep.CONTAINER_BUILD_VOLUME_PATH + "/" + NativeImageBuildStep.MOVED_TRUST_STORE_NAME);
                                continue;
                            }
                            catch (IOException e) {
                                throw new UncheckedIOException("Unable to copy trustStore file '" + configuredTrustStorePath + "' to volume root directory '" + outputDir.toAbsolutePath().toString() + "'", e);
                            }
                        }
                        command.add(trimmedBuildArg);
                    }
                }
            }
        }
    }

    protected static final class GraalVM {
        protected GraalVM() {
        }

        static enum Distribution {
            ORACLE,
            MANDREL;

        }

        static final class Version
        implements Comparable<Version> {
            private static final Pattern PATTERN = Pattern.compile("GraalVM Version (([1-9][0-9]*)\\.([0-9]+)\\.[0-9]+|\\p{XDigit}*)[^(\n$]*(\\(Mandrel Distribution\\))?\\s*");
            static final Version UNVERSIONED = new Version("Undefined", -1, -1, Distribution.ORACLE);
            static final Version SNAPSHOT_ORACLE = new Version("Snapshot", Integer.MAX_VALUE, Integer.MAX_VALUE, Distribution.ORACLE);
            static final Version SNAPSHOT_MANDREL = new Version("Snapshot", Integer.MAX_VALUE, Integer.MAX_VALUE, Distribution.MANDREL);
            static final Version VERSION_20_3 = new Version("GraalVM 20.3", 20, 3, Distribution.ORACLE);
            static final Version VERSION_21_0 = new Version("GraalVM 21.0", 21, 0, Distribution.ORACLE);
            static final Version MINIMUM = VERSION_20_3;
            static final Version CURRENT = VERSION_21_0;
            final String fullVersion;
            final int major;
            final int minor;
            final Distribution distribution;

            Version(String fullVersion, int major, int minor, Distribution distro) {
                this.fullVersion = fullVersion;
                this.major = major;
                this.minor = minor;
                this.distribution = distro;
            }

            String getFullVersion() {
                return this.fullVersion;
            }

            boolean isDetected() {
                return this != UNVERSIONED;
            }

            boolean isObsolete() {
                return this.compareTo(MINIMUM) < 0;
            }

            boolean isMandrel() {
                return this.distribution == Distribution.MANDREL;
            }

            boolean isSnapshot() {
                return this == SNAPSHOT_ORACLE || this == SNAPSHOT_MANDREL;
            }

            boolean isNewerThan(Version version) {
                return this.compareTo(version) > 0;
            }

            @Override
            public int compareTo(Version o) {
                if (this.major > o.major) {
                    return 1;
                }
                if (this.major == o.major) {
                    if (this.minor > o.minor) {
                        return 1;
                    }
                    if (this.minor == o.minor) {
                        return 0;
                    }
                }
                return -1;
            }

            static Version of(Stream<String> lines) {
                Iterator it = lines.iterator();
                while (it.hasNext()) {
                    String line = (String)it.next();
                    Matcher matcher = PATTERN.matcher(line);
                    if (!matcher.find() || matcher.groupCount() < 3) continue;
                    String distro = matcher.group(4);
                    if (Version.isSnapshot(matcher.group(2))) {
                        return Version.isMandrel(distro) ? SNAPSHOT_MANDREL : SNAPSHOT_ORACLE;
                    }
                    return new Version(line, Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), Version.isMandrel(distro) ? Distribution.MANDREL : Distribution.ORACLE);
                }
                return UNVERSIONED;
            }

            private static boolean isSnapshot(String s) {
                return s == null;
            }

            private static boolean isMandrel(String s) {
                return "(Mandrel Distribution)".equals(s);
            }

            public String toString() {
                return "Version{major=" + this.major + ", minor=" + this.minor + ", distribution=" + (Object)((Object)this.distribution) + '}';
            }
        }
    }
}

