/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classloader;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.IoActions;
import org.gradle.internal.classloader.ClassLoaderHierarchy;
import org.gradle.internal.classloader.ClassLoaderSpec;
import org.gradle.internal.classloader.ClassLoaderVisitor;
import org.gradle.internal.classloader.InstrumentingClassLoader;
import org.gradle.internal.classloader.TransformErrorHandler;
import org.gradle.internal.classloader.TransformReplacer;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.TransformedClassPath;
import org.gradle.internal.impldep.javax.annotation.Nullable;

public class VisitableURLClassLoader
extends URLClassLoader
implements ClassLoaderHierarchy {
    private final Map<Object, Object> userData = new HashMap<Object, Object>();
    private final String name;

    public synchronized <T> T getUserData(Object consumerId, Factory<T> onMiss) {
        if (this.userData.containsKey(consumerId)) {
            return Cast.uncheckedCast(this.userData.get(consumerId));
        }
        T value = onMiss.create();
        this.userData.put(consumerId, value);
        return value;
    }

    public VisitableURLClassLoader(String name, ClassLoader parent, Collection<URL> urls) {
        this(name, urls.toArray(new URL[0]), parent);
    }

    protected VisitableURLClassLoader(String name, ClassLoader parent, ClassPath classPath) {
        this(name, classPath.getAsURLArray(), parent);
        if (classPath instanceof TransformedClassPath && !(this instanceof InstrumentingClassLoader)) {
            throw new IllegalArgumentException("Cannot build a non-instrumenting class loader " + name + " out of transformed class path");
        }
    }

    private VisitableURLClassLoader(String name, URL[] classpath, ClassLoader parent) {
        super(classpath, parent);
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.name + ")";
    }

    @Override
    public void visit(ClassLoaderVisitor visitor) {
        URL[] urls = this.getURLs();
        visitor.visitSpec(new Spec(this.name, Arrays.asList(urls)));
        visitor.visitClassPath(urls);
        visitor.visitParent(this.getParent());
    }

    public static VisitableURLClassLoader fromClassPath(String name, ClassLoader parent, ClassPath classPath) {
        if (classPath instanceof TransformedClassPath) {
            return new InstrumentingVisitableURLClassLoader(name, parent, (TransformedClassPath)classPath);
        }
        return new VisitableURLClassLoader(name, parent, classPath);
    }

    static {
        try {
            ClassLoader.registerAsParallelCapable();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    private static class InstrumentingVisitableURLClassLoader
    extends VisitableURLClassLoader
    implements InstrumentingClassLoader {
        private final TransformReplacer replacer;
        private final TransformErrorHandler errorHandler;

        public InstrumentingVisitableURLClassLoader(String name, ClassLoader parent, TransformedClassPath classPath) {
            super(name, parent, classPath);
            this.replacer = new TransformReplacer(classPath);
            this.errorHandler = new TransformErrorHandler(name);
        }

        @Override
        public byte[] instrumentClass(@Nullable String className, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
            return this.replacer.getInstrumentedClass(className, protectionDomain);
        }

        @Override
        public void transformFailed(@Nullable String className, Throwable cause) {
            this.errorHandler.classLoadingError(className, cause);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            Class<?> loadedClass;
            this.errorHandler.enterClassLoadingScope(name);
            try {
                loadedClass = super.findClass(name);
            }
            catch (Throwable e) {
                throw this.errorHandler.exitClassLoadingScopeWithException(e);
            }
            this.errorHandler.exitClassLoadingScope();
            return loadedClass;
        }

        @Override
        public void close() throws IOException {
            IoActions.closeQuietly(this.replacer);
            super.close();
        }

        static {
            try {
                ClassLoader.registerAsParallelCapable();
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
    }

    public static class Spec
    extends ClassLoaderSpec {
        final String name;
        final List<URL> classpath;

        public String getName() {
            return this.name;
        }

        public Spec(String name, List<URL> classpath) {
            this.name = name;
            this.classpath = classpath;
        }

        public List<URL> getClasspath() {
            return this.classpath;
        }

        public String toString() {
            return "{url-class-loader name:" + this.name + ", classpath:" + this.classpath + "}";
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Spec other = (Spec)obj;
            return this.classpath.equals(other.classpath);
        }

        public int hashCode() {
            return this.classpath.hashCode();
        }
    }
}

