/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.devmode;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.maven.dependency.ResolvedDependency;
import java.util.ArrayList;
import java.util.List;
import org.jboss.logging.Logger;

public class DependenciesFilter {
    private static final Logger log = Logger.getLogger(DependenciesFilter.class);

    public static List<ResolvedDependency> getReloadableModules(ApplicationModel appModel) {
        ArrayList<ResolvedDependency> reloadable = new ArrayList<ResolvedDependency>();
        if (appModel.getApplicationModule() != null) {
            reloadable.add(appModel.getAppArtifact());
        }
        appModel.getDependencies().forEach(d -> {
            if (d.isReloadable()) {
                reloadable.add((ResolvedDependency)d);
            } else if (d.isWorkspaceModule()) {
                StringBuilder msg = new StringBuilder();
                msg.append("Local Quarkus extension dependency ");
                msg.append(d.getGroupId()).append(":").append(d.getArtifactId()).append(":");
                if (!d.getClassifier().isEmpty()) {
                    msg.append(d.getClassifier()).append(":");
                }
                if (!"jar".equals(d.getType())) {
                    msg.append(d.getType()).append(":");
                }
                msg.append(d.getVersion()).append(" will not be hot-reloadable");
                log.warn((Object)msg.toString());
            }
        });
        return reloadable;
    }
}

