/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model;

import io.quarkus.bootstrap.model.AppArtifactKey;
import java.io.Serializable;

public class AppArtifactCoords
implements Serializable {
    public static final String TYPE_JAR = "jar";
    public static final String TYPE_POM = "pom";
    protected final String groupId;
    protected final String artifactId;
    protected final String classifier;
    protected final String type;
    protected final String version;
    protected transient AppArtifactKey key;

    public static AppArtifactCoords fromString(String str) {
        return new AppArtifactCoords(AppArtifactCoords.split(str, new String[5]));
    }

    protected static String[] split(String str, String[] parts) {
        int versionSep = str.lastIndexOf(58);
        if (versionSep <= 0 || versionSep == str.length() - 1) {
            throw new IllegalArgumentException("One of type, version or separating them ':' is missing from '" + str + "'");
        }
        parts[4] = str.substring(versionSep + 1);
        AppArtifactKey.split(str, parts, versionSep);
        return parts;
    }

    protected AppArtifactCoords(String[] parts) {
        this.groupId = parts[0];
        this.artifactId = parts[1];
        this.classifier = parts[2];
        this.type = parts[3] == null ? TYPE_JAR : parts[3];
        this.version = parts[4];
    }

    public AppArtifactCoords(String groupId, String artifactId, String version) {
        this(groupId, artifactId, "", TYPE_JAR, version);
    }

    public AppArtifactCoords(String groupId, String artifactId, String type, String version) {
        this(groupId, artifactId, "", type, version);
    }

    public AppArtifactCoords(String groupId, String artifactId, String classifier, String type, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.classifier = classifier == null ? "" : classifier;
        this.type = type;
        this.version = version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public AppArtifactKey getKey() {
        return this.key == null ? (this.key = new AppArtifactKey(this.groupId, this.artifactId, this.classifier, this.type)) : this.key;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.classifier == null ? 0 : this.classifier.hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AppArtifactCoords other = (AppArtifactCoords)obj;
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        if (this.classifier == null ? other.classifier != null : !this.classifier.equals(other.classifier)) {
            return false;
        }
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.append(buf);
        return buf.toString();
    }

    protected StringBuilder append(StringBuilder buf) {
        buf.append(this.groupId).append(':').append(this.artifactId).append(':');
        if (!this.classifier.isEmpty()) {
            buf.append(this.classifier);
        }
        return buf.append(':').append(this.type).append(':').append(this.version);
    }
}

