/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.Unremovable;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.ArcConfig;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.ConfigInjectionStaticInitBuildItem;
import io.quarkus.arc.deployment.ConfigPropertyBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanConfigurator;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.arc.runtime.ConfigBeanCreator;
import io.quarkus.arc.runtime.ConfigMappingCreator;
import io.quarkus.arc.runtime.ConfigRecorder;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ConfigClassBuildItem;
import io.quarkus.deployment.builditem.ConfigMappingBuildItem;
import io.quarkus.deployment.builditem.ConfigPropertiesBuildItem;
import io.quarkus.deployment.builditem.ConfigurationBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.configuration.ConfigMappingUtils;
import io.quarkus.deployment.configuration.definition.RootDefinition;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.smallrye.config.ConfigMappings;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.WithConverter;
import io.smallrye.config.inject.ConfigProducer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.CreationException;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigValue;
import org.eclipse.microprofile.config.inject.ConfigProperties;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class ConfigBuildStep {
    private static final Logger LOGGER = Logger.getLogger((String)ConfigBuildStep.class.getName());
    private static final DotName MP_CONFIG = DotName.createSimple((String)Config.class.getName());
    private static final DotName MP_CONFIG_PROPERTY_NAME = DotName.createSimple((String)ConfigProperty.class.getName());
    private static final DotName MP_CONFIG_PROPERTIES_NAME = DotName.createSimple((String)ConfigProperties.class.getName());
    private static final DotName MP_CONFIG_VALUE_NAME = DotName.createSimple((String)ConfigValue.class.getName());
    private static final DotName SR_CONFIG = DotName.createSimple((String)SmallRyeConfig.class.getName());
    private static final DotName SR_CONFIG_VALUE_NAME = DotName.createSimple((String)io.smallrye.config.ConfigValue.class.getName());
    private static final DotName SR_WITH_CONVERTER = DotName.createSimple((String)WithConverter.class.getName());
    private static final DotName MAP_NAME = DotName.createSimple((String)Map.class.getName());
    private static final DotName SET_NAME = DotName.createSimple((String)Set.class.getName());
    private static final DotName LIST_NAME = DotName.createSimple((String)List.class.getName());
    private static final DotName SUPPLIER_NAME = DotName.createSimple((String)Supplier.class.getName());

    @BuildStep
    void additionalBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(ConfigProducer.class));
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(ConfigProperties.class));
    }

    @BuildStep
    void registerCustomConfigBeanTypes(BeanDiscoveryFinishedBuildItem beanDiscovery, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<SyntheticBeanBuildItem> syntheticBeans) {
        HashSet<Type> customBeanTypes = new HashSet<Type>();
        for (InjectionPointInfo injectionPoint : beanDiscovery.getInjectionPoints()) {
            Type injectedType;
            AnnotationInstance configProperty;
            if (injectionPoint.hasDefaultedQualifier() || (configProperty = injectionPoint.getRequiredQualifier(MP_CONFIG_PROPERTY_NAME)) == null || ConfigBuildStep.isHandledByProducers(injectedType = injectionPoint.getRequiredType())) continue;
            customBeanTypes.add(injectedType);
        }
        for (Type type : customBeanTypes) {
            if (type.kind() != Type.Kind.ARRAY) {
                reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{type.name().toString()}));
            }
            DotName implClazz = type.kind() == Type.Kind.ARRAY ? DotName.createSimple((String)ConfigBeanCreator.class.getName()) : type.name();
            syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(implClazz).creator(ConfigBeanCreator.class)).providerType(type)).types(new Type[]{type})).addQualifier(MP_CONFIG_PROPERTY_NAME)).param("requiredType", type.name().toString())).done());
        }
    }

    @BuildStep
    void validateConfigInjectionPoints(ValidationPhaseBuildItem validationPhase, BuildProducer<ConfigPropertyBuildItem> configProperties) {
        for (InjectionPointInfo injectionPoint : validationPhase.getContext().getInjectionPoints()) {
            Type injectedType;
            String propertyName;
            AnnotationInstance configProperty;
            if (injectionPoint.hasDefaultedQualifier() || (configProperty = injectionPoint.getRequiredQualifier(MP_CONFIG_PROPERTY_NAME)) == null) continue;
            AnnotationValue nameValue = configProperty.value("name");
            AnnotationValue defaultValue = configProperty.value("defaultValue");
            if (nameValue != null) {
                propertyName = nameValue.asString();
            } else if (injectionPoint.isField()) {
                FieldInfo field = injectionPoint.getTarget().asField();
                propertyName = ConfigBuildStep.getPropertyName(field.name(), field.declaringClass());
            } else if (injectionPoint.isParam()) {
                MethodInfo method = injectionPoint.getTarget().asMethod();
                propertyName = ConfigBuildStep.getPropertyName(method.parameterName(injectionPoint.getPosition()), method.declaringClass());
            } else {
                throw new IllegalStateException("Unsupported injection point target: " + injectionPoint);
            }
            if (DotNames.OPTIONAL.equals((Object)(injectedType = injectionPoint.getType()).name()) || DotNames.OPTIONAL_INT.equals((Object)injectedType.name()) || DotNames.OPTIONAL_LONG.equals((Object)injectedType.name()) || DotNames.OPTIONAL_DOUBLE.equals((Object)injectedType.name()) || DotNames.INSTANCE.equals((Object)injectedType.name()) || DotNames.PROVIDER.equals((Object)injectedType.name()) || SUPPLIER_NAME.equals((Object)injectedType.name()) || SR_CONFIG_VALUE_NAME.equals((Object)injectedType.name()) || MP_CONFIG_VALUE_NAME.equals((Object)injectedType.name())) continue;
            String propertyDefaultValue = null;
            if (defaultValue != null && ("org.eclipse.microprofile.config.configproperty.unconfigureddvalue".equals(defaultValue.asString()) || !"".equals(defaultValue.asString()))) {
                propertyDefaultValue = defaultValue.asString();
            }
            configProperties.produce((BuildItem)new ConfigPropertyBuildItem(propertyName, injectedType, propertyDefaultValue));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void validateConfigValues(ConfigRecorder recorder, List<ConfigPropertyBuildItem> configProperties, BeanContainerBuildItem beanContainer, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        for (ConfigPropertyBuildItem item : configProperties) {
            Type requiredType = item.getPropertyType();
            String propertyType = requiredType.name().toString();
            if (requiredType.kind() == Type.Kind.PRIMITIVE) continue;
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{propertyType}));
        }
        HashSet<ConfigRecorder.ConfigValidationMetadata> propertiesToValidate = new HashSet<ConfigRecorder.ConfigValidationMetadata>();
        for (ConfigPropertyBuildItem configProperty : configProperties) {
            String rawTypeName = configProperty.getPropertyType().name().toString();
            List actualTypeArgumentNames = Collections.emptyList();
            if (configProperty.getPropertyType().kind() == Type.Kind.PARAMETERIZED_TYPE) {
                List argumentTypes = configProperty.getPropertyType().asParameterizedType().arguments();
                actualTypeArgumentNames = new ArrayList(argumentTypes.size());
                for (Type argumentType : argumentTypes) {
                    actualTypeArgumentNames.add(argumentType.name().toString());
                    if (argumentType.kind() == Type.Kind.PRIMITIVE) continue;
                    reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{argumentType.name().toString()}));
                }
            }
            propertiesToValidate.add(new ConfigRecorder.ConfigValidationMetadata(configProperty.getPropertyName(), rawTypeName, actualTypeArgumentNames, configProperty.getDefaultValue()));
        }
        recorder.validateConfigProperties(propertiesToValidate);
    }

    @BuildStep
    void registerConfigRootsAsBeans(ConfigurationBuildItem configItem, BuildProducer<SyntheticBeanBuildItem> syntheticBeans) {
        for (RootDefinition rootDefinition : configItem.getReadResult().getAllRoots()) {
            if (rootDefinition.getConfigPhase() != ConfigPhase.BUILD_AND_RUN_TIME_FIXED && rootDefinition.getConfigPhase() != ConfigPhase.RUN_TIME) continue;
            Class configRootClass = rootDefinition.getConfigurationClass();
            syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(configRootClass).types(new Class[]{configRootClass})).scope(Dependent.class)).creator(mc -> {
                ResultHandle configRoot = mc.readStaticField(rootDefinition.getDescriptor());
                mc.ifNull(configRoot).trueBranch().throwException(CreationException.class, String.format("Config root [%s] with config phase [%s] not initialized yet.", configRootClass.getName(), rootDefinition.getConfigPhase().name()));
                mc.returnValue(configRoot);
            })).done());
        }
    }

    @BuildStep
    AnnotationsTransformerBuildItem vetoMPConfigProperties() {
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return AnnotationTarget.Kind.CLASS.equals((Object)kind);
            }

            public void transform(AnnotationsTransformer.TransformationContext context) {
                if (context.getAnnotations().stream().anyMatch(annotation -> annotation.name().equals((Object)MP_CONFIG_PROPERTIES_NAME))) {
                    ((Transformation)((Transformation)context.transform().add(DotNames.VETOED, new AnnotationValue[0])).add(DotNames.UNREMOVABLE, new AnnotationValue[0])).done();
                }
            }
        });
    }

    @BuildStep
    void generateConfigClasses(CombinedIndexBuildItem combinedIndex, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<ConfigClassBuildItem> configClasses) {
        ConfigMappingUtils.generateConfigClasses((CombinedIndexBuildItem)combinedIndex, generatedClasses, reflectiveClasses, configClasses, (DotName)ConfigMappingUtils.CONFIG_MAPPING_NAME);
        ConfigMappingUtils.generateConfigClasses((CombinedIndexBuildItem)combinedIndex, generatedClasses, reflectiveClasses, configClasses, (DotName)MP_CONFIG_PROPERTIES_NAME);
    }

    @BuildStep
    void registerConfigMappingsBean(BeanRegistrationPhaseBuildItem beanRegistration, List<ConfigClassBuildItem> configClasses, CombinedIndexBuildItem combinedIndex, BuildProducer<BeanRegistrationPhaseBuildItem.BeanConfiguratorBuildItem> beanConfigurator) {
        if (configClasses.isEmpty()) {
            return;
        }
        HashSet<ConfigClassBuildItem> configMappings = new HashSet<ConfigClassBuildItem>();
        for (ConfigClassBuildItem configClass : configClasses) {
            if (!configClass.getConfigClass().isAnnotationPresent(Unremovable.class)) continue;
            configMappings.add(configClass);
        }
        Map<Type, ConfigClassBuildItem> configMappingTypes = ConfigBuildStep.configClassesToTypesMap(configClasses, ConfigClassBuildItem.Kind.MAPPING);
        for (InjectionPointInfo injectionPoint : beanRegistration.getInjectionPoints()) {
            Type type = Type.create((DotName)injectionPoint.getRequiredType().name(), (Type.Kind)Type.Kind.CLASS);
            ConfigClassBuildItem configClass = configMappingTypes.get(type);
            if (configClass == null) continue;
            configMappings.add(configClass);
        }
        for (ConfigClassBuildItem configClass : configMappings) {
            BeanConfigurator bean = (BeanConfigurator)((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)beanRegistration.getContext().configure(configClass.getConfigClass()).types(configClass.getTypes().toArray(new Type[0]))).creator(ConfigMappingCreator.class)).param("type", configClass.getConfigClass())).param("prefix", configClass.getPrefix());
            if (configClass.getConfigClass().isAnnotationPresent(Unremovable.class)) {
                bean.unremovable();
            }
            beanConfigurator.produce((BuildItem)new BeanRegistrationPhaseBuildItem.BeanConfiguratorBuildItem(bean));
        }
    }

    @BuildStep
    void registerConfigPropertiesBean(BeanRegistrationPhaseBuildItem beanRegistration, List<ConfigClassBuildItem> configClasses, CombinedIndexBuildItem combinedIndex, BuildProducer<BeanRegistrationPhaseBuildItem.BeanConfiguratorBuildItem> beanConfigurator) {
        if (configClasses.isEmpty()) {
            return;
        }
        Map<Type, ConfigClassBuildItem> configPropertiesTypes = ConfigBuildStep.configClassesToTypesMap(configClasses, ConfigClassBuildItem.Kind.PROPERTIES);
        HashSet<ConfigClassBuildItem> configProperties = new HashSet<ConfigClassBuildItem>();
        for (InjectionPointInfo injectionPoint : beanRegistration.getInjectionPoints()) {
            Type type;
            ConfigClassBuildItem configClass;
            AnnotationInstance instance = injectionPoint.getRequiredQualifier(MP_CONFIG_PROPERTIES_NAME);
            if (instance == null || (configClass = configPropertiesTypes.get(type = Type.create((DotName)injectionPoint.getRequiredType().name(), (Type.Kind)Type.Kind.CLASS))) == null) continue;
            configProperties.add(configClass);
        }
        for (ConfigClassBuildItem configClass : configProperties) {
            beanConfigurator.produce((BuildItem)new BeanRegistrationPhaseBuildItem.BeanConfiguratorBuildItem((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)((BeanConfigurator)beanRegistration.getContext().configure(configClass.getConfigClass()).types(configClass.getTypes().toArray(new Type[0]))).addQualifier(AnnotationInstance.create((DotName)MP_CONFIG_PROPERTIES_NAME, null, (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createStringValue((String)"prefix", (String)configClass.getPrefix())}))).creator(ConfigMappingCreator.class)).param("type", configClass.getConfigClass())).param("prefix", configClass.getPrefix())));
        }
    }

    @BuildStep
    void registerConfigMappingConverters(CombinedIndexBuildItem indexBuildItem, BuildProducer<ReflectiveClassBuildItem> producer) {
        String[] valueTypes = (String[])indexBuildItem.getIndex().getAnnotations(SR_WITH_CONVERTER).stream().map(i -> i.value().asClass().name().toString()).toArray(String[]::new);
        if (valueTypes.length > 0) {
            producer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])valueTypes).constructors(true).methods(false).fields(false).build());
        }
    }

    @BuildStep
    void validateConfigMappingsInjectionPoints(ArcConfig arcConfig, ValidationPhaseBuildItem validationPhase, List<UnremovableBeanBuildItem> unremovableBeans, List<ConfigClassBuildItem> configClasses, BuildProducer<ConfigMappingBuildItem> configMappings) {
        if (configClasses.isEmpty()) {
            return;
        }
        Map<Type, ConfigClassBuildItem> configMappingTypes = ConfigBuildStep.configClassesToTypesMap(configClasses, ConfigClassBuildItem.Kind.MAPPING);
        HashSet<ConfigMappingBuildItem> toRegister = new HashSet<ConfigMappingBuildItem>();
        for (InjectionPointInfo injectionPoint : validationPhase.getContext().getInjectionPoints()) {
            Type type = Type.create((DotName)injectionPoint.getRequiredType().name(), (Type.Kind)Type.Kind.CLASS);
            ConfigClassBuildItem configClass = configMappingTypes.get(type);
            if (configClass == null) continue;
            AnnotationTarget target = injectionPoint.getTarget();
            AnnotationInstance mapping = null;
            if (target.kind().equals((Object)AnnotationTarget.Kind.FIELD)) {
                mapping = target.asField().annotation(ConfigMappingUtils.CONFIG_MAPPING_NAME);
            } else if (target.kind().equals((Object)AnnotationTarget.Kind.METHOD)) {
                List parameters = target.asMethod().parameterTypes();
                for (int i = 0; i < parameters.size(); ++i) {
                    Type parameter = (Type)parameters.get(i);
                    if (!parameter.name().equals((Object)type.name())) continue;
                    Set parameterAnnotations = Annotations.getParameterAnnotations((BeanDeployment)validationPhase.getBeanProcessor().getBeanDeployment(), (MethodInfo)target.asMethod(), (int)i);
                    mapping = Annotations.find((Collection)parameterAnnotations, (DotName)ConfigMappingUtils.CONFIG_MAPPING_NAME);
                }
            }
            AnnotationValue annotationPrefix = null;
            if (mapping != null) {
                annotationPrefix = mapping.value("prefix");
            }
            String prefix = annotationPrefix != null ? annotationPrefix.asString() : configClass.getPrefix();
            toRegister.add(new ConfigMappingBuildItem(configClass.getConfigClass(), prefix));
        }
        if (arcConfig.shouldEnableBeanRemoval()) {
            Set unremovableClassNames = unremovableBeans.stream().map(UnremovableBeanBuildItem::getClassNames).flatMap(Collection::stream).collect(Collectors.toSet());
            for (ConfigClassBuildItem configClass : configMappingTypes.values()) {
                if (!configClass.getConfigClass().isAnnotationPresent(Unremovable.class) && !unremovableClassNames.contains(configClass.getName().toString())) continue;
                toRegister.add(new ConfigMappingBuildItem(configClass.getConfigClass(), configClass.getPrefix()));
            }
        }
        toRegister.forEach(arg_0 -> configMappings.produce(arg_0));
    }

    @BuildStep
    void validateConfigPropertiesInjectionPoints(ArcConfig arcConfig, ValidationPhaseBuildItem validationPhase, List<ConfigClassBuildItem> configClasses, BuildProducer<ConfigPropertiesBuildItem> configProperties) {
        if (configClasses.isEmpty()) {
            return;
        }
        Map<Type, ConfigClassBuildItem> configPropertiesTypes = ConfigBuildStep.configClassesToTypesMap(configClasses, ConfigClassBuildItem.Kind.PROPERTIES);
        HashSet<ConfigPropertiesBuildItem> toRegister = new HashSet<ConfigPropertiesBuildItem>();
        for (InjectionPointInfo injectionPoint : validationPhase.getContext().getInjectionPoints()) {
            Type type;
            ConfigClassBuildItem configClass;
            AnnotationInstance properties = injectionPoint.getRequiredQualifier(MP_CONFIG_PROPERTIES_NAME);
            if (properties == null || (configClass = configPropertiesTypes.get(type = Type.create((DotName)injectionPoint.getRequiredType().name(), (Type.Kind)Type.Kind.CLASS))) == null) continue;
            AnnotationValue annotationPrefix = properties.value("prefix");
            String prefix = annotationPrefix != null && !annotationPrefix.asString().equals("org.eclipse.microprofile.config.inject.configproperties.unconfiguredprefix") ? annotationPrefix.asString() : configClass.getPrefix();
            toRegister.add(new ConfigPropertiesBuildItem(configClass.getConfigClass(), prefix));
        }
        for (ConfigClassBuildItem configClass : configPropertiesTypes.values()) {
            if (arcConfig.shouldEnableBeanRemoval() && validationPhase.getContext().beans().withBeanType(configClass.getConfigClass()).isEmpty()) continue;
            toRegister.add(new ConfigPropertiesBuildItem(configClass.getConfigClass(), configClass.getPrefix()));
        }
        toRegister.forEach(arg_0 -> configProperties.produce(arg_0));
    }

    @BuildStep
    void warnStaticInitInjectionPoints(CombinedIndexBuildItem indexBuildItem, ValidationPhaseBuildItem validationPhase, List<ConfigClassBuildItem> configClasses, List<ConfigInjectionStaticInitBuildItem> configInjectionStaticInit, BuildProducer<RunTimeConfigurationDefaultBuildItem> runTimeConfigurationDefault) {
        Set declaringClassCandidates = configInjectionStaticInit.stream().map(ConfigInjectionStaticInitBuildItem::getDeclaringCandidate).collect(Collectors.toSet());
        Set configClassesTypes = configClasses.stream().map(ConfigClassBuildItem::getTypes).flatMap(Collection::stream).collect(Collectors.toSet());
        for (InjectionPointInfo injectionPoint : validationPhase.getContext().getInjectionPoints()) {
            AnnotationTarget target;
            if (injectionPoint.getType().name().equals((Object)DotNames.INSTANCE)) continue;
            Type type = Type.create((DotName)injectionPoint.getRequiredType().name(), (Type.Kind)Type.Kind.CLASS);
            DotName injectionTypeName = null;
            if (type.name().equals((Object)MP_CONFIG) || type.name().equals((Object)SR_CONFIG)) {
                injectionTypeName = type.name();
            } else if (injectionPoint.getRequiredQualifier(MP_CONFIG_PROPERTY_NAME) != null) {
                injectionTypeName = MP_CONFIG_PROPERTY_NAME;
            } else if (configClassesTypes.contains(type)) {
                injectionTypeName = type.name();
            }
            if (injectionTypeName == null || !AnnotationTarget.Kind.FIELD.equals((Object)(target = injectionPoint.getTarget()).kind())) continue;
            FieldInfo field = target.asField();
            ClassInfo declaringClass = field.declaringClass();
            Map annotationsMap = declaringClass.annotationsMap();
            for (DotName declaringClassCandidate : declaringClassCandidates) {
                AnnotationInstance annotationInstance;
                List annotationInstances = (List)annotationsMap.get(declaringClassCandidate);
                if (annotationInstances == null || annotationInstances.size() != 1 || !(annotationInstance = (AnnotationInstance)annotationInstances.get(0)).target().equals(declaringClass)) continue;
                LOGGER.warn((Object)("Directly injecting a " + injectionTypeName + " into a " + declaringClassCandidate + " may lead to unexpected results. To ensure proper results, please change the type of the field to " + ParameterizedType.create((DotName)DotNames.INSTANCE, (Type[])new Type[]{type}, null) + ". Offending field is '" + field.name() + "' of class '" + field.declaringClass() + "'"));
            }
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void registerConfigClasses(RecorderContext context, ConfigRecorder recorder, List<ConfigMappingBuildItem> configMappings, List<ConfigPropertiesBuildItem> configProperties) throws Exception {
        context.registerNonDefaultConstructor(ConfigMappings.ConfigClassWithPrefix.class.getDeclaredConstructor(Class.class, String.class), configClassWithPrefix -> Stream.of(configClassWithPrefix.getKlass(), configClassWithPrefix.getPrefix()).collect(Collectors.toList()));
        recorder.registerConfigProperties(configProperties.stream().map(p -> ConfigMappings.ConfigClassWithPrefix.configClassWithPrefix((Class)p.getConfigClass(), (String)p.getPrefix())).collect(Collectors.toSet()));
    }

    private static String getPropertyName(String name, ClassInfo declaringClass) {
        StringBuilder builder = new StringBuilder();
        if (declaringClass.enclosingClass() == null) {
            builder.append(declaringClass.name());
        } else {
            builder.append(declaringClass.enclosingClass()).append(".").append(declaringClass.simpleName());
        }
        return builder.append(".").append(name).toString();
    }

    public static boolean isHandledByProducers(Type type) {
        if (type.kind() == Type.Kind.ARRAY) {
            return false;
        }
        if (type.kind() == Type.Kind.PRIMITIVE) {
            return true;
        }
        return DotNames.STRING.equals((Object)type.name()) || DotNames.OPTIONAL.equals((Object)type.name()) || DotNames.OPTIONAL_INT.equals((Object)type.name()) || DotNames.OPTIONAL_LONG.equals((Object)type.name()) || DotNames.OPTIONAL_DOUBLE.equals((Object)type.name()) || MAP_NAME.equals((Object)type.name()) || SET_NAME.equals((Object)type.name()) || LIST_NAME.equals((Object)type.name()) || DotNames.LONG.equals((Object)type.name()) || DotNames.FLOAT.equals((Object)type.name()) || DotNames.INTEGER.equals((Object)type.name()) || DotNames.BOOLEAN.equals((Object)type.name()) || DotNames.DOUBLE.equals((Object)type.name()) || DotNames.SHORT.equals((Object)type.name()) || DotNames.BYTE.equals((Object)type.name()) || DotNames.CHARACTER.equals((Object)type.name()) || SUPPLIER_NAME.equals((Object)type.name()) || SR_CONFIG_VALUE_NAME.equals((Object)type.name()) || MP_CONFIG_VALUE_NAME.equals((Object)type.name());
    }

    private static Map<Type, ConfigClassBuildItem> configClassesToTypesMap(List<ConfigClassBuildItem> configClasses, ConfigClassBuildItem.Kind kind) {
        HashMap<Type, ConfigClassBuildItem> configClassesTypes = new HashMap<Type, ConfigClassBuildItem>();
        for (ConfigClassBuildItem configClass : configClasses) {
            if (!configClass.getKind().equals((Object)kind)) continue;
            for (Type type : configClass.getTypes()) {
                configClassesTypes.put(type, configClass);
            }
        }
        return configClassesTypes;
    }
}

