/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.AdditionalStereotypeBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.ArcConfig;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.CustomScopeAnnotationsBuildItem;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;

public class AutoProducerMethodsProcessor {
    private static final Logger LOGGER = Logger.getLogger(AutoProducerMethodsProcessor.class);

    @BuildStep
    void annotationTransformer(ArcConfig config, BeanArchiveIndexBuildItem beanArchiveIndex, final CustomScopeAnnotationsBuildItem scopes, List<AdditionalStereotypeBuildItem> additionalStereotypes, BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformer) throws Exception {
        if (!config.autoProducerMethods) {
            return;
        }
        final ArrayList<DotName> qualifiersAndStereotypes = new ArrayList<DotName>();
        for (AnnotationInstance qualifier : beanArchiveIndex.getIndex().getAnnotations(DotNames.QUALIFIER)) {
            qualifiersAndStereotypes.add(qualifier.target().asClass().name());
        }
        for (AnnotationInstance qualifier : beanArchiveIndex.getIndex().getAnnotations(DotNames.STEREOTYPE)) {
            qualifiersAndStereotypes.add(qualifier.target().asClass().name());
        }
        for (AdditionalStereotypeBuildItem additionalStereotype : additionalStereotypes) {
            qualifiersAndStereotypes.addAll(additionalStereotype.getStereotypes().keySet());
        }
        LOGGER.debugf("Add missing @Produces to methods annotated with %s", qualifiersAndStereotypes);
        annotationsTransformer.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.METHOD;
            }

            public int getPriority() {
                return 999;
            }

            public void transform(AnnotationsTransformer.TransformationContext ctx) {
                Set methodAnnotations = Annotations.getAnnotations((AnnotationTarget.Kind)AnnotationTarget.Kind.METHOD, (Collection)ctx.getAnnotations());
                if (methodAnnotations.isEmpty() || Annotations.contains((Collection)methodAnnotations, (DotName)DotNames.PRODUCES) || Annotations.contains((Collection)methodAnnotations, (DotName)DotNames.INJECT)) {
                    return;
                }
                Set parameterAnnotations = Annotations.getAnnotations((AnnotationTarget.Kind)AnnotationTarget.Kind.METHOD_PARAMETER, (Collection)ctx.getAnnotations());
                if (Annotations.contains((Collection)parameterAnnotations, (DotName)DotNames.OBSERVES) || Annotations.contains((Collection)parameterAnnotations, (DotName)DotNames.OBSERVES_ASYNC) || Annotations.contains((Collection)parameterAnnotations, (DotName)DotNames.DISPOSES)) {
                    return;
                }
                if (scopes.isScopeIn(methodAnnotations) || Annotations.containsAny((Collection)methodAnnotations, (Iterable)qualifiersAndStereotypes)) {
                    ((Transformation)ctx.transform().add(DotNames.PRODUCES, new AnnotationValue[0])).done();
                }
            }
        }));
    }
}

