/*
 * Decompiled with CFR 0.152.
 */
package io.qdrant.client;

import io.qdrant.client.grpc.Points;
import java.util.List;

public final class ConditionFactory {
    private ConditionFactory() {
    }

    public static Points.Condition hasId(Points.PointId id) {
        return Points.Condition.newBuilder().setHasId(Points.HasIdCondition.newBuilder().addHasId(id).build()).build();
    }

    public static Points.Condition hasId(List<Points.PointId> ids) {
        return Points.Condition.newBuilder().setHasId(Points.HasIdCondition.newBuilder().addAllHasId(ids).build()).build();
    }

    public static Points.Condition isEmpty(String field) {
        return Points.Condition.newBuilder().setIsEmpty(Points.IsEmptyCondition.newBuilder().setKey(field).build()).build();
    }

    public static Points.Condition isNull(String field) {
        return Points.Condition.newBuilder().setIsNull(Points.IsNullCondition.newBuilder().setKey(field).build()).build();
    }

    public static Points.Condition matchKeyword(String field, String keyword) {
        return Points.Condition.newBuilder().setField(Points.FieldCondition.newBuilder().setKey(field).setMatch(Points.Match.newBuilder().setKeyword(keyword).build()).build()).build();
    }

    public static Points.Condition matchText(String field, String text) {
        return Points.Condition.newBuilder().setField(Points.FieldCondition.newBuilder().setKey(field).setMatch(Points.Match.newBuilder().setText(text).build()).build()).build();
    }

    public static Points.Condition match(String field, boolean value) {
        return Points.Condition.newBuilder().setField(Points.FieldCondition.newBuilder().setKey(field).setMatch(Points.Match.newBuilder().setBoolean(value).build()).build()).build();
    }

    public static Points.Condition match(String field, long value) {
        return Points.Condition.newBuilder().setField(Points.FieldCondition.newBuilder().setKey(field).setMatch(Points.Match.newBuilder().setInteger(value).build()).build()).build();
    }

    public static Points.Condition matchKeywords(String field, List<String> keywords) {
        return Points.Condition.newBuilder().setField(Points.FieldCondition.newBuilder().setKey(field).setMatch(Points.Match.newBuilder().setKeywords(Points.RepeatedStrings.newBuilder().addAllStrings(keywords).build()).build()).build()).build();
    }

    public static Points.Condition matchValues(String field, List<Long> values) {
        return Points.Condition.newBuilder().setField(Points.FieldCondition.newBuilder().setKey(field).setMatch(Points.Match.newBuilder().setIntegers(Points.RepeatedIntegers.newBuilder().addAllIntegers(values).build()).build()).build()).build();
    }

    public static Points.Condition matchExceptKeywords(String field, List<String> keywords) {
        return Points.Condition.newBuilder().setField(Points.FieldCondition.newBuilder().setKey(field).setMatch(Points.Match.newBuilder().setExceptKeywords(Points.RepeatedStrings.newBuilder().addAllStrings(keywords).build()).build()).build()).build();
    }

    public static Points.Condition matchExceptValues(String field, List<Long> values) {
        return Points.Condition.newBuilder().setField(Points.FieldCondition.newBuilder().setKey(field).setMatch(Points.Match.newBuilder().setExceptIntegers(Points.RepeatedIntegers.newBuilder().addAllIntegers(values).build()).build()).build()).build();
    }

    public static Points.Condition nested(String field, Points.Condition condition) {
        return Points.Condition.newBuilder().setNested(Points.NestedCondition.newBuilder().setKey(field).setFilter(Points.Filter.newBuilder().addMust(condition).build()).build()).build();
    }

    public static Points.Condition nested(String field, Points.Filter filter) {
        return Points.Condition.newBuilder().setNested(Points.NestedCondition.newBuilder().setKey(field).setFilter(filter)).build();
    }

    public static Points.Condition range(String field, Points.Range range) {
        return Points.Condition.newBuilder().setField(Points.FieldCondition.newBuilder().setKey(field).setRange(range).build()).build();
    }

    public static Points.Condition geoRadius(String field, double latitude, double longitude, float radius) {
        return Points.Condition.newBuilder().setField(Points.FieldCondition.newBuilder().setKey(field).setGeoRadius(Points.GeoRadius.newBuilder().setCenter(Points.GeoPoint.newBuilder().setLat(latitude).setLon(longitude).build()).setRadius(radius).build()).build()).build();
    }

    public static Points.Condition geoBoundingBox(String field, double topLeftLatitude, double topLeftLongitude, double bottomRightLatitude, double bottomRightLongitude) {
        return Points.Condition.newBuilder().setField(Points.FieldCondition.newBuilder().setKey(field).setGeoBoundingBox(Points.GeoBoundingBox.newBuilder().setTopLeft(Points.GeoPoint.newBuilder().setLat(topLeftLatitude).setLon(topLeftLongitude).build()).setBottomRight(Points.GeoPoint.newBuilder().setLat(bottomRightLatitude).setLon(bottomRightLongitude).build()).build()).build()).build();
    }

    public static Points.Condition geoPolygon(String field, Points.GeoLineString exterior, List<Points.GeoLineString> interiors) {
        Points.GeoPolygon.Builder geoPolygonBuilder = Points.GeoPolygon.newBuilder().setExterior(exterior);
        if (!interiors.isEmpty()) {
            geoPolygonBuilder.addAllInteriors(interiors);
        }
        return Points.Condition.newBuilder().setField(Points.FieldCondition.newBuilder().setKey(field).setGeoPolygon(geoPolygonBuilder.build()).build()).build();
    }

    public static Points.Condition valuesCount(String field, Points.ValuesCount valuesCount) {
        return Points.Condition.newBuilder().setField(Points.FieldCondition.newBuilder().setKey(field).setValuesCount(valuesCount).build()).build();
    }

    public static Points.Condition filter(Points.Filter filter) {
        return Points.Condition.newBuilder().setFilter(filter).build();
    }

    public static Points.Condition datetimeRange(String field, Points.DatetimeRange datetimeRange) {
        return Points.Condition.newBuilder().setField(Points.FieldCondition.newBuilder().setKey(field).setDatetimeRange(datetimeRange).build()).build();
    }
}

