/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.resources;

import io.netty.bootstrap.Bootstrap;
import java.net.SocketAddress;
import java.time.Duration;
import javax.annotation.Nullable;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.internal.shaded.reactor.pool.PoolBuilder;
import reactor.netty.resources.NewConnectionProvider;
import reactor.netty.resources.PooledConnectionProvider;
import reactor.util.annotation.NonNull;

@FunctionalInterface
public interface ConnectionProvider
extends Disposable {
    public static final int DEFAULT_POOL_MAX_CONNECTIONS = Integer.parseInt(System.getProperty("reactor.netty.pool.maxConnections", "" + Math.max(Runtime.getRuntime().availableProcessors(), 8) * 2));
    public static final long DEFAULT_POOL_ACQUIRE_TIMEOUT = Long.parseLong(System.getProperty("reactor.netty.pool.acquireTimeout", "45000"));

    public static ConnectionProvider newConnection() {
        return NewConnectionProvider.INSTANCE;
    }

    public static ConnectionProvider elastic(String name) {
        return ConnectionProvider.elastic(name, null);
    }

    public static ConnectionProvider elastic(String name, @Nullable Duration maxIdleTime) {
        return new PooledConnectionProvider(name, (allocator, destroyHandler, evictionPredicate) -> PoolBuilder.from(allocator).destroyHandler(destroyHandler).evictionPredicate(evictionPredicate.or((poolable, meta) -> maxIdleTime != null && meta.idleTime() >= maxIdleTime.toMillis())).fifo());
    }

    public static ConnectionProvider fixed(String name) {
        return ConnectionProvider.fixed(name, DEFAULT_POOL_MAX_CONNECTIONS);
    }

    public static ConnectionProvider fixed(String name, int maxConnections) {
        return ConnectionProvider.fixed(name, maxConnections, DEFAULT_POOL_ACQUIRE_TIMEOUT);
    }

    public static ConnectionProvider fixed(String name, int maxConnections, long acquireTimeout) {
        return ConnectionProvider.fixed(name, maxConnections, acquireTimeout, null);
    }

    public static ConnectionProvider fixed(String name, int maxConnections, long acquireTimeout, @Nullable Duration maxIdleTime) {
        if (maxConnections == -1) {
            return ConnectionProvider.elastic(name);
        }
        if (maxConnections <= 0) {
            throw new IllegalArgumentException("Max Connections value must be strictly positive");
        }
        if (acquireTimeout < 0L) {
            throw new IllegalArgumentException("Acquire Timeout value must be positive");
        }
        return new PooledConnectionProvider(name, (allocator, destroyHandler, evictionPredicate) -> PoolBuilder.from(allocator).sizeBetween(0, maxConnections).maxPendingAcquireUnbounded().destroyHandler(destroyHandler).evictionPredicate(evictionPredicate.or((poolable, meta) -> maxIdleTime != null && meta.idleTime() >= maxIdleTime.toMillis())).fifo(), acquireTimeout, maxConnections);
    }

    public Mono<? extends Connection> acquire(Bootstrap var1);

    default public void disposeWhen(@NonNull SocketAddress address) {
    }

    default public void dispose() {
        this.disposeLater().subscribe();
    }

    default public Mono<Void> disposeLater() {
        return Mono.empty();
    }

    default public int maxConnections() {
        return -1;
    }
}

