/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.config.MeterFilterReply;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import reactor.netty.Metrics;
import reactor.netty.channel.MicrometerChannelMetricsRecorder;
import reactor.netty.http.HttpMetricsRecorder;
import reactor.util.Logger;
import reactor.util.Loggers;

public class MicrometerHttpMetricsRecorder
extends MicrometerChannelMetricsRecorder
implements HttpMetricsRecorder {
    protected final Timer.Builder dataReceivedTimeBuilder;
    protected final Timer.Builder dataSentTimeBuilder;
    protected final Timer.Builder responseTimeBuilder;

    protected MicrometerHttpMetricsRecorder(String name, @Nullable String remoteAddress, String protocol) {
        super(name, remoteAddress, protocol);
        this.dataReceivedTimeBuilder = Timer.builder((String)(name + ".data.received.time")).description("Time that is spent in consuming incoming data");
        this.dataSentTimeBuilder = Timer.builder((String)(name + ".data.sent.time")).description("Time that is spent in sending outgoing data");
        this.responseTimeBuilder = Timer.builder((String)(name + ".response.time")).description("Total time for the request/response");
        registry.config().meterFilter(MicrometerHttpMetricsRecorder.maxUriTagsMeterFilter(name + ".data.received.time")).meterFilter(MicrometerHttpMetricsRecorder.maxUriTagsMeterFilter(name + ".data.sent.time")).meterFilter(MicrometerHttpMetricsRecorder.maxUriTagsMeterFilter(name + ".response.time")).meterFilter(MicrometerHttpMetricsRecorder.maxUriTagsMeterFilter(name + ".data.received")).meterFilter(MicrometerHttpMetricsRecorder.maxUriTagsMeterFilter(name + ".data.sent")).meterFilter(MicrometerHttpMetricsRecorder.maxUriTagsMeterFilter(name + ".errors"));
    }

    @Override
    public void recordDataReceived(SocketAddress remoteAddress, String uri, long bytes) {
        DistributionSummary.builder((String)(this.name + ".data.received")).baseUnit("bytes").description("Amount of the data that is received, in bytes").tags(new String[]{"remote.address", Metrics.formatSocketAddress(remoteAddress), "uri", uri}).register(registry).record((double)bytes);
    }

    @Override
    public void recordDataSent(SocketAddress remoteAddress, String uri, long bytes) {
        DistributionSummary.builder((String)(this.name + ".data.sent")).baseUnit("bytes").description("Amount of the data that is sent, in bytes").tags(new String[]{"remote.address", Metrics.formatSocketAddress(remoteAddress), "uri", uri}).register(registry).record((double)bytes);
    }

    @Override
    public void incrementErrorsCount(SocketAddress remoteAddress, String uri) {
        Counter.builder((String)(this.name + ".errors")).description("Number of the errors that are occurred").tags(new String[]{"remote.address", Metrics.formatSocketAddress(remoteAddress), "uri", uri}).register(registry).increment();
    }

    static MeterFilter maxUriTagsMeterFilter(String meterNamePrefix) {
        return MeterFilter.maximumAllowableTags((String)meterNamePrefix, (String)"uri", (int)100, (MeterFilter)new MaxUriTagsMeterFilter());
    }

    static final class MaxUriTagsMeterFilter
    extends AtomicBoolean
    implements MeterFilter {
        static final Logger logger = Loggers.getLogger(MaxUriTagsMeterFilter.class);

        MaxUriTagsMeterFilter() {
        }

        public MeterFilterReply accept(Meter.Id id) {
            if (logger.isWarnEnabled() && this.compareAndSet(false, true)) {
                logger.warn("Reached the maximum number of URI tags for {0}.", new Object[]{id.getName()});
            }
            return MeterFilterReply.DENY;
        }
    }
}

