/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.CombinedChannelDuplexHandler;
import io.netty.handler.codec.ByteToMessageCodec;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.Future;
import java.net.URI;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.FutureMono;
import reactor.netty.NettyInbound;
import reactor.netty.NettyOutbound;
import reactor.netty.NettyPipeline;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.AbortedException;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.HttpInfos;
import reactor.netty.http.logging.HttpMessageArgProviderFactory;
import reactor.netty.http.logging.HttpMessageLogFactory;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;

public abstract class HttpOperations<INBOUND extends NettyInbound, OUTBOUND extends NettyOutbound>
extends ChannelOperations<INBOUND, OUTBOUND>
implements HttpInfos {
    volatile int statusAndHeadersSent;
    static final int READY = 0;
    static final int HEADERS_SENT = 1;
    static final int BODY_SENT = 2;
    final HttpMessageLogFactory httpMessageLogFactory;
    static final AtomicIntegerFieldUpdater<HttpOperations> HTTP_STATE = AtomicIntegerFieldUpdater.newUpdater(HttpOperations.class, "statusAndHeadersSent");
    static final ChannelInboundHandler HTTP_EXTRACTOR = NettyPipeline.inboundHandler((ctx, msg) -> {
        if (msg instanceof ByteBufHolder) {
            if (msg instanceof FullHttpMessage) {
                ctx.fireChannelRead(msg);
            } else {
                ByteBuf bb = ((ByteBufHolder)msg).content();
                ctx.fireChannelRead((Object)bb);
                if (msg instanceof LastHttpContent) {
                    ctx.fireChannelRead((Object)LastHttpContent.EMPTY_LAST_CONTENT);
                }
            }
        } else {
            ctx.fireChannelRead(msg);
        }
    });
    static final Logger log = Loggers.getLogger(HttpOperations.class);
    static final Pattern SCHEME_PATTERN = Pattern.compile("^(https?|wss?)://.*$");

    protected HttpOperations(HttpOperations<INBOUND, OUTBOUND> replaced) {
        super(replaced);
        this.httpMessageLogFactory = replaced.httpMessageLogFactory;
        this.statusAndHeadersSent = replaced.statusAndHeadersSent;
    }

    protected HttpOperations(Connection connection, ConnectionObserver listener, HttpMessageLogFactory httpMessageLogFactory) {
        super(connection, listener);
        this.httpMessageLogFactory = httpMessageLogFactory;
    }

    public final boolean hasSentHeaders() {
        return this.statusAndHeadersSent != 0;
    }

    @Override
    public boolean isWebsocket() {
        return false;
    }

    @Override
    public String requestId() {
        return this.asShortText();
    }

    public NettyOutbound send(Publisher<? extends ByteBuf> source) {
        if (!this.channel().isActive()) {
            return this.then((Publisher)Mono.error((Throwable)AbortedException.beforeSend()));
        }
        if (source instanceof Mono) {
            return new PostHeadersNettyOutbound((Mono<Void>)((Mono)source).flatMap(b -> {
                if (this.markSentHeaderAndBody(b)) {
                    HttpMessage msg = this.prepareHttpMessage((ByteBuf)b);
                    try {
                        this.afterMarkSentHeaders();
                    }
                    catch (RuntimeException e) {
                        ReferenceCountUtil.release((Object)b);
                        return Mono.error((Throwable)e);
                    }
                    return FutureMono.from((Future)this.channel().writeAndFlush((Object)msg));
                }
                return FutureMono.from((Future)this.channel().writeAndFlush(b));
            }).doOnDiscard(ByteBuf.class, ReferenceCounted::release), this, null);
        }
        return super.send(source);
    }

    public NettyOutbound sendObject(Object message) {
        if (!this.channel().isActive()) {
            ReactorNetty.safeRelease((Object)message);
            return this.then((Publisher)Mono.error((Throwable)AbortedException.beforeSend()));
        }
        if (!(message instanceof ByteBuf)) {
            return super.sendObject(message);
        }
        ByteBuf b = (ByteBuf)message;
        return new PostHeadersNettyOutbound((Mono<Void>)FutureMono.deferFuture(() -> {
            if (this.markSentHeaderAndBody(b)) {
                HttpMessage msg = this.prepareHttpMessage(b);
                try {
                    this.afterMarkSentHeaders();
                }
                catch (RuntimeException e) {
                    b.release();
                    throw e;
                }
                return this.channel().writeAndFlush((Object)msg);
            }
            return this.channel().writeAndFlush((Object)b);
        }), this, b);
    }

    public Mono<Void> then() {
        if (!this.channel().isActive()) {
            return Mono.error((Throwable)AbortedException.beforeSend());
        }
        if (this.hasSentHeaders()) {
            return Mono.empty();
        }
        return FutureMono.deferFuture(() -> {
            if (this.markSentHeaders(this.outboundHttpMessage())) {
                HttpMessage msg;
                if (HttpUtil.isContentLengthSet((HttpMessage)this.outboundHttpMessage())) {
                    this.outboundHttpMessage().headers().remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
                    if (HttpUtil.getContentLength((HttpMessage)this.outboundHttpMessage(), (int)0) == 0) {
                        this.markSentBody();
                        msg = this.newFullBodyMessage(Unpooled.EMPTY_BUFFER);
                    } else {
                        msg = this.outboundHttpMessage();
                    }
                } else if (this.isContentAlwaysEmpty()) {
                    this.markSentBody();
                    msg = this.newFullBodyMessage(Unpooled.EMPTY_BUFFER);
                } else {
                    msg = this.outboundHttpMessage();
                }
                try {
                    this.afterMarkSentHeaders();
                }
                catch (RuntimeException e) {
                    ReferenceCountUtil.release((Object)msg);
                    throw e;
                }
                return this.channel().writeAndFlush((Object)msg).addListener(f -> this.onHeadersSent());
            }
            return this.channel().newSucceededFuture();
        });
    }

    protected String asDebugLogMessage(Object o) {
        return o instanceof HttpObject ? this.httpMessageLogFactory.debug(HttpMessageArgProviderFactory.create(o)) : o.toString();
    }

    protected HttpMessageLogFactory httpMessageLogFactory() {
        return this.httpMessageLogFactory;
    }

    protected abstract void beforeMarkSentHeaders();

    protected abstract void afterMarkSentHeaders();

    protected abstract boolean isContentAlwaysEmpty();

    protected abstract void onHeadersSent();

    protected abstract HttpMessage newFullBodyMessage(ByteBuf var1);

    public final NettyOutbound sendFile(Path file, long position, long count) {
        Objects.requireNonNull(file);
        if (this.hasSentHeaders()) {
            return super.sendFile(file, position, count);
        }
        if (!HttpUtil.isTransferEncodingChunked((HttpMessage)this.outboundHttpMessage()) && !HttpUtil.isContentLengthSet((HttpMessage)this.outboundHttpMessage()) && count < Integer.MAX_VALUE) {
            this.outboundHttpMessage().headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (int)count);
        } else if (!HttpUtil.isContentLengthSet((HttpMessage)this.outboundHttpMessage())) {
            this.outboundHttpMessage().headers().remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH).remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
            HttpUtil.setTransferEncodingChunked((HttpMessage)this.outboundHttpMessage(), (boolean)true);
        }
        return super.sendFile(file, position, count);
    }

    public String toString() {
        if (this.isWebsocket()) {
            return "ws{uri=" + this.fullPath() + ", connection=" + this.connection() + "}";
        }
        return this.method().name() + "{uri=" + this.fullPath() + ", connection=" + this.connection() + "}";
    }

    public HttpOperations<INBOUND, OUTBOUND> addHandler(String name, ChannelHandler handler) {
        super.addHandler(name, handler);
        if (this.channel().pipeline().context(handler) == null) {
            return this;
        }
        HttpOperations.autoAddHttpExtractor((Connection)this, name, handler);
        return this;
    }

    static void autoAddHttpExtractor(Connection c, String name, ChannelHandler handler) {
        if (handler instanceof ByteToMessageDecoder || handler instanceof ByteToMessageCodec || handler instanceof CombinedChannelDuplexHandler) {
            String extractorName = name + "$extractor";
            if (c.channel().pipeline().context(extractorName) != null) {
                return;
            }
            c.channel().pipeline().addBefore(name, extractorName, (ChannelHandler)HTTP_EXTRACTOR);
            if (c.isPersistent()) {
                c.onTerminate().subscribe(null, null, () -> c.removeHandler(extractorName));
            }
        }
    }

    protected final boolean markSentHeaders(Object ... objectsToRelease) {
        try {
            if (!this.hasSentHeaders()) {
                this.beforeMarkSentHeaders();
            }
        }
        catch (RuntimeException e) {
            for (Object o : objectsToRelease) {
                try {
                    ReferenceCountUtil.release((Object)o);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw e;
        }
        return HTTP_STATE.compareAndSet(this, 0, 1);
    }

    protected final boolean markSentBody() {
        return HTTP_STATE.compareAndSet(this, 1, 2);
    }

    protected final boolean markSentHeaderAndBody(Object ... objectsToRelease) {
        try {
            if (!this.hasSentHeaders()) {
                this.beforeMarkSentHeaders();
            }
        }
        catch (RuntimeException e) {
            for (Object o : objectsToRelease) {
                try {
                    ReferenceCountUtil.release((Object)o);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw e;
        }
        return HTTP_STATE.compareAndSet(this, 0, 2);
    }

    protected final String initShortId() {
        if (this.connection() instanceof AtomicLong) {
            return this.channel().id().asShortText() + '-' + ((AtomicLong)this.connection()).incrementAndGet();
        }
        return super.initShortId();
    }

    public static String resolvePath(String uri) {
        Objects.requireNonNull(uri, "uri");
        String tempUri = uri;
        int index = tempUri.indexOf(63);
        if (index > -1) {
            tempUri = tempUri.substring(0, index);
        }
        if ((index = tempUri.indexOf(35)) > -1) {
            tempUri = tempUri.substring(0, index);
        }
        if (tempUri.isEmpty()) {
            return tempUri;
        }
        if (tempUri.charAt(0) == '/') {
            if (tempUri.length() == 1) {
                return tempUri;
            }
            tempUri = "http://localhost:8080" + tempUri;
        } else if (!SCHEME_PATTERN.matcher(tempUri).matches()) {
            tempUri = "http://" + tempUri;
        }
        return URI.create(tempUri).getPath();
    }

    protected abstract HttpMessage outboundHttpMessage();

    HttpMessage prepareHttpMessage(ByteBuf buffer) {
        HttpMessage msg;
        if (HttpUtil.getContentLength((HttpMessage)this.outboundHttpMessage(), (int)-1) == 0 || this.isContentAlwaysEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format((Channel)this.channel(), (String)"Dropped HTTP content, since response has 1. [Content-Length: 0] or 2. there must be no content: {}"), new Object[]{buffer});
            }
            buffer.release();
            msg = this.newFullBodyMessage(Unpooled.EMPTY_BUFFER);
        } else {
            msg = this.newFullBodyMessage(buffer);
        }
        return msg;
    }

    protected static final class PostHeadersNettyOutbound
    implements NettyOutbound,
    Consumer<Throwable>,
    Runnable {
        final Mono<Void> source;
        final HttpOperations<?, ?> parent;
        final ByteBuf msg;

        public PostHeadersNettyOutbound(Mono<Void> source, HttpOperations<?, ?> parent, @Nullable ByteBuf msg) {
            this.msg = msg;
            this.source = msg != null ? source.doOnError((Consumer)this).doOnCancel((Runnable)this) : source;
            this.parent = parent;
        }

        @Override
        public void run() {
            if (this.msg != null && this.msg.refCnt() > 0) {
                this.msg.release();
            }
        }

        @Override
        public void accept(Throwable throwable) {
            if (this.msg != null && this.msg.refCnt() > 0) {
                this.msg.release();
            }
        }

        public Mono<Void> then() {
            return this.source;
        }

        public ByteBufAllocator alloc() {
            return this.parent.alloc();
        }

        public NettyOutbound send(Publisher<? extends ByteBuf> dataStream, Predicate<ByteBuf> predicate) {
            return this.parent.send(dataStream, predicate);
        }

        public NettyOutbound sendObject(Publisher<?> dataStream, Predicate<Object> predicate) {
            return this.parent.sendObject(dataStream, predicate);
        }

        public NettyOutbound sendObject(Object message) {
            return this.parent.sendObject(message);
        }

        public <S> NettyOutbound sendUsing(Callable<? extends S> sourceInput, BiFunction<? super Connection, ? super S, ?> mappedInput, Consumer<? super S> sourceCleanup) {
            return this.parent.sendUsing(sourceInput, mappedInput, sourceCleanup);
        }

        public NettyOutbound withConnection(Consumer<? super Connection> withConnection) {
            return this.parent.withConnection(withConnection);
        }
    }
}

