/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.http.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Objects;
import reactor.util.Logger;
import reactor.util.Loggers;

final class AccessLogHandler
extends ChannelDuplexHandler {
    AccessLog accessLog = new AccessLog();

    AccessLogHandler() {
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)msg;
            this.accessLog = new AccessLog().address(((SocketChannel)ctx.channel()).remoteAddress().getHostString()).method(request.method().name()).uri(request.uri()).protocol(request.protocolVersion().text());
        }
        super.channelRead(ctx, msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)msg;
            HttpResponseStatus status = response.status();
            if (status.equals((Object)HttpResponseStatus.CONTINUE)) {
                ctx.write(msg, promise);
                return;
            }
            boolean chunked = HttpUtil.isTransferEncodingChunked((HttpMessage)response);
            this.accessLog.status(status.code()).chunked(chunked);
            if (!chunked) {
                this.accessLog.contentLength(HttpUtil.getContentLength((HttpMessage)response, (int)-1));
            }
        }
        if (msg instanceof LastHttpContent) {
            this.accessLog.increaseContentLength(((LastHttpContent)msg).content().readableBytes());
            ctx.write(msg, promise).addListener(future -> {
                if (future.isSuccess()) {
                    this.accessLog.log();
                }
            });
            return;
        }
        if (msg instanceof ByteBuf) {
            this.accessLog.increaseContentLength(((ByteBuf)msg).readableBytes());
        }
        if (msg instanceof ByteBufHolder) {
            this.accessLog.increaseContentLength(((ByteBufHolder)msg).content().readableBytes());
        }
        ctx.write(msg, promise);
    }

    static final class AccessLog {
        static final Logger log = Loggers.getLogger((String)"reactor.netty.http.server.AccessLog");
        static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("dd/MMM/yyyy:HH:mm:ss Z", Locale.US);
        static final String COMMON_LOG_FORMAT = "{} - {} [{}] \"{} {} {}\" {} {}";
        static final String MISSING = "-";
        final String zonedDateTime = ZonedDateTime.now().format(DATE_TIME_FORMATTER);
        String address;
        String method;
        String uri;
        String protocol;
        String user = "-";
        int status;
        long contentLength;
        boolean chunked;

        AccessLog() {
        }

        AccessLog address(String address) {
            this.address = Objects.requireNonNull(address, "address");
            return this;
        }

        AccessLog method(String method) {
            this.method = Objects.requireNonNull(method, "method");
            return this;
        }

        AccessLog uri(String uri) {
            this.uri = Objects.requireNonNull(uri, "uri");
            return this;
        }

        AccessLog protocol(String protocol) {
            this.protocol = Objects.requireNonNull(protocol, "protocol");
            return this;
        }

        AccessLog status(int status) {
            this.status = status;
            return this;
        }

        AccessLog contentLength(long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        AccessLog increaseContentLength(long contentLength) {
            if (this.chunked) {
                this.contentLength += contentLength;
            }
            return this;
        }

        AccessLog chunked(boolean chunked) {
            this.chunked = chunked;
            return this;
        }

        void log() {
            if (log.isInfoEnabled()) {
                log.info(COMMON_LOG_FORMAT, new Object[]{this.address, this.user, this.zonedDateTime, this.method, this.uri, this.protocol, this.status, this.contentLength > -1L ? Long.valueOf(this.contentLength) : MISSING});
            }
        }
    }
}

