/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import io.pravega.common.util.StructuredWritableBuffer;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;

public final class BitConverter {
    public static int writeShort(OutputStream target, short value) throws IOException {
        target.write((byte)(value >>> 8 & 0xFF));
        target.write((byte)(value & 0xFF));
        return 2;
    }

    public static int writeInt(byte[] target, int offset, int value) {
        target[offset] = (byte)(value >>> 24);
        target[offset + 1] = (byte)(value >>> 16);
        target[offset + 2] = (byte)(value >>> 8);
        target[offset + 3] = (byte)value;
        return 4;
    }

    public static int writeInt(OutputStream target, int value) throws IOException {
        target.write(value >>> 24);
        target.write(value >>> 16);
        target.write(value >>> 8);
        target.write(value);
        return 4;
    }

    public static int readInt(byte[] source, int position) {
        return BitConverter.makeInt(source[position], source[position + 1], source[position + 2], source[position + 3]);
    }

    public static int readInt(InputStream source) throws IOException {
        int b4;
        int b3;
        int b2;
        int b1 = source.read();
        if ((b1 | (b2 = source.read()) | (b3 = source.read()) | (b4 = source.read())) < 0) {
            throw new EOFException();
        }
        return BitConverter.makeInt(b1, b2, b3, b4);
    }

    public static int makeInt(int b1, int b2, int b3, int b4) {
        return (b1 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
    }

    public static int writeLong(byte[] target, int offset, long value) {
        target[offset] = (byte)(value >>> 56);
        target[offset + 1] = (byte)(value >>> 48);
        target[offset + 2] = (byte)(value >>> 40);
        target[offset + 3] = (byte)(value >>> 32);
        target[offset + 4] = (byte)(value >>> 24);
        target[offset + 5] = (byte)(value >>> 16);
        target[offset + 6] = (byte)(value >>> 8);
        target[offset + 7] = (byte)value;
        return 8;
    }

    public static int writeLong(OutputStream target, long value) throws IOException {
        target.write((byte)(value >>> 56));
        target.write((byte)(value >>> 48));
        target.write((byte)(value >>> 40));
        target.write((byte)(value >>> 32));
        target.write((byte)(value >>> 24));
        target.write((byte)(value >>> 16));
        target.write((byte)(value >>> 8));
        target.write((byte)value);
        return 8;
    }

    public static void writeUUID(StructuredWritableBuffer b, UUID value) {
        b.setLong(0, value.getMostSignificantBits());
        b.setLong(8, value.getLeastSignificantBits());
    }

    public static UUID readUUID(byte[] source, int position) {
        long msb = BitConverter.readLong(source, position);
        long lsb = BitConverter.readLong(source, position + 8);
        return new UUID(msb, lsb);
    }

    public static long readLong(byte[] source, int position) {
        return BitConverter.makeLong(source[position], source[position + 1], source[position + 2], source[position + 3], source[position + 4], source[position + 5], source[position + 6], source[position + 7]);
    }

    public static long makeLong(int b1, int b2, int b3, int b4, int b5, int b6, int b7, int b8) {
        return ((long)b1 << 56) + ((long)(b2 & 0xFF) << 48) + ((long)(b3 & 0xFF) << 40) + ((long)(b4 & 0xFF) << 32) + ((long)(b5 & 0xFF) << 24) + (long)((b6 & 0xFF) << 16) + (long)((b7 & 0xFF) << 8) + (long)(b8 & 0xFF);
    }
}

