/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.concurrent;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.ObjectClosedException;
import io.pravega.common.concurrent.Futures;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;

@ThreadSafe
public class MultiKeySequentialProcessor<KeyType>
implements AutoCloseable {
    private final Executor executor;
    @GuardedBy(value="queue")
    private final Map<KeyType, CompletableFuture<?>> queue = new HashMap();
    @GuardedBy(value="queue")
    private final Map<Predicate<KeyType>, CompletableFuture<?>> filterQueue = new HashMap();
    @GuardedBy(value="queue")
    private boolean closed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ArrayList<Object> toCancel = new ArrayList();
        Map<KeyType, CompletableFuture<?>> map = this.queue;
        synchronized (map) {
            if (!this.closed) {
                toCancel = new ArrayList(this.queue.values());
                toCancel.addAll(this.filterQueue.values());
                this.queue.clear();
                this.filterQueue.clear();
                this.closed = true;
            }
        }
        if (toCancel.size() > 0) {
            toCancel.forEach((Consumer<Object>)((Consumer<CompletableFuture>)f -> f.completeExceptionally(new ObjectClosedException(this))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public int getCurrentTaskCount() {
        Map<KeyType, CompletableFuture<?>> map = this.queue;
        synchronized (map) {
            int size = this.queue.size() + this.filterQueue.size();
            if (size > 0) {
                size = (int)((long)size - this.queue.values().stream().filter(CompletableFuture::isDone).count());
                size = (int)((long)size - this.filterQueue.values().stream().filter(CompletableFuture::isDone).count());
            }
            return size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ReturnType> CompletableFuture<ReturnType> add(Collection<KeyType> keys, Supplier<CompletableFuture<? extends ReturnType>> toRun) {
        Preconditions.checkArgument((!keys.isEmpty() ? 1 : 0) != 0, (Object)"keys cannot be empty.");
        CompletableFuture result = new CompletableFuture();
        ArrayList existingTasks = new ArrayList();
        Map<KeyType, CompletableFuture<?>> map = this.queue;
        synchronized (map) {
            Exceptions.checkNotClosed(this.closed, this);
            for (KeyType key2 : keys) {
                CompletableFuture<?> existingTask = this.queue.get(key2);
                if (existingTask != null) {
                    existingTasks.add(existingTask);
                }
                for (Map.Entry<Predicate<KeyType>, CompletableFuture<?>> e : this.filterQueue.entrySet()) {
                    if (!e.getKey().test(key2)) continue;
                    existingTasks.add(e.getValue());
                }
            }
            this.executeAfterIfNeeded(existingTasks, toRun, result);
            keys.forEach(key -> this.queue.put(key, result));
        }
        this.executeNowIfNeeded(existingTasks, toRun, result);
        result.whenComplete((r, ex) -> this.cleanup(keys));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ReturnType> CompletableFuture<ReturnType> addWithFilter(Predicate<KeyType> keyFilter, Supplier<CompletableFuture<? extends ReturnType>> toRun) {
        CompletableFuture result = new CompletableFuture();
        ArrayList existingTasks = new ArrayList();
        Map<KeyType, CompletableFuture<?>> map = this.queue;
        synchronized (map) {
            Exceptions.checkNotClosed(this.closed, this);
            for (Map.Entry<KeyType, CompletableFuture<?>> e : this.queue.entrySet()) {
                if (!keyFilter.test(e.getKey())) continue;
                existingTasks.add(e.getValue());
            }
            this.executeAfterIfNeeded(existingTasks, toRun, result);
            this.filterQueue.put(keyFilter, result);
        }
        this.executeNowIfNeeded(existingTasks, toRun, result);
        result.whenComplete((r, ex) -> this.cleanupFilter(keyFilter));
        return result;
    }

    private <ReturnType> void executeAfterIfNeeded(Collection<CompletableFuture<?>> existingTasks, Supplier<CompletableFuture<? extends ReturnType>> toRun, CompletableFuture<ReturnType> result) {
        if (!existingTasks.isEmpty()) {
            CompletableFuture.allOf(existingTasks.toArray(new CompletableFuture[existingTasks.size()])).whenCompleteAsync((r, ex) -> Futures.completeAfter(toRun, result), this.executor);
        }
    }

    private <ReturnType> void executeNowIfNeeded(Collection<CompletableFuture<?>> existingTasks, Supplier<CompletableFuture<? extends ReturnType>> toRun, CompletableFuture<ReturnType> result) {
        if (existingTasks.isEmpty()) {
            Futures.completeAfter(toRun, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupFilter(Predicate<KeyType> keyFilter) {
        Map<KeyType, CompletableFuture<?>> map = this.queue;
        synchronized (map) {
            CompletableFuture<?> r = this.filterQueue.remove(keyFilter);
            assert (r != null) : "nothing was removed";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup(Collection<KeyType> keys) {
        Map<KeyType, CompletableFuture<?>> map = this.queue;
        synchronized (map) {
            for (KeyType key : keys) {
                CompletableFuture last = this.queue.getOrDefault(key, null);
                if (last == null || !last.isDone()) continue;
                this.queue.remove(key);
            }
        }
    }

    @ConstructorProperties(value={"executor"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MultiKeySequentialProcessor(Executor executor) {
        this.executor = executor;
    }
}

