/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.tables.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.pravega.client.admin.KeyValueTableInfo;
import io.pravega.client.control.impl.Controller;
import io.pravega.client.stream.Serializer;
import io.pravega.client.tables.BadKeyVersionException;
import io.pravega.client.tables.IteratorItem;
import io.pravega.client.tables.IteratorState;
import io.pravega.client.tables.KeyValueTable;
import io.pravega.client.tables.KeyValueTableMap;
import io.pravega.client.tables.TableEntry;
import io.pravega.client.tables.TableKey;
import io.pravega.client.tables.Version;
import io.pravega.client.tables.impl.IteratorArgs;
import io.pravega.client.tables.impl.IteratorStateImpl;
import io.pravega.client.tables.impl.KeyFamilySerializer;
import io.pravega.client.tables.impl.KeyValueTableIteratorState;
import io.pravega.client.tables.impl.KeyValueTableMapImpl;
import io.pravega.client.tables.impl.SegmentSelector;
import io.pravega.client.tables.impl.TableSegment;
import io.pravega.client.tables.impl.TableSegmentEntry;
import io.pravega.client.tables.impl.TableSegmentFactory;
import io.pravega.client.tables.impl.TableSegmentKey;
import io.pravega.client.tables.impl.TableSegmentKeyVersion;
import io.pravega.client.tables.impl.VersionImpl;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.AsyncIterator;
import java.beans.ConstructorProperties;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.SerializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueTableImpl<KeyT, ValueT>
implements KeyValueTable<KeyT, ValueT>,
AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KeyValueTableImpl.class);
    private static final KeyFamilySerializer KEY_FAMILY_SERIALIZER = new KeyFamilySerializer();
    private final KeyValueTableInfo kvt;
    private final Serializer<KeyT> keySerializer;
    private final Serializer<ValueT> valueSerializer;
    private final SegmentSelector selector;
    private final String logTraceId;
    private final AtomicBoolean closed;

    KeyValueTableImpl(@NonNull KeyValueTableInfo kvt, @NonNull TableSegmentFactory tableSegmentFactory, @NonNull Controller controller, @NonNull Serializer<KeyT> keySerializer, @NonNull Serializer<ValueT> valueSerializer) {
        if (kvt == null) {
            throw new NullPointerException("kvt is marked non-null but is null");
        }
        if (tableSegmentFactory == null) {
            throw new NullPointerException("tableSegmentFactory is marked non-null but is null");
        }
        if (controller == null) {
            throw new NullPointerException("controller is marked non-null but is null");
        }
        if (keySerializer == null) {
            throw new NullPointerException("keySerializer is marked non-null but is null");
        }
        if (valueSerializer == null) {
            throw new NullPointerException("valueSerializer is marked non-null but is null");
        }
        this.kvt = kvt;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.selector = new SegmentSelector(this.kvt, controller, tableSegmentFactory);
        this.logTraceId = String.format("KeyValueTable[%s]", this.kvt.getScopedName());
        this.closed = new AtomicBoolean(false);
        log.info("{}: Initialized. SegmentCount={}.", (Object)this.logTraceId, (Object)this.selector.getSegmentCount());
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.selector.close();
            log.info("{}: Closed.", (Object)this.logTraceId);
        }
    }

    @Override
    public KeyValueTableMap<KeyT, ValueT> getMapFor(String keyFamily) {
        return new KeyValueTableMapImpl(this, keyFamily);
    }

    @Override
    public CompletableFuture<Version> put(@Nullable String keyFamily, @NonNull KeyT key, @NonNull ValueT value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        ByteBuf keySerialization = this.serializeKey(keyFamily, key);
        TableSegment s = this.selector.getTableSegment(keyFamily, keySerialization);
        return this.updateToSegment(s, this.toTableSegmentEntry(keySerialization, this.serializeValue(value), Version.NO_VERSION));
    }

    @Override
    public CompletableFuture<Version> putIfAbsent(@Nullable String keyFamily, @NonNull KeyT key, @NonNull ValueT value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        ByteBuf keySerialization = this.serializeKey(keyFamily, key);
        TableSegment s = this.selector.getTableSegment(keyFamily, keySerialization);
        return this.updateToSegment(s, this.toTableSegmentEntry(keySerialization, this.serializeValue(value), Version.NOT_EXISTS));
    }

    @Override
    public CompletableFuture<List<Version>> putAll(@NonNull String keyFamily, @NonNull Iterable<Map.Entry<KeyT, ValueT>> entries) {
        if (keyFamily == null) {
            throw new NullPointerException("keyFamily is marked non-null but is null");
        }
        if (entries == null) {
            throw new NullPointerException("entries is marked non-null but is null");
        }
        TableSegment s = this.selector.getTableSegment(keyFamily);
        return this.updateToSegment(s, this.toTableSegmentEntries(s, keyFamily, entries, (T e) -> TableEntry.unversioned(e.getKey(), e.getValue())));
    }

    @Override
    public CompletableFuture<List<Version>> putAll(@NonNull String keyFamily, @NonNull Iterator<Map.Entry<KeyT, ValueT>> entries) {
        if (keyFamily == null) {
            throw new NullPointerException("keyFamily is marked non-null but is null");
        }
        if (entries == null) {
            throw new NullPointerException("entries is marked non-null but is null");
        }
        TableSegment s = this.selector.getTableSegment(keyFamily);
        return this.updateToSegment(s, this.toTableSegmentEntries(s, keyFamily, entries, (T e) -> TableEntry.unversioned(e.getKey(), e.getValue())));
    }

    @Override
    public CompletableFuture<Version> replace(@Nullable String keyFamily, @NonNull KeyT key, @NonNull ValueT value, @NonNull Version version) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        ByteBuf keySerialization = this.serializeKey(keyFamily, key);
        TableSegment s = this.selector.getTableSegment(keyFamily, keySerialization);
        this.validateKeyVersionSegment(s, version);
        return this.updateToSegment(s, this.toTableSegmentEntry(keySerialization, this.serializeValue(value), version));
    }

    @Override
    public CompletableFuture<List<Version>> replaceAll(@NonNull String keyFamily, @NonNull Iterable<TableEntry<KeyT, ValueT>> entries) {
        if (keyFamily == null) {
            throw new NullPointerException("keyFamily is marked non-null but is null");
        }
        if (entries == null) {
            throw new NullPointerException("entries is marked non-null but is null");
        }
        TableSegment s = this.selector.getTableSegment(keyFamily);
        return this.updateToSegment(s, this.toTableSegmentEntries(s, keyFamily, entries, (T e) -> e));
    }

    @Override
    public CompletableFuture<Void> remove(@Nullable String keyFamily, @NonNull KeyT key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ByteBuf keySerialization = this.serializeKey(keyFamily, key);
        TableSegment s = this.selector.getTableSegment(keyFamily, keySerialization);
        return this.removeFromSegment(s, (Iterator<TableSegmentKey>)Iterators.singletonIterator((Object)this.toTableSegmentKey(keySerialization, Version.NO_VERSION)));
    }

    @Override
    public CompletableFuture<Void> remove(@Nullable String keyFamily, @NonNull KeyT key, @NonNull Version version) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        ByteBuf keySerialization = this.serializeKey(keyFamily, key);
        TableSegment s = this.selector.getTableSegment(keyFamily, keySerialization);
        this.validateKeyVersionSegment(s, version);
        return this.removeFromSegment(s, (Iterator<TableSegmentKey>)Iterators.singletonIterator((Object)this.toTableSegmentKey(keySerialization, version)));
    }

    @Override
    public CompletableFuture<Void> removeAll(@NonNull String keyFamily, @NonNull Iterable<TableKey<KeyT>> keys) {
        if (keyFamily == null) {
            throw new NullPointerException("keyFamily is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        TableSegment s = this.selector.getTableSegment(keyFamily);
        return this.removeFromSegment(s, this.toTableSegmentKeys(s, keyFamily, keys));
    }

    @Override
    public CompletableFuture<TableEntry<KeyT, ValueT>> get(@Nullable String keyFamily, @NonNull KeyT key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.getAll(keyFamily, Collections.singleton(key)).thenApply(r -> (TableEntry)r.get(0));
    }

    @Override
    public CompletableFuture<List<TableEntry<KeyT, ValueT>>> getAll(@Nullable String keyFamily, @NonNull Iterable<KeyT> keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        Iterator<ByteBuf> serializedKeys = StreamSupport.stream(keys.spliterator(), false).map(k -> this.serializeKey(keyFamily, k)).iterator();
        if (keyFamily == null) {
            return this.getFromMultiSegments(serializedKeys);
        }
        TableSegment s = this.selector.getTableSegment(keyFamily);
        return this.getFromSingleSegment(s, serializedKeys, keyFamily);
    }

    @Override
    public AsyncIterator<IteratorItem<TableKey<KeyT>>> keyIterator(@NonNull String keyFamily, int maxKeysAtOnce, @Nullable IteratorState state) {
        if (keyFamily == null) {
            throw new NullPointerException("keyFamily is marked non-null but is null");
        }
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        TableSegment ts = this.selector.getTableSegment(keyFamily);
        IteratorArgs args = this.getIteratorArgs(ts, keyFamily, maxKeysAtOnce, state);
        return ts.keyIterator(args).thenApply(si -> this.fromSegmentIteratorItem(ts, keyFamily, (IteratorItem)si, this::fromTableSegmentKey));
    }

    @Override
    public AsyncIterator<IteratorItem<TableEntry<KeyT, ValueT>>> entryIterator(@NonNull String keyFamily, int maxEntriesAtOnce, @Nullable IteratorState state) {
        if (keyFamily == null) {
            throw new NullPointerException("keyFamily is marked non-null but is null");
        }
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        TableSegment ts = this.selector.getTableSegment(keyFamily);
        IteratorArgs args = this.getIteratorArgs(ts, keyFamily, maxEntriesAtOnce, state);
        return ts.entryIterator(args).thenApply(si -> this.fromSegmentIteratorItem(ts, keyFamily, (IteratorItem)si, this::fromTableSegmentEntry));
    }

    private CompletableFuture<Version> updateToSegment(TableSegment segment, TableSegmentEntry tableSegmentEntry) {
        return this.updateToSegment(segment, (Iterator<TableSegmentEntry>)Iterators.singletonIterator((Object)tableSegmentEntry)).thenApply(r -> (Version)r.get(0));
    }

    private CompletableFuture<List<Version>> updateToSegment(TableSegment segment, Iterator<TableSegmentEntry> tableSegmentEntries) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        return segment.put(tableSegmentEntries).thenApply(versions -> versions.stream().map(v -> new VersionImpl(segment.getSegmentId(), (TableSegmentKeyVersion)v)).collect(Collectors.toList()));
    }

    private CompletableFuture<Void> removeFromSegment(TableSegment segment, Iterator<TableSegmentKey> tableSegmentKeys) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        return segment.remove(tableSegmentKeys);
    }

    private CompletableFuture<List<TableEntry<KeyT, ValueT>>> getFromMultiSegments(Iterator<ByteBuf> serializedKeys) {
        HashMap<TableSegment, KeyGroup> bySegment = new HashMap<TableSegment, KeyGroup>();
        AtomicInteger count = new AtomicInteger(0);
        serializedKeys.forEachRemaining(k -> {
            TableSegment ts = this.selector.getTableSegment(null, (ByteBuf)k);
            KeyGroup g = bySegment.computeIfAbsent(ts, t -> new KeyGroup());
            g.add((ByteBuf)k, count.getAndIncrement());
        });
        HashMap futures = new HashMap();
        bySegment.forEach((ts, kg) -> futures.put(ts, ts.get(kg.keys.iterator())));
        return Futures.allOf(futures.values()).thenApply(v -> {
            TableEntry[] r = new TableEntry[count.get()];
            futures.forEach((ts, f) -> {
                KeyGroup kg = (KeyGroup)bySegment.get(ts);
                assert (f.isDone()) : "incomplete CompletableFuture returned by Futures.allOf";
                List segmentResult = (List)f.join();
                assert (segmentResult.size() == kg.ordinals.size()) : "segmentResult count mismatch";
                for (int i = 0; i < kg.ordinals.size(); ++i) {
                    assert (r[kg.ordinals.get(i)] == null) : "overlapping ordinals";
                    r[kg.ordinals.get((int)i).intValue()] = this.fromTableSegmentEntry((TableSegment)ts, (TableSegmentEntry)segmentResult.get(i), null);
                }
            });
            return Arrays.asList(r);
        });
    }

    private CompletableFuture<List<TableEntry<KeyT, ValueT>>> getFromSingleSegment(TableSegment s, Iterator<ByteBuf> serializedKeys, String expectedKeyFamily) {
        return s.get(serializedKeys).thenApply(entries -> entries.stream().map(e -> this.fromTableSegmentEntry(s, (TableSegmentEntry)e, expectedKeyFamily)).collect(Collectors.toList()));
    }

    private IteratorArgs getIteratorArgs(TableSegment ts, String keyFamily, int maxItemsAtOnce, IteratorState state) {
        IteratorStateImpl segmentIteratorState = null;
        if (state != null) {
            KeyValueTableIteratorState kvtState = KeyValueTableIteratorState.fromBytes(state.toBytes());
            Preconditions.checkArgument((boolean)this.kvt.getScopedName().equals(kvtState.getKeyValueTableName()), (String)"IteratorState refers to a different Key-ValueTable (%s) than this one (%s).", (Object)kvtState.getKeyValueTableName(), (Object)this.kvt.getScopedName());
            Preconditions.checkArgument((ts.getSegmentId() == kvtState.getSegmentId() ? 1 : 0) != 0, (String)"IteratorState refers to a different Segment (%s) than assigned to KeyFamily '%s' (%s).", (Object)kvtState.getSegmentId(), (Object)keyFamily, (Object)ts.getSegmentId());
            segmentIteratorState = IteratorStateImpl.fromBytes(kvtState.getSegmentIteratorState());
        }
        return IteratorArgs.builder().keyPrefixFilter(Unpooled.wrappedBuffer((ByteBuf)KEY_FAMILY_SERIALIZER.serialize(keyFamily))).maxItemsAtOnce(maxItemsAtOnce).state(segmentIteratorState).build();
    }

    private <T, V> IteratorItem<V> fromSegmentIteratorItem(TableSegment ts, String keyFamily, IteratorItem<T> segmentIteratorItem, SegmentItemConverter<T, V> converter) {
        IteratorStateImpl state;
        IteratorState segmentState = segmentIteratorItem.getState();
        if (segmentState.isEmpty()) {
            state = IteratorStateImpl.EMPTY;
        } else {
            KeyValueTableIteratorState kvtState = new KeyValueTableIteratorState(this.kvt.getScopedName(), ts.getSegmentId(), Unpooled.wrappedBuffer((ByteBuffer)segmentState.toBytes()));
            state = IteratorStateImpl.fromBytes(kvtState.toBytes());
        }
        List items = segmentIteratorItem.getItems().stream().map(k -> converter.apply(ts, k, keyFamily)).collect(Collectors.toList());
        return new IteratorItem(state, items);
    }

    private Iterator<TableSegmentKey> toTableSegmentKeys(TableSegment tableSegment, String keyFamily, Iterable<TableKey<KeyT>> keys) {
        return StreamSupport.stream(keys.spliterator(), false).map(k -> {
            this.validateKeyVersionSegment(tableSegment, k.getVersion());
            return this.toTableSegmentKey(this.serializeKey(keyFamily, k.getKey()), k.getVersion());
        }).iterator();
    }

    private TableSegmentKey toTableSegmentKey(ByteBuf key, Version keyVersion) {
        return new TableSegmentKey(key, this.toTableSegmentVersion(keyVersion));
    }

    private <T> Iterator<TableSegmentEntry> toTableSegmentEntries(TableSegment tableSegment, String keyFamily, Iterator<T> entries, Function<T, TableEntry<KeyT, ValueT>> getEntry) {
        return Iterators.transform(entries, e -> this.toTableSegmentEntry(tableSegment, keyFamily, e, getEntry));
    }

    private <T> Iterator<TableSegmentEntry> toTableSegmentEntries(TableSegment tableSegment, String keyFamily, Iterable<T> entries, Function<T, TableEntry<KeyT, ValueT>> getEntry) {
        return StreamSupport.stream(entries.spliterator(), false).map(e -> this.toTableSegmentEntry(tableSegment, keyFamily, e, getEntry)).iterator();
    }

    private <T> TableSegmentEntry toTableSegmentEntry(TableSegment tableSegment, String keyFamily, T fromEntry, Function<T, TableEntry<KeyT, ValueT>> getEntry) {
        TableEntry<KeyT, ValueT> entry = getEntry.apply(fromEntry);
        TableKey<KeyT> key = entry.getKey();
        this.validateKeyVersionSegment(tableSegment, key.getVersion());
        return this.toTableSegmentEntry(this.serializeKey(keyFamily, key.getKey()), this.serializeValue(entry.getValue()), key.getVersion());
    }

    private TableSegmentEntry toTableSegmentEntry(ByteBuf keySerialization, ByteBuf valueSerialization, Version keyVersion) {
        return new TableSegmentEntry(this.toTableSegmentKey(keySerialization, keyVersion), valueSerialization);
    }

    private TableSegmentKeyVersion toTableSegmentVersion(Version version) {
        return version == null ? TableSegmentKeyVersion.NO_VERSION : TableSegmentKeyVersion.from(version.asImpl().getSegmentVersion());
    }

    private TableEntry<KeyT, ValueT> fromTableSegmentEntry(TableSegment s, TableSegmentEntry e, String expectedKeyFamily) {
        if (e == null) {
            return null;
        }
        TableKey<KeyT> segmentKey = this.fromTableSegmentKey(s, e.getKey(), expectedKeyFamily);
        ValueT value = this.deserializeValue(e.getValue());
        return TableEntry.versioned(segmentKey.getKey(), segmentKey.getVersion(), value);
    }

    private TableKey<KeyT> fromTableSegmentKey(TableSegment s, TableSegmentKey tableSegmentKey, String expectedKeyFamily) {
        DeserializedKey key = this.deserializeKey(tableSegmentKey.getKey());
        this.validateKeyFamily(expectedKeyFamily, key.keyFamily);
        VersionImpl version = new VersionImpl(s.getSegmentId(), tableSegmentKey.getVersion());
        return TableKey.versioned(key.key, version);
    }

    private ByteBuf serializeKey(String keyFamily, KeyT k) {
        ByteBuf keyFamilySerialization = KEY_FAMILY_SERIALIZER.serialize(keyFamily);
        ByteBuf keySerialization = Unpooled.wrappedBuffer((ByteBuffer)this.keySerializer.serialize(k));
        Preconditions.checkArgument((keySerialization.readableBytes() <= 4096 ? 1 : 0) != 0, (String)"Key Too Long. Expected at most %s, actual %s.", (int)4096, (int)keySerialization.readableBytes());
        return Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{keyFamilySerialization, keySerialization});
    }

    private DeserializedKey deserializeKey(ByteBuf keySerialization) {
        String keyFamily = KEY_FAMILY_SERIALIZER.deserialize(keySerialization);
        KeyT key = this.keySerializer.deserialize(keySerialization.nioBuffer());
        keySerialization.release();
        return new DeserializedKey(key, keyFamily);
    }

    private ByteBuf serializeValue(ValueT v) {
        ByteBuf valueSerialization = Unpooled.wrappedBuffer((ByteBuffer)this.valueSerializer.serialize(v));
        Preconditions.checkArgument((valueSerialization.readableBytes() <= 1040384 ? 1 : 0) != 0, (String)"Value Too Long. Expected at most %s, actual %s.", (int)1040384, (int)valueSerialization.readableBytes());
        return valueSerialization;
    }

    private ValueT deserializeValue(ByteBuf s) {
        ValueT result = this.valueSerializer.deserialize(s.nioBuffer());
        s.release();
        return result;
    }

    private void validateKeyFamily(String expected, String actual) {
        boolean valid;
        boolean bl = valid = expected == null && actual == null || expected != null && expected.equals(actual);
        if (!valid) {
            throw new SerializationException(String.format("Unexpected Key Family deserialized. Expected '%s', actual '%s'.", expected, actual));
        }
    }

    private void validateKeyVersionSegment(TableSegment ts, Version version) {
        boolean valid;
        if (version == null) {
            return;
        }
        VersionImpl impl = version.asImpl();
        boolean bl = valid = impl.getSegmentId() == Long.MIN_VALUE || ts.getSegmentId() == impl.getSegmentId();
        if (!valid) {
            throw new BadKeyVersionException(this.kvt.getScopedName(), "Wrong TableSegment.");
        }
    }

    @FunctionalInterface
    private static interface SegmentItemConverter<SegmentItemType, TableItemType> {
        public TableItemType apply(TableSegment var1, SegmentItemType var2, String var3);
    }

    private static class KeyGroup {
        final ArrayList<ByteBuf> keys = new ArrayList();
        final ArrayList<Integer> ordinals = new ArrayList();

        private KeyGroup() {
        }

        void add(ByteBuf key, int ordinal) {
            this.keys.add(key);
            this.ordinals.add(ordinal);
        }
    }

    private class DeserializedKey {
        final KeyT key;
        final String keyFamily;

        @ConstructorProperties(value={"key", "keyFamily"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DeserializedKey(KeyT key, String keyFamily) {
            this.key = key;
            this.keyFamily = keyFamily;
        }
    }
}

