/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.control.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.net.InetAddresses;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.grpc.Attributes;
import io.grpc.Channel;
import io.grpc.EquivalentAddressGroup;
import io.grpc.ManagedChannelBuilder;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.pravega.controller.stream.api.grpc.v1.Controller;
import io.pravega.controller.stream.api.grpc.v1.ControllerServiceGrpc;
import java.beans.ConstructorProperties;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
class ControllerResolverFactory
extends NameResolver.Factory {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ControllerResolverFactory.class);
    private static final String SCHEME_DIRECT = "tcp";
    private static final String SCHEME_DIRECT_TLS = "tls";
    private static final String SCHEME_DIRECT_SSL = "ssl";
    private static final String SCHEME_DISCOVER = "pravega";
    private static final String SCHEME_DISCOVER_TLS = "pravegas";
    @NonNull
    private final ScheduledExecutorService executor;

    @Nullable
    public NameResolver newNameResolver(URI targetUri, NameResolver.Args params) {
        String scheme = targetUri.getScheme();
        if (!(SCHEME_DISCOVER.equals(scheme) || SCHEME_DISCOVER_TLS.equals(scheme) || SCHEME_DIRECT.equals(scheme) || SCHEME_DIRECT_SSL.equals(scheme) || SCHEME_DIRECT_TLS.equals(scheme))) {
            return null;
        }
        String authority = targetUri.getAuthority();
        List<InetSocketAddress> addresses = Splitter.on((char)',').splitToList((CharSequence)authority).stream().map(host -> {
            String[] strings = host.split(":");
            Preconditions.checkArgument((strings.length == 2 ? 1 : 0) != 0, (Object)"URI should have both address and port");
            return InetSocketAddress.createUnresolved(strings[0], Integer.parseInt(strings[1]));
        }).collect(Collectors.toList());
        return new ControllerNameResolver(authority, addresses, SCHEME_DISCOVER.equals(scheme) || SCHEME_DISCOVER_TLS.equals(scheme), this.executor);
    }

    public String getDefaultScheme() {
        return SCHEME_DIRECT;
    }

    @ConstructorProperties(value={"executor"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ControllerResolverFactory(@NonNull ScheduledExecutorService executor) {
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        this.executor = executor;
    }

    @ThreadSafe
    private static class ControllerNameResolver
    extends NameResolver {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private final Object $lock = new Object[0];
        private static final long REFRESH_INTERVAL_MS = 120000L;
        private static final long FAILURE_RETRY_TIMEOUT_MS = 10000L;
        private final String authority;
        private final List<InetSocketAddress> bootstrapServers;
        private final boolean enableDiscovery;
        private final ControllerServiceGrpc.ControllerServiceBlockingStub client;
        private final ScheduledExecutorService scheduledExecutor;
        private volatile NameResolver.Listener resolverUpdater = null;
        @GuardedBy(value="$lock")
        private ScheduledFuture<?> scheduledFuture = null;
        @GuardedBy(value="$lock")
        private long lastUpdateTimeMS = 0L;
        @GuardedBy(value="$lock")
        private boolean shutdown = false;

        ControllerNameResolver(String authority, List<InetSocketAddress> bootstrapServers, boolean enableDiscovery, ScheduledExecutorService executor) {
            this.authority = authority;
            this.bootstrapServers = ImmutableList.copyOf(bootstrapServers);
            this.enableDiscovery = enableDiscovery;
            if (this.enableDiscovery) {
                String connectString = "tcp://";
                List strings = this.bootstrapServers.stream().map(server -> server.getHostString() + ":" + server.getPort()).collect(Collectors.toList());
                connectString = connectString + String.join((CharSequence)",", strings);
                this.client = ControllerServiceGrpc.newBlockingStub((Channel)ManagedChannelBuilder.forTarget((String)connectString).nameResolverFactory((NameResolver.Factory)new ControllerResolverFactory(executor)).defaultLoadBalancingPolicy("round_robin").usePlaintext().build());
            } else {
                this.client = null;
            }
            this.scheduledExecutor = executor;
        }

        public String getServiceAuthority() {
            return this.authority;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start(NameResolver.Listener listener) {
            Object object = this.$lock;
            synchronized (object) {
                boolean scheduleDiscovery;
                Preconditions.checkState((this.resolverUpdater == null ? 1 : 0) != 0, (Object)"ControllerNameResolver has already been started");
                Preconditions.checkState((!this.shutdown ? 1 : 0) != 0, (Object)"ControllerNameResolver is shutdown, restart is not supported");
                this.resolverUpdater = listener;
                ArrayList<EquivalentAddressGroup> servers = new ArrayList<EquivalentAddressGroup>();
                if (!this.enableDiscovery) {
                    scheduleDiscovery = false;
                    for (InetSocketAddress address : this.bootstrapServers) {
                        if (InetAddresses.isInetAddress((String)address.getHostString())) {
                            servers.add(new EquivalentAddressGroup((SocketAddress)new InetSocketAddress(address.getHostString(), address.getPort())));
                            continue;
                        }
                        scheduleDiscovery = true;
                    }
                } else {
                    scheduleDiscovery = true;
                }
                if (scheduleDiscovery) {
                    this.scheduledFuture = this.scheduledExecutor.schedule(this::getControllers, 0L, TimeUnit.SECONDS);
                } else {
                    log.info("Updating client with controllers: {}", servers);
                    this.resolverUpdater.onAddresses(servers, Attributes.EMPTY);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            Object object = this.$lock;
            synchronized (object) {
                this.shutdown = true;
                if (this.scheduledFuture != null) {
                    this.scheduledFuture.cancel(true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refresh() {
            Object object = this.$lock;
            synchronized (object) {
                if (!this.shutdown && this.resolverUpdater != null && this.scheduledFuture != null && !this.scheduledFuture.isDone()) {
                    long nextUpdateDuration = this.scheduledFuture.getDelay(TimeUnit.MILLISECONDS);
                    long lastUpdateDuration = System.currentTimeMillis() - this.lastUpdateTimeMS;
                    if (nextUpdateDuration > 0L && nextUpdateDuration + lastUpdateDuration > 10000L) {
                        this.scheduledFuture.cancel(true);
                        long scheduleDelay = 0L;
                        if (lastUpdateDuration < 10000L) {
                            scheduleDelay = 10000L - lastUpdateDuration;
                        }
                        this.scheduledFuture = this.scheduledExecutor.schedule(this::getControllers, scheduleDelay, TimeUnit.MILLISECONDS);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void getControllers() {
            log.info("Attempting to refresh the controller server endpoints");
            long nextScheduleTimeMS = 120000L;
            try {
                List<Object> servers;
                if (this.enableDiscovery) {
                    Controller.ServerResponse controllerServerList = this.client.getControllerServerList(Controller.ServerRequest.getDefaultInstance());
                    servers = controllerServerList.getNodeURIList().stream().map(node -> new EquivalentAddressGroup((SocketAddress)new InetSocketAddress(node.getEndpoint(), node.getPort()))).collect(Collectors.toList());
                } else {
                    servers = new ArrayList();
                    this.bootstrapServers.forEach(address -> {
                        InetSocketAddress socketAddress = new InetSocketAddress(address.getHostString(), address.getPort());
                        if (!socketAddress.isUnresolved()) {
                            servers.add(new EquivalentAddressGroup((SocketAddress)socketAddress));
                        }
                    });
                }
                log.info("Updating client with controllers: {}", servers);
                this.resolverUpdater.onAddresses(servers, Attributes.EMPTY);
                nextScheduleTimeMS = 120000L;
            }
            catch (Throwable e) {
                if (e instanceof StatusRuntimeException) {
                    this.resolverUpdater.onError(((StatusRuntimeException)e).getStatus());
                } else {
                    this.resolverUpdater.onError(Status.UNKNOWN);
                }
                log.warn("Failed to construct controller endpoint list: ", e);
                nextScheduleTimeMS = 10000L;
            }
            finally {
                this.updateSchedule(nextScheduleTimeMS);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateSchedule(long nextScheduleTimeMS) {
            Object object = this.$lock;
            synchronized (object) {
                if (!this.shutdown) {
                    log.info("Rescheduling ControllerNameResolver task for after {} ms", (Object)nextScheduleTimeMS);
                    this.scheduledFuture = this.scheduledExecutor.schedule(this::getControllers, nextScheduleTimeMS, TimeUnit.MILLISECONDS);
                    this.lastUpdateTimeMS = System.currentTimeMillis();
                }
            }
        }
    }
}

