/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client;

import io.pravega.client.ClientConfig;
import io.pravega.client.connection.impl.SocketConnectionFactoryImpl;
import io.pravega.client.control.impl.Controller;
import io.pravega.client.control.impl.ControllerImpl;
import io.pravega.client.control.impl.ControllerImplConfig;
import io.pravega.client.state.InitialUpdate;
import io.pravega.client.state.Revisioned;
import io.pravega.client.state.RevisionedStreamClient;
import io.pravega.client.state.StateSynchronizer;
import io.pravega.client.state.SynchronizerConfig;
import io.pravega.client.state.Update;
import io.pravega.client.stream.Serializer;
import io.pravega.client.stream.impl.ClientFactoryImpl;

public interface SynchronizerClientFactory
extends AutoCloseable {
    public static SynchronizerClientFactory withScope(String scope, ClientConfig config) {
        SocketConnectionFactoryImpl connectionFactory = new SocketConnectionFactoryImpl(config);
        return new ClientFactoryImpl(scope, (Controller)new ControllerImpl(ControllerImplConfig.builder().clientConfig(config).build(), connectionFactory.getInternalExecutor()), connectionFactory);
    }

    public <T> RevisionedStreamClient<T> createRevisionedStreamClient(String var1, Serializer<T> var2, SynchronizerConfig var3);

    public <StateT extends Revisioned, UpdateT extends Update<StateT>, InitT extends InitialUpdate<StateT>> StateSynchronizer<StateT> createStateSynchronizer(String var1, Serializer<UpdateT> var2, Serializer<InitT> var3, SynchronizerConfig var4);

    @Override
    public void close();
}

