/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven;

import io.openliberty.tools.ant.FeatureManagerTask;
import io.openliberty.tools.common.CommonLoggerI;
import io.openliberty.tools.common.plugins.util.AbstractContainerSupportUtil;
import io.openliberty.tools.common.plugins.util.InstallFeatureUtil;
import io.openliberty.tools.common.plugins.util.LibertyPropFilesUtility;
import io.openliberty.tools.common.plugins.util.PluginExecutionException;
import io.openliberty.tools.common.plugins.util.PluginScenarioException;
import io.openliberty.tools.common.plugins.util.ServerFeatureUtil;
import io.openliberty.tools.maven.ServerFeatureSupport;
import io.openliberty.tools.maven.server.types.Features;
import io.openliberty.tools.maven.server.types.Key;
import io.openliberty.tools.maven.utils.CommonLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class InstallFeatureSupport
extends ServerFeatureSupport {
    @Parameter
    protected Features features;
    @Parameter(property="keys")
    private Map<String, Key> keys;
    public boolean noFeaturesSection = false;
    public boolean installFromAnt;
    public boolean installManually = false;
    protected InstallFeatureUtil util;
    public static final String FEATURES_JSON_ARTIFACT_ID = "features";

    protected Set<String> getPluginListedFeatures(boolean findEsaFiles) {
        HashSet<String> result = new HashSet<String>();
        for (FeatureManagerTask.Feature feature : this.features.getFeatures()) {
            if ((!findEsaFiles || !feature.getFeature().endsWith(".esa")) && (findEsaFiles || feature.getFeature().endsWith(".esa"))) continue;
            result.add(feature.getFeature());
            this.getLog().debug((CharSequence)("Plugin listed " + (findEsaFiles ? "ESA" : "feature") + ": " + feature.getFeature()));
        }
        return result;
    }

    protected Set<String> getDependencyFeatures() {
        HashSet<String> result = new HashSet<String>();
        List dependencyArtifacts = this.project.getDependencies();
        for (Dependency dependencyArtifact : dependencyArtifacts) {
            if (!"esa".equals(dependencyArtifact.getType())) continue;
            result.add(dependencyArtifact.getArtifactId());
            this.getLog().debug((CharSequence)("Dependency feature: " + dependencyArtifact.getArtifactId()));
        }
        return result;
    }

    protected List<String> getAdditionalJsonList() {
        ArrayList<String> result = new ArrayList<String>();
        DependencyManagement dependencyManagement = this.project.getDependencyManagement();
        if (dependencyManagement == null) {
            this.getLog().debug((CharSequence)"Features-bom is not provided by the user");
            return null;
        }
        List dependencyManagementArtifacts = dependencyManagement.getDependencies();
        for (Dependency dependencyArtifact : dependencyManagementArtifacts) {
            if (!"pom".equals(dependencyArtifact.getType()) || !"features-bom".equals(dependencyArtifact.getArtifactId())) continue;
            String coordinate = String.format("%s:%s:%s", dependencyArtifact.getGroupId(), FEATURES_JSON_ARTIFACT_ID, dependencyArtifact.getVersion());
            result.add(coordinate);
            this.getLog().debug((CharSequence)"Features-bom is provided by the user");
            this.getLog().info((CharSequence)("Additional user feature json coordinate: " + coordinate));
        }
        return result;
    }

    protected Collection<Map<String, String>> getKeyMap() {
        ArrayList<Map<String, String>> keyMapList = new ArrayList<Map<String, String>>();
        if (this.keys != null) {
            for (Key k : this.keys.values()) {
                HashMap<String, String> keyMap = new HashMap<String, String>();
                this.getLog().debug((CharSequence)("Key Id: " + k.getKeyid() + " Key URL: " + k.getKeyurl()));
                keyMap.put("keyid", k.getKeyid());
                keyMap.put("keyurl", k.getKeyurl());
                keyMapList.add(keyMap);
            }
        }
        return keyMapList;
    }

    protected boolean initialize() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"\nSkipping install-feature goal.\n");
            return false;
        }
        if (this.features == null) {
            this.noFeaturesSection = true;
            this.features = new Features();
        }
        this.checkServerHomeExists();
        return true;
    }

    protected ServerFeatureUtil.FeaturesPlatforms getSpecifiedFeatures(String containerName) throws PluginExecutionException {
        ServerFeatureUtil.FeaturesPlatforms getServerResult;
        Set<String> pluginListedFeatures = this.getPluginListedFeatures(false);
        if (this.util == null) {
            Set<String> pluginListedEsas = this.getPluginListedFeatures(true);
            this.util = this.getInstallFeatureUtil(pluginListedEsas, containerName);
        }
        if (this.util == null && this.noFeaturesSection) {
            return new ServerFeatureUtil.FeaturesPlatforms();
        }
        if (this.util == null && !this.noFeaturesSection) {
            HashSet<String> featuresToInstall = new HashSet<String>();
            for (FeatureManagerTask.Feature feature : this.features.getFeatures()) {
                featuresToInstall.add(feature.toString());
            }
            return new ServerFeatureUtil.FeaturesPlatforms(featuresToInstall, new HashSet());
        }
        Set<String> dependencyFeatures = this.getDependencyFeatures();
        Set serverFeatures = new HashSet();
        Set serverPlatforms = new HashSet();
        ServerFeatureUtil.FeaturesPlatforms featuresPlatforms = getServerResult = this.serverDirectory.exists() ? this.util.getServerFeatures(this.serverDirectory, LibertyPropFilesUtility.getLibertyDirectoryPropertyFiles((CommonLoggerI)new CommonLogger(this.getLog()), (File)this.installDirectory, (File)this.userDirectory, (File)this.serverDirectory, (File)new File(this.outputDirectory, this.serverName))) : null;
        if (getServerResult != null) {
            serverFeatures = getServerResult.getFeatures();
            serverPlatforms = getServerResult.getPlatforms();
        }
        return new ServerFeatureUtil.FeaturesPlatforms(this.util.combineToSet(new Collection[]{pluginListedFeatures, dependencyFeatures, serverFeatures}), serverPlatforms);
    }

    private void createNewInstallFeatureUtil(Set<String> pluginListedEsas, List<InstallFeatureUtil.ProductProperties> propertiesList, String openLibertyVerion, String containerName, List<String> additionalJsons, Collection<Map<String, String>> keyMap) throws PluginExecutionException {
        try {
            this.util = new InstallFeatureMojoUtil(pluginListedEsas, propertiesList, openLibertyVerion, containerName, additionalJsons, keyMap);
        }
        catch (PluginScenarioException e) {
            this.getLog().debug((CharSequence)e.getMessage());
            if (this.noFeaturesSection) {
                this.getLog().debug((CharSequence)"Skipping feature installation with installUtility because the features configuration element with an acceptLicense parameter was not specified for the install-feature goal.");
            }
            if (additionalJsons != null && !additionalJsons.isEmpty()) {
                this.getLog().debug((CharSequence)"Skipping feature installation with installUtility because it is not supported for user feature");
            }
            this.installFromAnt = true;
            this.getLog().debug((CharSequence)"Installing features from installUtility.");
        }
    }

    protected InstallFeatureUtil getInstallFeatureUtil(Set<String> pluginListedEsas, String containerName) throws PluginExecutionException {
        List propertiesList = null;
        String openLibertyVersion = null;
        if (containerName == null) {
            propertiesList = InstallFeatureUtil.loadProperties((File)this.installDirectory);
            openLibertyVersion = InstallFeatureUtil.getOpenLibertyVersion((List)propertiesList);
        }
        List<String> additionalJsons = this.getAdditionalJsonList();
        Collection<Map<String, String>> keyMap = this.getKeyMap();
        return this.getInstallFeatureUtil(pluginListedEsas, propertiesList, openLibertyVersion, containerName, additionalJsons, keyMap);
    }

    protected InstallFeatureUtil getInstallFeatureUtil(Set<String> pluginListedEsas, List<InstallFeatureUtil.ProductProperties> propertiesList, String openLibertyVersion, String containerName, List<String> additionalJsons, Collection<Map<String, String>> keyMap) throws PluginExecutionException {
        this.getLog().info((CharSequence)("Feature signature verify option: " + this.features.getVerify()));
        this.createNewInstallFeatureUtil(pluginListedEsas, propertiesList, openLibertyVersion, containerName, additionalJsons, keyMap);
        return this.util;
    }

    protected class InstallFeatureMojoUtil
    extends InstallFeatureUtil {
        public InstallFeatureMojoUtil(Set<String> pluginListedEsas, List<InstallFeatureUtil.ProductProperties> propertiesList, String openLibertyVerion, String containerName, List<String> additionalJsons, Collection<Map<String, String>> keyMap) throws PluginScenarioException, PluginExecutionException {
            super(InstallFeatureSupport.this.installDirectory, new File(InstallFeatureSupport.this.project.getBuild().getDirectory()), InstallFeatureSupport.this.features.getFrom(), InstallFeatureSupport.this.features.getTo(), pluginListedEsas, propertiesList, openLibertyVerion, containerName, additionalJsons, InstallFeatureSupport.this.features.getVerify(), keyMap);
            InstallFeatureSupport.this.setContainerEngine((AbstractContainerSupportUtil)this);
        }

        public void debug(String msg) {
            InstallFeatureSupport.this.getLog().debug((CharSequence)msg);
        }

        public void debug(String msg, Throwable e) {
            InstallFeatureSupport.this.getLog().debug((CharSequence)msg, e);
        }

        public void debug(Throwable e) {
            InstallFeatureSupport.this.getLog().debug(e);
        }

        public void warn(String msg) {
            InstallFeatureSupport.this.getLog().warn((CharSequence)msg);
        }

        public void info(String msg) {
            InstallFeatureSupport.this.getLog().info((CharSequence)msg);
        }

        public boolean isDebugEnabled() {
            return InstallFeatureSupport.this.getLog().isDebugEnabled();
        }

        public void error(String msg) {
            InstallFeatureSupport.this.getLog().error((CharSequence)msg);
        }

        public void error(String msg, Throwable e) {
            InstallFeatureSupport.this.getLog().error((CharSequence)msg, e);
        }

        public File downloadArtifact(String groupId, String artifactId, String type, String version) throws PluginExecutionException {
            try {
                return InstallFeatureSupport.this.getArtifact(groupId, artifactId, type, version).getFile();
            }
            catch (MojoExecutionException e) {
                throw new PluginExecutionException((Throwable)e);
            }
        }

        public File downloadSignature(File esa, String groupId, String artifactId, String type, String version) throws PluginExecutionException {
            return this.downloadArtifact(groupId, artifactId, type, version);
        }
    }
}

