/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.internal.EmptyArrays;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.regex.Pattern;

public final class AsciiString
implements CharSequence,
Comparable<CharSequence> {
    public static final AsciiString EMPTY_STRING = new AsciiString("");
    public static final Comparator<AsciiString> CASE_INSENSITIVE_ORDER = new Comparator<AsciiString>(){

        @Override
        public int compare(AsciiString o1, AsciiString o2) {
            return CHARSEQUENCE_CASE_INSENSITIVE_ORDER.compare(o1, o2);
        }
    };
    public static final Comparator<AsciiString> CASE_SENSITIVE_ORDER = new Comparator<AsciiString>(){

        @Override
        public int compare(AsciiString o1, AsciiString o2) {
            return CHARSEQUENCE_CASE_SENSITIVE_ORDER.compare(o1, o2);
        }
    };
    public static final Comparator<CharSequence> CHARSEQUENCE_CASE_INSENSITIVE_ORDER = new Comparator<CharSequence>(){

        @Override
        public int compare(CharSequence o1, CharSequence o2) {
            if (o1 == o2) {
                return 0;
            }
            AsciiString a1 = o1 instanceof AsciiString ? (AsciiString)o1 : null;
            AsciiString a2 = o2 instanceof AsciiString ? (AsciiString)o2 : null;
            int length1 = o1.length();
            int length2 = o2.length();
            int minLength = Math.min(length1, length2);
            if (a1 != null && a2 != null) {
                byte[] thisValue = a1.value;
                byte[] thatValue = a2.value;
                for (int i = 0; i < minLength; ++i) {
                    int c2;
                    int c1;
                    int result;
                    byte v1 = thisValue[i];
                    byte v2 = thatValue[i];
                    if (v1 == v2 || (result = (c1 = AsciiString.toLowerCase(v1) & 0xFF) - (c2 = AsciiString.toLowerCase(v2) & 0xFF)) == 0) continue;
                    return result;
                }
            } else if (a1 != null) {
                byte[] thisValue = a1.value;
                for (int i = 0; i < minLength; ++i) {
                    char c2;
                    int c1 = AsciiString.toLowerCase(thisValue[i]) & 0xFF;
                    int result = c1 - (c2 = AsciiString.toLowerCase(o2.charAt(i)));
                    if (result == 0) continue;
                    return result;
                }
            } else if (a2 != null) {
                byte[] thatValue = a2.value;
                for (int i = 0; i < minLength; ++i) {
                    int c2;
                    char c1 = AsciiString.toLowerCase(o1.charAt(i));
                    int result = c1 - (c2 = AsciiString.toLowerCase(thatValue[i]) & 0xFF);
                    if (result == 0) continue;
                    return result;
                }
            } else {
                for (int i = 0; i < minLength; ++i) {
                    char c2;
                    char c1 = AsciiString.toLowerCase(o1.charAt(i));
                    int result = c1 - (c2 = AsciiString.toLowerCase(o2.charAt(i)));
                    if (result == 0) continue;
                    return result;
                }
            }
            return length1 - length2;
        }
    };
    public static final Comparator<CharSequence> CHARSEQUENCE_CASE_SENSITIVE_ORDER = new Comparator<CharSequence>(){

        @Override
        public int compare(CharSequence o1, CharSequence o2) {
            if (o1 == o2) {
                return 0;
            }
            AsciiString a1 = o1 instanceof AsciiString ? (AsciiString)o1 : null;
            AsciiString a2 = o2 instanceof AsciiString ? (AsciiString)o2 : null;
            int length1 = o1.length();
            int length2 = o2.length();
            int minLength = Math.min(length1, length2);
            if (a1 != null && a2 != null) {
                byte[] thisValue = a1.value;
                byte[] thatValue = a2.value;
                for (int i = 0; i < minLength; ++i) {
                    byte v1 = thisValue[i];
                    byte v2 = thatValue[i];
                    int result = v1 - v2;
                    if (result == 0) continue;
                    return result;
                }
            } else if (a1 != null) {
                byte[] thisValue = a1.value;
                for (int i = 0; i < minLength; ++i) {
                    byte c1 = thisValue[i];
                    char c2 = o2.charAt(i);
                    int result = c1 - c2;
                    if (result == 0) continue;
                    return result;
                }
            } else if (a2 != null) {
                byte[] thatValue = a2.value;
                for (int i = 0; i < minLength; ++i) {
                    byte c2;
                    char c1 = o1.charAt(i);
                    int result = c1 - (c2 = thatValue[i]);
                    if (result == 0) continue;
                    return result;
                }
            } else {
                for (int i = 0; i < minLength; ++i) {
                    char c2;
                    char c1 = o1.charAt(i);
                    int result = c1 - (c2 = o2.charAt(i));
                    if (result == 0) continue;
                    return result;
                }
            }
            return length1 - length2;
        }
    };
    private final byte[] value;
    private String string;
    private int hash;

    public static int caseInsensitiveHashCode(CharSequence value) {
        if (value instanceof AsciiString) {
            return value.hashCode();
        }
        int hash = 0;
        int end = value.length();
        for (int i = 0; i < end; ++i) {
            hash = hash * 31 ^ value.charAt(i) & 0x1F;
        }
        return hash;
    }

    public static boolean equalsIgnoreCase(CharSequence a, CharSequence b) {
        if (a == b) {
            return true;
        }
        if (a instanceof AsciiString) {
            AsciiString aa = (AsciiString)a;
            return aa.equalsIgnoreCase(b);
        }
        if (b instanceof AsciiString) {
            AsciiString ab = (AsciiString)b;
            return ab.equalsIgnoreCase(a);
        }
        if (a == null || b == null) {
            return false;
        }
        return a.toString().equalsIgnoreCase(b.toString());
    }

    public static boolean equals(CharSequence a, CharSequence b) {
        if (a == b) {
            return true;
        }
        if (a instanceof AsciiString) {
            AsciiString aa = (AsciiString)a;
            return aa.equals(b);
        }
        if (b instanceof AsciiString) {
            AsciiString ab = (AsciiString)b;
            return ab.equals(a);
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(CharSequence v, Charset charset) {
        if (v instanceof AsciiString) {
            return ((AsciiString)v).array();
        }
        if (v instanceof String) {
            return ((String)v).getBytes(charset);
        }
        if (v != null) {
            ByteBuf buf = Unpooled.copiedBuffer(v, charset);
            try {
                if (buf.hasArray()) {
                    byte[] byArray = buf.array();
                    return byArray;
                }
                byte[] result = new byte[buf.readableBytes()];
                buf.readBytes(result);
                byte[] byArray = result;
                return byArray;
            }
            finally {
                buf.release();
            }
        }
        return null;
    }

    public static AsciiString of(CharSequence string) {
        return string instanceof AsciiString ? (AsciiString)string : new AsciiString(string);
    }

    public AsciiString(byte[] value) {
        this(value, true);
    }

    public AsciiString(byte[] value, boolean copy) {
        AsciiString.checkNull(value);
        this.value = copy ? (byte[])value.clone() : value;
    }

    public AsciiString(byte[] value, int start, int length) {
        this(value, start, length, true);
    }

    public AsciiString(byte[] value, int start, int length, boolean copy) {
        AsciiString.checkNull(value);
        if (start < 0 || start > value.length - length) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= start + length(" + length + ") <= " + "value.length(" + value.length + ')');
        }
        this.value = copy || start != 0 || length != value.length ? Arrays.copyOfRange(value, start, start + length) : value;
    }

    public AsciiString(char[] value) {
        this(AsciiString.checkNull(value), 0, value.length);
    }

    public AsciiString(char[] value, int start, int length) {
        AsciiString.checkNull(value);
        if (start < 0 || start > value.length - length) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= start + length(" + length + ") <= " + "value.length(" + value.length + ')');
        }
        this.value = new byte[length];
        int i = 0;
        int j = start;
        while (i < length) {
            this.value[i] = AsciiString.c2b(value[j]);
            ++i;
            ++j;
        }
    }

    public AsciiString(CharSequence value) {
        this(AsciiString.checkNull(value), 0, value.length());
    }

    public AsciiString(CharSequence value, int start, int length) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (start < 0 || length < 0 || length > value.length() - start) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= start + length(" + length + ") <= " + "value.length(" + value.length() + ')');
        }
        this.value = new byte[length];
        for (int i = 0; i < length; ++i) {
            this.value[i] = AsciiString.c2b(value.charAt(start + i));
        }
    }

    public AsciiString(ByteBuffer value) {
        this(AsciiString.checkNull(value), value.position(), value.remaining());
    }

    public AsciiString(ByteBuffer value, int start, int length) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (start < 0 || length > value.capacity() - start) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= start + length(" + length + ") <= " + "value.capacity(" + value.capacity() + ')');
        }
        if (value.hasArray()) {
            int baseOffset = value.arrayOffset() + start;
            this.value = Arrays.copyOfRange(value.array(), baseOffset, baseOffset + length);
        } else {
            this.value = new byte[length];
            int oldPos = value.position();
            value.get(this.value, 0, this.value.length);
            value.position(oldPos);
        }
    }

    private static <T> T checkNull(T value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        return value;
    }

    @Override
    public int length() {
        return this.value.length;
    }

    @Override
    public char charAt(int index) {
        return (char)(this.byteAt(index) & 0xFF);
    }

    public byte byteAt(int index) {
        return this.value[index];
    }

    public byte[] array() {
        return this.value;
    }

    public int arrayOffset() {
        return 0;
    }

    private static byte c2b(char c) {
        if (c > '\u00ff') {
            return 63;
        }
        return (byte)c;
    }

    private static byte toLowerCase(byte b) {
        if (65 <= b && b <= 90) {
            return (byte)(b + 32);
        }
        return b;
    }

    private static char toLowerCase(char c) {
        if ('A' <= c && c <= 'Z') {
            return (char)(c + 32);
        }
        return c;
    }

    private static byte toUpperCase(byte b) {
        if (97 <= b && b <= 122) {
            return (byte)(b - 32);
        }
        return b;
    }

    public AsciiString subSequence(int start) {
        return this.subSequence(start, this.length());
    }

    @Override
    public AsciiString subSequence(int start, int end) {
        if (start < 0 || start > end || end > this.length()) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= end (" + end + ") <= length(" + this.length() + ')');
        }
        byte[] value = this.value;
        if (start == 0 && end == value.length) {
            return this;
        }
        if (end == start) {
            return EMPTY_STRING;
        }
        return new AsciiString(value, start, end - start, false);
    }

    public int hashCode() {
        int hash = this.hash;
        byte[] value = this.value;
        if (hash != 0 || value.length == 0) {
            return hash;
        }
        for (int i = 0; i < value.length; ++i) {
            hash = hash * 31 ^ value[i] & 0x1F;
        }
        this.hash = hash;
        return this.hash;
    }

    public boolean equals(Object obj) {
        int thatHash;
        if (!(obj instanceof AsciiString)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        AsciiString that = (AsciiString)obj;
        int thisHash = this.hashCode();
        if (thisHash != (thatHash = that.hashCode()) || this.length() != that.length()) {
            return false;
        }
        byte[] thisValue = this.value;
        byte[] thatValue = that.value;
        int end = thisValue.length;
        int i = 0;
        int j = 0;
        while (i < end) {
            if (thisValue[i] != thatValue[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    @Override
    public String toString() {
        String string = this.string;
        if (string != null) {
            return string;
        }
        byte[] value = this.value;
        this.string = new String(value, 0, 0, value.length);
        return this.string;
    }

    public String toString(int start, int end) {
        byte[] value = this.value;
        if (start == 0 && end == value.length) {
            return this.toString();
        }
        int length = end - start;
        if (length == 0) {
            return "";
        }
        return new String(value, 0, start, length);
    }

    @Override
    public int compareTo(CharSequence string) {
        if (this == string) {
            return 0;
        }
        int length1 = this.length();
        int length2 = string.length();
        int minLength = Math.min(length1, length2);
        byte[] value = this.value;
        int i = 0;
        for (int j = 0; j < minLength; ++j) {
            int result = (value[i] & 0xFF) - string.charAt(j);
            if (result != 0) {
                return result;
            }
            ++i;
        }
        return length1 - length2;
    }

    public int compareToIgnoreCase(CharSequence string) {
        return CHARSEQUENCE_CASE_INSENSITIVE_ORDER.compare(this, string);
    }

    public AsciiString concat(CharSequence string) {
        int thisLen = this.length();
        int thatLen = string.length();
        if (thatLen == 0) {
            return this;
        }
        if (string instanceof AsciiString) {
            AsciiString that = (AsciiString)string;
            if (this.isEmpty()) {
                return that;
            }
            byte[] newValue = Arrays.copyOf(this.value, thisLen + thatLen);
            System.arraycopy(that.value, 0, newValue, thisLen, thatLen);
            return new AsciiString(newValue, false);
        }
        if (this.isEmpty()) {
            return new AsciiString(string);
        }
        int newLen = thisLen + thatLen;
        byte[] newValue = Arrays.copyOf(this.value, newLen);
        int i = thisLen;
        int j = 0;
        while (i < newLen) {
            newValue[i] = AsciiString.c2b(string.charAt(j));
            ++i;
            ++j;
        }
        return new AsciiString(newValue, false);
    }

    public boolean endsWith(CharSequence suffix) {
        int suffixLen = suffix.length();
        return this.regionMatches(this.length() - suffixLen, suffix, 0, suffixLen);
    }

    public boolean equalsIgnoreCase(CharSequence string) {
        if (string == this) {
            return true;
        }
        if (string == null) {
            return false;
        }
        byte[] value = this.value;
        int thisLen = value.length;
        int thatLen = string.length();
        if (thisLen != thatLen) {
            return false;
        }
        for (int i = 0; i < thisLen; ++i) {
            char c1 = (char)(value[i] & 0xFF);
            char c2 = string.charAt(i);
            if (c1 == c2 || AsciiString.toLowerCase(c1) == AsciiString.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }

    public byte[] toByteArray() {
        return this.toByteArray(0, this.length());
    }

    public byte[] toByteArray(int start, int end) {
        return Arrays.copyOfRange(this.value, start, end);
    }

    public char[] toCharArray() {
        return this.toCharArray(0, this.length());
    }

    public char[] toCharArray(int start, int end) {
        int length = end - start;
        if (length == 0) {
            return EmptyArrays.EMPTY_CHARS;
        }
        byte[] value = this.value;
        char[] buffer = new char[length];
        int i = 0;
        int j = start;
        while (i < length) {
            buffer[i] = (char)(value[j] & 0xFF);
            ++i;
            ++j;
        }
        return buffer;
    }

    public void copy(int srcIdx, ByteBuf dst, int dstIdx, int length) {
        if (dst == null) {
            throw new NullPointerException("dst");
        }
        byte[] value = this.value;
        int thisLen = value.length;
        if (srcIdx < 0 || length > thisLen - srcIdx) {
            throw new IndexOutOfBoundsException("expected: 0 <= srcIdx(" + srcIdx + ") <= srcIdx + length(" + length + ") <= srcLen(" + thisLen + ')');
        }
        dst.setBytes(dstIdx, value, srcIdx, length);
    }

    public void copy(int srcIdx, ByteBuf dst, int length) {
        if (dst == null) {
            throw new NullPointerException("dst");
        }
        byte[] value = this.value;
        int thisLen = value.length;
        if (srcIdx < 0 || length > thisLen - srcIdx) {
            throw new IndexOutOfBoundsException("expected: 0 <= srcIdx(" + srcIdx + ") <= srcIdx + length(" + length + ") <= srcLen(" + thisLen + ')');
        }
        dst.writeBytes(value, srcIdx, length);
    }

    public void copy(int srcIdx, byte[] dst, int dstIdx, int length) {
        if (dst == null) {
            throw new NullPointerException("dst");
        }
        byte[] value = this.value;
        int thisLen = value.length;
        if (srcIdx < 0 || length > thisLen - srcIdx) {
            throw new IndexOutOfBoundsException("expected: 0 <= srcIdx(" + srcIdx + ") <= srcIdx + length(" + length + ") <= srcLen(" + thisLen + ')');
        }
        System.arraycopy(value, srcIdx, dst, dstIdx, length);
    }

    public void copy(int srcIdx, char[] dst, int dstIdx, int length) {
        if (dst == null) {
            throw new NullPointerException("dst");
        }
        byte[] value = this.value;
        int thisLen = value.length;
        if (srcIdx < 0 || length > thisLen - srcIdx) {
            throw new IndexOutOfBoundsException("expected: 0 <= srcIdx(" + srcIdx + ") <= srcIdx + length(" + length + ") <= srcLen(" + thisLen + ')');
        }
        int dstEnd = dstIdx + length;
        int i = srcIdx;
        for (int j = dstIdx; j < dstEnd; ++j) {
            dst[j] = (char)(value[i] & 0xFF);
            ++i;
        }
    }

    public int indexOf(int c) {
        return this.indexOf(c, 0);
    }

    public int indexOf(int c, int start) {
        byte[] value = this.value;
        int length = value.length;
        if (start < length) {
            if (start < 0) {
                start = 0;
            }
            for (int i = start; i < length; ++i) {
                if ((value[i] & 0xFF) != c) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(CharSequence string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(CharSequence subString, int start) {
        if (start < 0) {
            start = 0;
        }
        byte[] value = this.value;
        int thisLen = value.length;
        int subCount = subString.length();
        if (subCount <= 0) {
            return start < thisLen ? start : thisLen;
        }
        if (subCount > thisLen - start) {
            return -1;
        }
        char firstChar = subString.charAt(0);
        int i;
        while ((i = this.indexOf(firstChar, start)) != -1 && subCount + i <= thisLen) {
            int o1 = i;
            int o2 = 0;
            while (++o2 < subCount && (value[++o1] & 0xFF) == subString.charAt(o2)) {
            }
            if (o2 == subCount) {
                return i;
            }
            start = i + 1;
        }
        return -1;
    }

    public int lastIndexOf(int c) {
        return this.lastIndexOf(c, this.length() - 1);
    }

    public int lastIndexOf(int c, int start) {
        if (start >= 0) {
            byte[] value = this.value;
            int length = value.length;
            if (start >= length) {
                start = length - 1;
            }
            for (int i = start; i >= 0; --i) {
                if ((value[i] & 0xFF) != c) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(CharSequence string) {
        return this.lastIndexOf(string, this.length());
    }

    public int lastIndexOf(CharSequence subString, int start) {
        byte[] value = this.value;
        int thisLen = value.length;
        int subCount = subString.length();
        if (subCount > thisLen || start < 0) {
            return -1;
        }
        if (subCount <= 0) {
            return start < thisLen ? start : thisLen;
        }
        start = Math.min(start, thisLen - subCount);
        char firstChar = subString.charAt(0);
        int i;
        while ((i = this.lastIndexOf(firstChar, start)) != -1) {
            int o1 = i;
            int o2 = 0;
            while (++o2 < subCount && (value[++o1] & 0xFF) == subString.charAt(o2)) {
            }
            if (o2 == subCount) {
                return i;
            }
            start = i - 1;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.value.length == 0;
    }

    public boolean regionMatches(int thisStart, CharSequence string, int start, int length) {
        if (string == null) {
            throw new NullPointerException("string");
        }
        if (start < 0 || string.length() - start < length) {
            return false;
        }
        byte[] value = this.value;
        int thisLen = value.length;
        if (thisStart < 0 || thisLen - thisStart < length) {
            return false;
        }
        if (length <= 0) {
            return true;
        }
        int thisEnd = thisStart + length;
        int i = thisStart;
        int j = start;
        while (i < thisEnd) {
            if ((value[i] & 0xFF) != string.charAt(j)) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public boolean regionMatches(boolean ignoreCase, int thisStart, CharSequence string, int start, int length) {
        if (!ignoreCase) {
            return this.regionMatches(thisStart, string, start, length);
        }
        if (string == null) {
            throw new NullPointerException("string");
        }
        byte[] value = this.value;
        int thisLen = value.length;
        if (thisStart < 0 || length > thisLen - thisStart) {
            return false;
        }
        if (start < 0 || length > string.length() - start) {
            return false;
        }
        int thisEnd = thisStart + length;
        while (thisStart < thisEnd) {
            char c2;
            char c1;
            if ((c1 = (char)(value[thisStart++] & 0xFF)) == (c2 = string.charAt(start++)) || AsciiString.toLowerCase(c1) == AsciiString.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }

    public AsciiString replace(char oldChar, char newChar) {
        int index = this.indexOf(oldChar, 0);
        if (index == -1) {
            return this;
        }
        byte[] value = this.value;
        int count = value.length;
        byte[] buffer = new byte[count];
        int i = 0;
        int j = 0;
        while (i < value.length) {
            byte b = value[i];
            if ((char)(b & 0xFF) == oldChar) {
                b = (byte)newChar;
            }
            buffer[j] = b;
            ++i;
            ++j;
        }
        return new AsciiString(buffer, false);
    }

    public boolean startsWith(CharSequence prefix) {
        return this.startsWith(prefix, 0);
    }

    public boolean startsWith(CharSequence prefix, int start) {
        return this.regionMatches(start, prefix, 0, prefix.length());
    }

    public AsciiString toLowerCase() {
        int i;
        boolean lowercased = true;
        byte[] value = this.value;
        for (i = 0; i < value.length; ++i) {
            byte b = value[i];
            if (b < 65 || b > 90) continue;
            lowercased = false;
            break;
        }
        if (lowercased) {
            return this;
        }
        int length = value.length;
        byte[] newValue = new byte[length];
        i = 0;
        int j = 0;
        while (i < length) {
            newValue[i] = AsciiString.toLowerCase(value[j]);
            ++i;
            ++j;
        }
        return new AsciiString(newValue, false);
    }

    public AsciiString toUpperCase() {
        int i;
        byte[] value = this.value;
        boolean uppercased = true;
        for (i = 0; i < value.length; ++i) {
            byte b = value[i];
            if (b < 97 || b > 122) continue;
            uppercased = false;
            break;
        }
        if (uppercased) {
            return this;
        }
        int length = value.length;
        byte[] newValue = new byte[length];
        i = 0;
        int j = 0;
        while (i < length) {
            newValue[i] = AsciiString.toUpperCase(value[j]);
            ++i;
            ++j;
        }
        return new AsciiString(newValue, false);
    }

    public AsciiString trim() {
        int start;
        int last;
        byte[] value = this.value;
        int end = last = value.length;
        for (start = 0; start <= end && value[start] <= 32; ++start) {
        }
        while (end >= start && value[end] <= 32) {
            --end;
        }
        if (start == 0 && end == last) {
            return this;
        }
        return new AsciiString(value, start, end - start + 1, false);
    }

    public boolean contentEquals(CharSequence cs) {
        int length2;
        if (cs == null) {
            throw new NullPointerException();
        }
        int length1 = this.length();
        if (length1 != (length2 = cs.length())) {
            return false;
        }
        if (length1 == 0 && length2 == 0) {
            return true;
        }
        return this.regionMatches(0, cs, 0, length2);
    }

    public boolean matches(String expr) {
        return Pattern.matches(expr, this);
    }

    public AsciiString[] split(String expr, int max) {
        return AsciiString.toAsciiStringArray(Pattern.compile(expr).split(this, max));
    }

    private static AsciiString[] toAsciiStringArray(String[] jdkResult) {
        AsciiString[] res = new AsciiString[jdkResult.length];
        for (int i = 0; i < jdkResult.length; ++i) {
            res[i] = new AsciiString(jdkResult[i]);
        }
        return res;
    }

    public AsciiString[] split(char delim) {
        int i;
        ArrayList<AsciiString> res = new ArrayList<AsciiString>();
        int start = 0;
        byte[] value = this.value;
        int length = value.length;
        for (i = start; i < length; ++i) {
            if (this.charAt(i) != delim) continue;
            if (start == i) {
                res.add(EMPTY_STRING);
            } else {
                res.add(new AsciiString(value, start, i - start, false));
            }
            start = i + 1;
        }
        if (start == 0) {
            res.add(this);
        } else if (start != length) {
            res.add(new AsciiString(value, start, length - start, false));
        } else {
            for (i = res.size() - 1; i >= 0 && ((AsciiString)res.get(i)).isEmpty(); --i) {
                res.remove(i);
            }
        }
        return res.toArray(new AsciiString[res.size()]);
    }

    public boolean contains(CharSequence cs) {
        if (cs == null) {
            throw new NullPointerException();
        }
        return this.indexOf(cs) >= 0;
    }

    public int parseInt() {
        return this.parseInt(0, this.length(), 10);
    }

    public int parseInt(int radix) {
        return this.parseInt(0, this.length(), radix);
    }

    public int parseInt(int start, int end) {
        return this.parseInt(start, end, 10);
    }

    public int parseInt(int start, int end, int radix) {
        boolean negative;
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException();
        }
        if (start == end) {
            throw new NumberFormatException();
        }
        int i = start;
        boolean bl = negative = this.charAt(i) == '-';
        if (negative && ++i == end) {
            throw new NumberFormatException(this.subSequence(start, end).toString());
        }
        return this.parseInt(i, end, radix, negative);
    }

    private int parseInt(int start, int end, int radix, boolean negative) {
        byte[] value = this.value;
        int max = Integer.MIN_VALUE / radix;
        int result = 0;
        int offset = start;
        while (offset < end) {
            int digit;
            if ((digit = Character.digit((char)(value[offset++] & 0xFF), radix)) == -1) {
                throw new NumberFormatException(this.subSequence(start, end).toString());
            }
            if (max > result) {
                throw new NumberFormatException(this.subSequence(start, end).toString());
            }
            int next = result * radix - digit;
            if (next > result) {
                throw new NumberFormatException(this.subSequence(start, end).toString());
            }
            result = next;
        }
        if (!negative && (result = -result) < 0) {
            throw new NumberFormatException(this.subSequence(start, end).toString());
        }
        return result;
    }

    public long parseLong() {
        return this.parseLong(0, this.length(), 10);
    }

    public long parseLong(int radix) {
        return this.parseLong(0, this.length(), radix);
    }

    public long parseLong(int start, int end) {
        return this.parseLong(start, end, 10);
    }

    public long parseLong(int start, int end, int radix) {
        boolean negative;
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException();
        }
        if (start == end) {
            throw new NumberFormatException();
        }
        int i = start;
        boolean bl = negative = this.charAt(i) == '-';
        if (negative && ++i == end) {
            throw new NumberFormatException(this.subSequence(start, end).toString());
        }
        return this.parseLong(i, end, radix, negative);
    }

    private long parseLong(int start, int end, int radix, boolean negative) {
        byte[] value = this.value;
        long max = Long.MIN_VALUE / (long)radix;
        long result = 0L;
        int offset = start;
        while (offset < end) {
            int digit;
            if ((digit = Character.digit((char)(value[offset++] & 0xFF), radix)) == -1) {
                throw new NumberFormatException(this.subSequence(start, end).toString());
            }
            if (max > result) {
                throw new NumberFormatException(this.subSequence(start, end).toString());
            }
            long next = result * (long)radix - (long)digit;
            if (next > result) {
                throw new NumberFormatException(this.subSequence(start, end).toString());
            }
            result = next;
        }
        if (!negative && (result = -result) < 0L) {
            throw new NumberFormatException(this.subSequence(start, end).toString());
        }
        return result;
    }

    public short parseShort() {
        return this.parseShort(0, this.length(), 10);
    }

    public short parseShort(int radix) {
        return this.parseShort(0, this.length(), radix);
    }

    public short parseShort(int start, int end) {
        return this.parseShort(start, end, 10);
    }

    public short parseShort(int start, int end, int radix) {
        int intValue = this.parseInt(start, end, radix);
        short result = (short)intValue;
        if (result != intValue) {
            throw new NumberFormatException(this.subSequence(start, end).toString());
        }
        return result;
    }

    public float parseFloat() {
        return this.parseFloat(0, this.length());
    }

    public float parseFloat(int start, int end) {
        return Float.parseFloat(this.toString(start, end));
    }

    public double parseDouble() {
        return this.parseDouble(0, this.length());
    }

    public double parseDouble(int start, int end) {
        return Double.parseDouble(this.toString(start, end));
    }
}

