/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2.internal.hpack;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.internal.hpack.DynamicTable;
import io.netty.handler.codec.http2.internal.hpack.HeaderField;
import io.netty.handler.codec.http2.internal.hpack.HpackUtil;
import io.netty.handler.codec.http2.internal.hpack.HuffmanDecoder;
import io.netty.handler.codec.http2.internal.hpack.StaticTable;
import io.netty.util.AsciiString;
import io.netty.util.internal.ThrowableUtil;
import java.io.IOException;

public final class Decoder {
    private static final IOException DECODE_DECOMPRESSION_EXCEPTION = ThrowableUtil.unknownStackTrace(new IOException("HPACK - decompression failure"), Decoder.class, "decode(...)");
    private static final IOException DECODE_ULE_128_DECOMPRESSION_EXCEPTION = ThrowableUtil.unknownStackTrace(new IOException("HPACK - decompression failure"), Decoder.class, "decodeULE128(...)");
    private static final IOException DECODE_ILLEGAL_INDEX_VALUE = ThrowableUtil.unknownStackTrace(new IOException("HPACK - illegal index value"), Decoder.class, "decode(...)");
    private static final IOException INDEX_HEADER_ILLEGAL_INDEX_VALUE = ThrowableUtil.unknownStackTrace(new IOException("HPACK - illegal index value"), Decoder.class, "indexHeader(...)");
    private static final IOException READ_NAME_ILLEGAL_INDEX_VALUE = ThrowableUtil.unknownStackTrace(new IOException("HPACK - illegal index value"), Decoder.class, "readName(...)");
    private static final IOException INVALID_MAX_DYNAMIC_TABLE_SIZE = ThrowableUtil.unknownStackTrace(new IOException("HPACK - invalid max dynamic table size"), Decoder.class, "setDynamicTableSize(...)");
    private static final IOException MAX_DYNAMIC_TABLE_SIZE_CHANGE_REQUIRED = ThrowableUtil.unknownStackTrace(new IOException("HPACK - max dynamic table size change required"), Decoder.class, "decode(...)");
    private final DynamicTable dynamicTable;
    private final HuffmanDecoder huffmanDecoder;
    private final int maxHeaderSize;
    private int maxDynamicTableSize;
    private int encoderMaxDynamicTableSize;
    private boolean maxDynamicTableSizeChangeRequired;
    private long headerSize;
    private State state;
    private HpackUtil.IndexType indexType;
    private int index;
    private boolean huffmanEncoded;
    private int skipLength;
    private int nameLength;
    private int valueLength;
    private CharSequence name;

    public Decoder(int maxHeaderSize, int maxHeaderTableSize, int initialHuffmanDecodeCapacity) {
        this.dynamicTable = new DynamicTable(maxHeaderTableSize);
        this.maxHeaderSize = maxHeaderSize;
        this.maxDynamicTableSize = maxHeaderTableSize;
        this.encoderMaxDynamicTableSize = maxHeaderTableSize;
        this.maxDynamicTableSizeChangeRequired = false;
        this.huffmanDecoder = new HuffmanDecoder(initialHuffmanDecodeCapacity);
        this.reset();
    }

    private void reset() {
        this.headerSize = 0L;
        this.state = State.READ_HEADER_REPRESENTATION;
        this.indexType = HpackUtil.IndexType.NONE;
    }

    public void decode(ByteBuf in, Http2Headers headers) throws IOException {
        block14: while (in.isReadable()) {
            switch (this.state) {
                case READ_HEADER_REPRESENTATION: {
                    byte b = in.readByte();
                    if (this.maxDynamicTableSizeChangeRequired && (b & 0xE0) != 32) {
                        throw MAX_DYNAMIC_TABLE_SIZE_CHANGE_REQUIRED;
                    }
                    if (b < 0) {
                        this.index = b & 0x7F;
                        if (this.index == 0) {
                            throw DECODE_ILLEGAL_INDEX_VALUE;
                        }
                        if (this.index == 127) {
                            this.state = State.READ_INDEXED_HEADER;
                            continue block14;
                        }
                        this.indexHeader(this.index, headers);
                        continue block14;
                    }
                    if ((b & 0x40) == 64) {
                        this.indexType = HpackUtil.IndexType.INCREMENTAL;
                        this.index = b & 0x3F;
                        if (this.index == 0) {
                            this.state = State.READ_LITERAL_HEADER_NAME_LENGTH_PREFIX;
                            continue block14;
                        }
                        if (this.index == 63) {
                            this.state = State.READ_INDEXED_HEADER_NAME;
                            continue block14;
                        }
                        this.readName(this.index);
                        this.state = State.READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX;
                        continue block14;
                    }
                    if ((b & 0x20) == 32) {
                        this.index = b & 0x1F;
                        if (this.index == 31) {
                            this.state = State.READ_MAX_DYNAMIC_TABLE_SIZE;
                            continue block14;
                        }
                        this.setDynamicTableSize(this.index);
                        this.state = State.READ_HEADER_REPRESENTATION;
                        continue block14;
                    }
                    this.indexType = (b & 0x10) == 16 ? HpackUtil.IndexType.NEVER : HpackUtil.IndexType.NONE;
                    this.index = b & 0xF;
                    if (this.index == 0) {
                        this.state = State.READ_LITERAL_HEADER_NAME_LENGTH_PREFIX;
                        continue block14;
                    }
                    if (this.index == 15) {
                        this.state = State.READ_INDEXED_HEADER_NAME;
                        continue block14;
                    }
                    this.readName(this.index);
                    this.state = State.READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX;
                    continue block14;
                }
                case READ_MAX_DYNAMIC_TABLE_SIZE: {
                    int maxSize = Decoder.decodeULE128(in);
                    if (maxSize == -1) {
                        return;
                    }
                    if (maxSize > Integer.MAX_VALUE - this.index) {
                        throw DECODE_DECOMPRESSION_EXCEPTION;
                    }
                    this.setDynamicTableSize(this.index + maxSize);
                    this.state = State.READ_HEADER_REPRESENTATION;
                    continue block14;
                }
                case READ_INDEXED_HEADER: {
                    int headerIndex = Decoder.decodeULE128(in);
                    if (headerIndex == -1) {
                        return;
                    }
                    if (headerIndex > Integer.MAX_VALUE - this.index) {
                        throw DECODE_DECOMPRESSION_EXCEPTION;
                    }
                    this.indexHeader(this.index + headerIndex, headers);
                    this.state = State.READ_HEADER_REPRESENTATION;
                    continue block14;
                }
                case READ_INDEXED_HEADER_NAME: {
                    int nameIndex = Decoder.decodeULE128(in);
                    if (nameIndex == -1) {
                        return;
                    }
                    if (nameIndex > Integer.MAX_VALUE - this.index) {
                        throw DECODE_DECOMPRESSION_EXCEPTION;
                    }
                    this.readName(this.index + nameIndex);
                    this.state = State.READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX;
                    continue block14;
                }
                case READ_LITERAL_HEADER_NAME_LENGTH_PREFIX: {
                    byte b = in.readByte();
                    this.huffmanEncoded = (b & 0x80) == 128;
                    this.index = b & 0x7F;
                    if (this.index == 127) {
                        this.state = State.READ_LITERAL_HEADER_NAME_LENGTH;
                        continue block14;
                    }
                    this.nameLength = this.index;
                    if (this.exceedsMaxHeaderSize(this.nameLength)) {
                        if (this.indexType == HpackUtil.IndexType.NONE) {
                            this.name = AsciiString.EMPTY_STRING;
                            this.skipLength = this.nameLength;
                            this.state = State.SKIP_LITERAL_HEADER_NAME;
                            continue block14;
                        }
                        if (this.nameLength + 32 > this.dynamicTable.capacity()) {
                            this.dynamicTable.clear();
                            this.name = AsciiString.EMPTY_STRING;
                            this.skipLength = this.nameLength;
                            this.state = State.SKIP_LITERAL_HEADER_NAME;
                            continue block14;
                        }
                    }
                    this.state = State.READ_LITERAL_HEADER_NAME;
                    continue block14;
                }
                case READ_LITERAL_HEADER_NAME_LENGTH: {
                    this.nameLength = Decoder.decodeULE128(in);
                    if (this.nameLength == -1) {
                        return;
                    }
                    if (this.nameLength > Integer.MAX_VALUE - this.index) {
                        throw DECODE_DECOMPRESSION_EXCEPTION;
                    }
                    this.nameLength += this.index;
                    if (this.exceedsMaxHeaderSize(this.nameLength)) {
                        if (this.indexType == HpackUtil.IndexType.NONE) {
                            this.name = AsciiString.EMPTY_STRING;
                            this.skipLength = this.nameLength;
                            this.state = State.SKIP_LITERAL_HEADER_NAME;
                            continue block14;
                        }
                        if (this.nameLength + 32 > this.dynamicTable.capacity()) {
                            this.dynamicTable.clear();
                            this.name = AsciiString.EMPTY_STRING;
                            this.skipLength = this.nameLength;
                            this.state = State.SKIP_LITERAL_HEADER_NAME;
                            continue block14;
                        }
                    }
                    this.state = State.READ_LITERAL_HEADER_NAME;
                    continue block14;
                }
                case READ_LITERAL_HEADER_NAME: {
                    if (in.readableBytes() < this.nameLength) {
                        return;
                    }
                    this.name = this.readStringLiteral(in, this.nameLength);
                    this.state = State.READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX;
                    continue block14;
                }
                case SKIP_LITERAL_HEADER_NAME: {
                    int skip = Math.min(in.readableBytes(), this.skipLength);
                    in.skipBytes(skip);
                    this.skipLength -= skip;
                    if (this.skipLength != 0) continue block14;
                    this.state = State.READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX;
                    continue block14;
                }
                case READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX: {
                    byte b = in.readByte();
                    this.huffmanEncoded = (b & 0x80) == 128;
                    this.index = b & 0x7F;
                    if (this.index == 127) {
                        this.state = State.READ_LITERAL_HEADER_VALUE_LENGTH;
                        continue block14;
                    }
                    this.valueLength = this.index;
                    long newHeaderSize = (long)this.nameLength + (long)this.valueLength;
                    if (this.exceedsMaxHeaderSize(newHeaderSize)) {
                        this.headerSize = this.maxHeaderSize + 1;
                        if (this.indexType == HpackUtil.IndexType.NONE) {
                            this.state = State.SKIP_LITERAL_HEADER_VALUE;
                            continue block14;
                        }
                        if (newHeaderSize + 32L > (long)this.dynamicTable.capacity()) {
                            this.dynamicTable.clear();
                            this.state = State.SKIP_LITERAL_HEADER_VALUE;
                            continue block14;
                        }
                    }
                    if (this.valueLength == 0) {
                        this.insertHeader(headers, this.name, AsciiString.EMPTY_STRING, this.indexType);
                        this.state = State.READ_HEADER_REPRESENTATION;
                        continue block14;
                    }
                    this.state = State.READ_LITERAL_HEADER_VALUE;
                    continue block14;
                }
                case READ_LITERAL_HEADER_VALUE_LENGTH: {
                    this.valueLength = Decoder.decodeULE128(in);
                    if (this.valueLength == -1) {
                        return;
                    }
                    if (this.valueLength > Integer.MAX_VALUE - this.index) {
                        throw DECODE_DECOMPRESSION_EXCEPTION;
                    }
                    this.valueLength += this.index;
                    long newHeaderSize = (long)this.nameLength + (long)this.valueLength;
                    if (newHeaderSize + this.headerSize > (long)this.maxHeaderSize) {
                        this.headerSize = this.maxHeaderSize + 1;
                        if (this.indexType == HpackUtil.IndexType.NONE) {
                            this.state = State.SKIP_LITERAL_HEADER_VALUE;
                            continue block14;
                        }
                        if (newHeaderSize + 32L > (long)this.dynamicTable.capacity()) {
                            this.dynamicTable.clear();
                            this.state = State.SKIP_LITERAL_HEADER_VALUE;
                            continue block14;
                        }
                    }
                    this.state = State.READ_LITERAL_HEADER_VALUE;
                    continue block14;
                }
                case READ_LITERAL_HEADER_VALUE: {
                    if (in.readableBytes() < this.valueLength) {
                        return;
                    }
                    CharSequence value = this.readStringLiteral(in, this.valueLength);
                    this.insertHeader(headers, this.name, value, this.indexType);
                    this.state = State.READ_HEADER_REPRESENTATION;
                    continue block14;
                }
                case SKIP_LITERAL_HEADER_VALUE: {
                    int skipBytes = Math.min(in.readableBytes(), this.valueLength);
                    in.skipBytes(skipBytes);
                    this.valueLength -= skipBytes;
                    if (this.valueLength != 0) continue block14;
                    this.state = State.READ_HEADER_REPRESENTATION;
                    continue block14;
                }
            }
            throw new IllegalStateException("should not reach here");
        }
    }

    public boolean endHeaderBlock() {
        boolean truncated = this.headerSize > (long)this.maxHeaderSize;
        this.reset();
        return truncated;
    }

    public void setMaxHeaderTableSize(int maxHeaderTableSize) {
        this.maxDynamicTableSize = maxHeaderTableSize;
        if (this.maxDynamicTableSize < this.encoderMaxDynamicTableSize) {
            this.maxDynamicTableSizeChangeRequired = true;
            this.dynamicTable.setCapacity(this.maxDynamicTableSize);
        }
    }

    public int getMaxHeaderTableSize() {
        return this.dynamicTable.capacity();
    }

    int length() {
        return this.dynamicTable.length();
    }

    int size() {
        return this.dynamicTable.size();
    }

    HeaderField getHeaderField(int index) {
        return this.dynamicTable.getEntry(index + 1);
    }

    private void setDynamicTableSize(int dynamicTableSize) throws IOException {
        if (dynamicTableSize > this.maxDynamicTableSize) {
            throw INVALID_MAX_DYNAMIC_TABLE_SIZE;
        }
        this.encoderMaxDynamicTableSize = dynamicTableSize;
        this.maxDynamicTableSizeChangeRequired = false;
        this.dynamicTable.setCapacity(dynamicTableSize);
    }

    private void readName(int index) throws IOException {
        if (index <= StaticTable.length) {
            HeaderField headerField = StaticTable.getEntry(index);
            this.name = headerField.name;
        } else if (index - StaticTable.length <= this.dynamicTable.length()) {
            HeaderField headerField = this.dynamicTable.getEntry(index - StaticTable.length);
            this.name = headerField.name;
        } else {
            throw READ_NAME_ILLEGAL_INDEX_VALUE;
        }
    }

    private void indexHeader(int index, Http2Headers headers) throws IOException {
        if (index <= StaticTable.length) {
            HeaderField headerField = StaticTable.getEntry(index);
            this.addHeader(headers, headerField.name, headerField.value);
        } else if (index - StaticTable.length <= this.dynamicTable.length()) {
            HeaderField headerField = this.dynamicTable.getEntry(index - StaticTable.length);
            this.addHeader(headers, headerField.name, headerField.value);
        } else {
            throw INDEX_HEADER_ILLEGAL_INDEX_VALUE;
        }
    }

    private void insertHeader(Http2Headers headers, CharSequence name, CharSequence value, HpackUtil.IndexType indexType) {
        this.addHeader(headers, name, value);
        switch (indexType) {
            case NONE: 
            case NEVER: {
                break;
            }
            case INCREMENTAL: {
                this.dynamicTable.add(new HeaderField(name, value));
                break;
            }
            default: {
                throw new IllegalStateException("should not reach here");
            }
        }
    }

    private void addHeader(Http2Headers headers, CharSequence name, CharSequence value) {
        long newSize = this.headerSize + (long)name.length() + (long)value.length();
        if (newSize <= (long)this.maxHeaderSize) {
            headers.add(name, value);
            this.headerSize = (int)newSize;
        } else {
            this.headerSize = this.maxHeaderSize + 1;
        }
    }

    private boolean exceedsMaxHeaderSize(long size) {
        if (size + this.headerSize <= (long)this.maxHeaderSize) {
            return false;
        }
        this.headerSize = this.maxHeaderSize + 1;
        return true;
    }

    private CharSequence readStringLiteral(ByteBuf in, int length) throws IOException {
        if (this.huffmanEncoded) {
            return this.huffmanDecoder.decode(in, length);
        }
        byte[] buf = new byte[length];
        in.readBytes(buf);
        return new AsciiString(buf, false);
    }

    private static int decodeULE128(ByteBuf in) throws IOException {
        in.markReaderIndex();
        int result = 0;
        for (int shift = 0; shift < 32; shift += 7) {
            if (!in.isReadable()) {
                in.resetReaderIndex();
                return -1;
            }
            byte b = in.readByte();
            if (shift == 28 && (b & 0xF8) != 0) break;
            result |= (b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        in.resetReaderIndex();
        throw DECODE_ULE_128_DECOMPRESSION_EXCEPTION;
    }

    private static enum State {
        READ_HEADER_REPRESENTATION,
        READ_MAX_DYNAMIC_TABLE_SIZE,
        READ_INDEXED_HEADER,
        READ_INDEXED_HEADER_NAME,
        READ_LITERAL_HEADER_NAME_LENGTH_PREFIX,
        READ_LITERAL_HEADER_NAME_LENGTH,
        READ_LITERAL_HEADER_NAME,
        SKIP_LITERAL_HEADER_NAME,
        READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX,
        READ_LITERAL_HEADER_VALUE_LENGTH,
        READ_LITERAL_HEADER_VALUE,
        SKIP_LITERAL_HEADER_VALUE;

    }
}

