/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http2.DefaultHttp2HeaderTableListSize;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2HeaderTable;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersDecoder;
import io.netty.handler.codec.http2.internal.hpack.Decoder;
import java.io.IOException;

public class DefaultHttp2HeadersDecoder
implements Http2HeadersDecoder,
Http2HeadersDecoder.Configuration {
    private static final float HEADERS_COUNT_WEIGHT_NEW = 0.2f;
    private static final float HEADERS_COUNT_WEIGHT_HISTORICAL = 0.8f;
    private final int maxHeaderSize;
    private final Decoder decoder;
    private final Http2HeaderTable headerTable;
    private final boolean validateHeaders;
    private float headerArraySizeAccumulator = 8.0f;

    public DefaultHttp2HeadersDecoder() {
        this(true);
    }

    public DefaultHttp2HeadersDecoder(boolean validateHeaders) {
        this(8192, 4096, validateHeaders, 32);
    }

    public DefaultHttp2HeadersDecoder(int maxHeaderSize, int maxHeaderTableSize, boolean validateHeaders, int initialHuffmanDecodeCapacity) {
        if (maxHeaderSize <= 0) {
            throw new IllegalArgumentException("maxHeaderSize must be positive: " + maxHeaderSize);
        }
        this.decoder = new Decoder(maxHeaderSize, maxHeaderTableSize, initialHuffmanDecodeCapacity);
        this.headerTable = new Http2HeaderTableDecoder();
        this.maxHeaderSize = maxHeaderSize;
        this.validateHeaders = validateHeaders;
    }

    @Override
    public Http2HeaderTable headerTable() {
        return this.headerTable;
    }

    @Override
    public int maxHeaderSize() {
        return this.maxHeaderSize;
    }

    @Override
    public Http2HeadersDecoder.Configuration configuration() {
        return this;
    }

    protected void maxHeaderSizeExceeded() throws Http2Exception {
        throw Http2Exception.connectionError(Http2Error.ENHANCE_YOUR_CALM, "Header size exceeded max allowed bytes (%d)", this.maxHeaderSize);
    }

    @Override
    public Http2Headers decodeHeaders(ByteBuf headerBlock) throws Http2Exception {
        try {
            DefaultHttp2Headers headers = new DefaultHttp2Headers(this.validateHeaders, (int)this.headerArraySizeAccumulator);
            this.decoder.decode(headerBlock, headers);
            if (this.decoder.endHeaderBlock()) {
                this.maxHeaderSizeExceeded();
            }
            if (headers.size() > this.headerTable.maxHeaderListSize()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Number of headers (%d) exceeds maxHeaderListSize (%d)", headers.size(), this.headerTable.maxHeaderListSize());
            }
            this.headerArraySizeAccumulator = 0.2f * (float)headers.size() + 0.8f * this.headerArraySizeAccumulator;
            return headers;
        }
        catch (IOException e) {
            throw Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, e, e.getMessage(), new Object[0]);
        }
        catch (Http2Exception e) {
            throw e;
        }
        catch (Throwable e) {
            throw Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, e, e.getMessage(), new Object[0]);
        }
    }

    private final class Http2HeaderTableDecoder
    extends DefaultHttp2HeaderTableListSize
    implements Http2HeaderTable {
        private Http2HeaderTableDecoder() {
        }

        @Override
        public void maxHeaderTableSize(int max) throws Http2Exception {
            if (max < 0) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Header Table Size must be non-negative but was %d", max);
            }
            try {
                DefaultHttp2HeadersDecoder.this.decoder.setMaxHeaderTableSize(max);
            }
            catch (Throwable t) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, t.getMessage(), t);
            }
        }

        @Override
        public int maxHeaderTableSize() {
            return DefaultHttp2HeadersDecoder.this.decoder.getMaxHeaderTableSize();
        }
    }
}

