/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.provider.util;

import io.mybatis.provider.util.AssertException;
import io.mybatis.provider.util.Utils;
import java.util.Collection;

public class Assert {
    public static void isTrue(boolean expression, String message) {
        if (!expression) {
            throw new AssertException(message);
        }
    }

    public static void isFalse(boolean expression, String message) {
        if (expression) {
            throw new AssertException(message);
        }
    }

    public static void isNull(Object object, String message) {
        if (object != null) {
            throw new AssertException(message);
        }
    }

    public static void notNull(Object object, String message) {
        if (object == null) {
            throw new AssertException(message);
        }
    }

    public static <T extends CharSequence> void isEmpty(T text, String message) {
        if (Utils.isNotEmpty(text)) {
            throw new AssertException(message);
        }
    }

    public static <T extends CharSequence> void notEmpty(T text, String message) {
        if (Utils.isEmpty(text)) {
            throw new AssertException(message);
        }
    }

    public static <T extends CharSequence> void isBlank(T text, String message) {
        if (Utils.isNotBlank(text)) {
            throw new AssertException(message);
        }
    }

    public static <T extends CharSequence> void notBlank(T text, String message) {
        if (Utils.isBlank(text)) {
            throw new AssertException(message);
        }
    }

    public static <T> void isEmpty(T[] array, String message) {
        if (Utils.isNotEmpty(array)) {
            throw new AssertException(message);
        }
    }

    public static <T> void notEmpty(T[] array, String message) {
        if (Utils.isEmpty(array)) {
            throw new AssertException(message);
        }
    }

    public static <T> void isEmpty(Collection<T> collection, String message) {
        if (Utils.isNotEmpty(collection)) {
            throw new AssertException(message);
        }
    }

    public static <T> void notEmpty(Collection<T> collection, String message) {
        if (Utils.isEmpty(collection)) {
            throw new AssertException(message);
        }
    }
}

