/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.provider.keysql;

import io.mybatis.provider.Caching;
import io.mybatis.provider.EntityColumn;
import io.mybatis.provider.EntityTable;
import io.mybatis.provider.MsCustomize;
import io.mybatis.provider.keysql.GenId;
import io.mybatis.provider.keysql.GenIdKeyGenerator;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Options;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.builder.annotation.ProviderContext;
import org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.executor.keygen.SelectKeyGenerator;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMap;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.mapping.StatementType;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.Configuration;

public class KeySqlMsCustomize
implements MsCustomize {
    public static final Log log = LogFactory.getLog(KeySqlMsCustomize.class);

    @Override
    public void customize(EntityTable entity, MappedStatement ms, ProviderContext context) {
        Method mapperMethod = context.getMapperMethod();
        if (mapperMethod.isAnnotationPresent(InsertProvider.class)) {
            Options options;
            List ids = entity.idColumns().stream().filter(EntityColumn::hasPrimaryKeyStrategy).collect(Collectors.toList());
            if (ids.size() > 1) {
                throw new RuntimeException("\u53ea\u80fd\u6709\u4e00\u4e2a\u5b57\u6bb5\u914d\u7f6e\u4e3b\u952e\u7b56\u7565");
            }
            if (ids.size() < 1) {
                return;
            }
            if (mapperMethod.isAnnotationPresent(Options.class) && (options = mapperMethod.getAnnotation(Options.class)).useGeneratedKeys()) {
                log.warn("\u63a5\u53e3 " + context.getMapperType().getName() + " \u65b9\u6cd5 " + mapperMethod.getName() + " \u4f7f\u7528\u4e86 @Options(useGeneratedKeys = true)\uff0c\u5ffd\u7565\u5b9e\u4f53\u4e0a\u7684\u4e3b\u952e\u7b56\u7565");
                return;
            }
            if (mapperMethod.isAnnotationPresent(SelectKey.class)) {
                log.warn("\u63a5\u53e3 " + context.getMapperType().getName() + " \u65b9\u6cd5 " + mapperMethod.getName() + " \u4f7f\u7528\u4e86 @SelectKey\uff0c\u5ffd\u7565\u5b9e\u4f53\u4e0a\u7684\u4e3b\u952e\u7b56\u7565");
                return;
            }
            EntityColumn id = (EntityColumn)ids.get(0);
            if (id.useGeneratedKeys()) {
                MetaObject metaObject = ms.getConfiguration().newMetaObject((Object)ms);
                metaObject.setValue("keyGenerator", (Object)Jdbc3KeyGenerator.INSTANCE);
                metaObject.setValue("keyProperties", (Object)new String[]{id.property()});
            } else if (id.afterSql() != null && !id.afterSql().isEmpty()) {
                KeyGenerator keyGenerator = this.handleSelectKeyGenerator(ms, id, id.afterSql(), false);
                MetaObject metaObject = ms.getConfiguration().newMetaObject((Object)ms);
                metaObject.setValue("keyGenerator", (Object)keyGenerator);
                metaObject.setValue("keyProperties", (Object)new String[]{id.property()});
            } else if (id.genId() != null && id.genId() != GenId.NULL.class) {
                Class<? extends GenId> genIdClass = id.genId();
                boolean executeBefore = id.genIdExecuteBefore();
                GenId genId = null;
                try {
                    genId = genIdClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                GenIdKeyGenerator keyGenerator = new GenIdKeyGenerator(genId, entity, id, ms.getConfiguration(), executeBefore);
                MetaObject metaObject = ms.getConfiguration().newMetaObject((Object)ms);
                metaObject.setValue("keyGenerator", (Object)keyGenerator);
                metaObject.setValue("keyProperties", (Object)new String[]{id.property()});
            }
        }
    }

    private KeyGenerator handleSelectKeyGenerator(MappedStatement ms, EntityColumn column, String sql, boolean executeBefore) {
        String id = ms.getId() + "!selectKey";
        Configuration configuration = ms.getConfiguration();
        LanguageDriver languageDriver = configuration.getLanguageDriver(Caching.class);
        SqlSource sqlSource = languageDriver.createSqlSource(configuration, sql, ms.getParameterMap().getType());
        MappedStatement.Builder statementBuilder = new MappedStatement.Builder(configuration, id, sqlSource, SqlCommandType.SELECT).resource(ms.getResource()).fetchSize(null).timeout(null).statementType(StatementType.PREPARED).keyGenerator((KeyGenerator)NoKeyGenerator.INSTANCE).keyProperty(column.property()).keyColumn(column.column()).databaseId(null).lang(languageDriver).resultOrdered(false).resultSets(null).resultMaps(this.getStatementResultMaps(ms, column.javaType(), id)).resultSetType(null).flushCacheRequired(false).useCache(false).cache(null);
        ParameterMap statementParameterMap = this.getStatementParameterMap(ms, ms.getParameterMap().getType(), id);
        if (statementParameterMap != null) {
            statementBuilder.parameterMap(statementParameterMap);
        }
        MappedStatement statement = statementBuilder.build();
        configuration.addMappedStatement(statement);
        SelectKeyGenerator keyGenerator = new SelectKeyGenerator(statement, executeBefore);
        configuration.addKeyGenerator(id, (KeyGenerator)keyGenerator);
        return keyGenerator;
    }

    private ParameterMap getStatementParameterMap(MappedStatement ms, Class<?> parameterTypeClass, String statementId) {
        ArrayList parameterMappings = new ArrayList();
        ParameterMap parameterMap = new ParameterMap.Builder(ms.getConfiguration(), statementId + "-Inline", parameterTypeClass, parameterMappings).build();
        return parameterMap;
    }

    private List<ResultMap> getStatementResultMaps(MappedStatement ms, Class<?> resultType, String statementId) {
        ArrayList<ResultMap> resultMaps = new ArrayList<ResultMap>();
        ResultMap inlineResultMap = new ResultMap.Builder(ms.getConfiguration(), statementId + "-Inline", resultType, new ArrayList(), null).build();
        resultMaps.add(inlineResultMap);
        return resultMaps;
    }
}

