/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.provider.defaults;

import io.mybatis.provider.EntityTable;
import io.mybatis.provider.EntityTableFactory;
import java.util.List;

public class DefaultEntityTableFactoryChain
implements EntityTableFactory.Chain {
    private final List<EntityTableFactory> factories;
    private final DefaultEntityTableFactoryChain next;
    private final int index;

    public DefaultEntityTableFactoryChain(List<EntityTableFactory> factories) {
        this(factories, 0);
    }

    private DefaultEntityTableFactoryChain(List<EntityTableFactory> factories, int index) {
        this.factories = factories;
        this.index = index;
        this.next = this.index < this.factories.size() ? new DefaultEntityTableFactoryChain(factories, this.index + 1) : null;
    }

    @Override
    public EntityTable createEntityTable(Class<?> entityClass) {
        if (this.index < this.factories.size()) {
            return this.factories.get(this.index).createEntityTable(entityClass, this.next);
        }
        return null;
    }
}

