/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.provider.defaults;

import io.mybatis.provider.Entity;
import io.mybatis.provider.EntityColumn;
import io.mybatis.provider.EntityColumnFactory;
import io.mybatis.provider.EntityField;
import io.mybatis.provider.EntityTable;
import io.mybatis.provider.Style;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.ibatis.type.JdbcType;

public class DefaultEntityColumnFactory
implements EntityColumnFactory {
    @Override
    public Optional<List<EntityColumn>> createEntityColumn(EntityTable entityTable, EntityField field, EntityColumnFactory.Chain chain) {
        if (field.isAnnotationPresent(Entity.Column.class)) {
            Entity.Column column = field.getAnnotation(Entity.Column.class);
            EntityColumn entityColumn = EntityColumn.of(field).column(column.value().isEmpty() ? Style.getStyle(entityTable.style()).columnName(entityTable, field) : column.value()).id(column.id()).nullable(column.nullable()).useGeneratedKeys(column.useGeneratedKeys()).afterSql(column.afterSql()).genId(column.genId()).genIdExecuteBefore(column.genIdExecuteBefore()).orderBy(column.orderBy()).orderByPriority(column.orderByPriority()).selectable(column.selectable()).insertable(column.insertable()).updatable(column.updatable()).jdbcType(column.jdbcType()).typeHandler(column.typeHandler()).numericScale(column.numericScale());
            for (Entity.Prop prop : column.props()) {
                entityColumn.setProp(prop);
            }
            return Optional.of(Arrays.asList(entityColumn));
        }
        if (field.isAnnotationPresent(Entity.Transient.class)) {
            return IGNORE;
        }
        return Optional.of(Arrays.asList(EntityColumn.of(field).column(Style.getStyle(entityTable.style()).columnName(entityTable, field)).numericScale("").jdbcType(JdbcType.UNDEFINED)));
    }
}

