/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.provider;

import io.mybatis.config.ConfigHelper;
import io.mybatis.provider.EntityField;
import io.mybatis.provider.EntityTable;
import io.mybatis.provider.util.ServiceLoaderUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface Style {
    public static final String DEFAULT_STYLE_KEY = "mybatis.provider.style";
    public static final String NORMAL = "normal";
    public static final String LOWER_UNDERSCORE = "lower_underscore";
    public static final String LOWER = "lower";
    public static final String UPPER = "upper";
    public static final String UPPER_UNDERSCORE = "upper_underscore";
    public static final Map<String, Style> styleMap = new HashMap(){
        {
            List<Style> instances = ServiceLoaderUtil.getInstances(Style.class);
            for (Style instance : instances) {
                this.put(instance.getStyle(), instance);
            }
        }
    };

    public static Style getDefaultStyle() {
        return Style.getStyle(null);
    }

    public static Style getStyle(String style) {
        if (style == null || style.isEmpty()) {
            style = ConfigHelper.getStr((String)DEFAULT_STYLE_KEY);
        }
        if (styleMap.containsKey(style)) {
            return styleMap.get(style);
        }
        throw new IllegalArgumentException("illegal style\uff1a" + style);
    }

    public String getStyle();

    public String tableName(Class<?> var1);

    public String columnName(EntityTable var1, EntityField var2);
}

