/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.provider;

import io.mybatis.provider.EntityClassFinder;
import io.mybatis.provider.EntityColumn;
import io.mybatis.provider.EntityColumnFactory;
import io.mybatis.provider.EntityField;
import io.mybatis.provider.EntityTable;
import io.mybatis.provider.EntityTableFactory;
import io.mybatis.provider.defaults.DefaultEntityColumnFactoryChain;
import io.mybatis.provider.defaults.DefaultEntityTableFactoryChain;
import io.mybatis.provider.util.ServiceLoaderUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Optional;

public abstract class EntityFactory {
    public static EntityTable create(Class<?> mapperType, Method mapperMethod) {
        Optional<Class<?>> optionalClass = EntityClassFinder.find(mapperType, mapperMethod);
        if (optionalClass.isPresent()) {
            return EntityFactory.create(optionalClass.get());
        }
        throw new RuntimeException("Can't obtain " + (mapperMethod != null ? mapperMethod.getName() + " method" : mapperType.getSimpleName() + " interface") + " corresponding entity class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntityTable create(Class<?> entityClass) {
        EntityTable entityTable = Holder.entityTableFactoryChain.createEntityTable(entityClass);
        if (entityTable == null) {
            throw new NullPointerException("Unable to get " + entityClass.getName() + " entity class information");
        }
        if (!entityTable.ready()) {
            Class<?> clazz = entityClass;
            synchronized (clazz) {
                if (!entityTable.ready()) {
                    Class<?> declaredClass = entityClass;
                    boolean isSuperclass = false;
                    while (declaredClass != null && declaredClass != Object.class) {
                        Object[] declaredFields = declaredClass.getDeclaredFields();
                        if (isSuperclass) {
                            EntityFactory.reverse(declaredFields);
                        }
                        for (Object field : declaredFields) {
                            EntityField entityField;
                            int modifiers = ((Field)field).getModifiers();
                            if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || entityTable.isExcludeField(entityField = new EntityField(entityClass, (Field)field))) continue;
                            Optional<List<EntityColumn>> optionalEntityColumns = Holder.entityColumnFactoryChain.createEntityColumn(entityTable, entityField);
                            optionalEntityColumns.ifPresent(columns -> columns.forEach(entityTable::addColumn));
                        }
                        for (declaredClass = declaredClass.getSuperclass(); entityTable.isExcludeSuperClass(declaredClass) && declaredClass != Object.class; declaredClass = declaredClass.getSuperclass()) {
                        }
                        isSuperclass = true;
                    }
                    entityTable.ready(true);
                }
            }
        }
        return entityTable;
    }

    protected static void reverse(Object[] array) {
        for (int i = 0; i < array.length / 2; ++i) {
            Object temp = array[i];
            array[i] = array[array.length - i - 1];
            array[array.length - i - 1] = temp;
        }
    }

    static class Holder {
        static final EntityTableFactory.Chain entityTableFactoryChain = new DefaultEntityTableFactoryChain(ServiceLoaderUtil.getInstances(EntityTableFactory.class));
        static final EntityColumnFactory.Chain entityColumnFactoryChain = new DefaultEntityColumnFactoryChain(ServiceLoaderUtil.getInstances(EntityColumnFactory.class));

        Holder() {
        }
    }
}

