/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.config.spring;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class SpringEnvUtil
implements EnvironmentAware {
    private static Environment environment;
    private static boolean enabled;

    public static String getStr(String key) {
        return environment != null && enabled ? environment.getProperty(key) : null;
    }

    public void setEnvironment(Environment environment) {
        SpringEnvUtil.environment = environment;
        enabled = (Boolean)environment.getProperty("io.mybatis.config.spring.enabled", Boolean.class, (Object)true);
    }

    public static Map<String, URI> getResource() throws IOException {
        Resource[] resources;
        HashMap<String, URI> fileMap = new HashMap<String, URI>();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        for (Resource resource : resources = resolver.getResources("classpath*:io/mybatis/provider/config/*.properties")) {
            URI uri = resource.getURI();
            String urlString = uri.toString();
            if (!urlString.endsWith(".properties")) continue;
            Path path = Paths.get(uri);
            Path fileName = path.getFileName();
            fileMap.put(fileName.toString(), uri);
        }
        return fileMap;
    }
}

