/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.config;

import io.mybatis.config.Config;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigHelper {
    public static final Logger log = LoggerFactory.getLogger(ConfigHelper.class);
    private static volatile List<Config> CONFIGS;

    public static String getStr(String key) {
        ConfigHelper.init();
        for (Config config : CONFIGS) {
            String value = config.getStr(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static String getStr(String key, String defaultValue) {
        String val = ConfigHelper.getStr(key);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    public static Integer getInt(String key) {
        String val = ConfigHelper.getStr(key);
        return val == null ? null : Integer.valueOf(Integer.parseInt(val));
    }

    public static Integer getInt(String key, Integer defaultValue) {
        Integer val = ConfigHelper.getInt(key);
        return val != null ? val : defaultValue;
    }

    public static boolean getBoolean(String key) {
        return Boolean.valueOf(ConfigHelper.getStr(key));
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String val = ConfigHelper.getStr(key);
        if (val == null) {
            return defaultValue;
        }
        return Boolean.valueOf(val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void init() {
        if (CONFIGS != null) return;
        Class<ConfigHelper> clazz = ConfigHelper.class;
        synchronized (ConfigHelper.class) {
            if (CONFIGS != null) return;
            CONFIGS = new ArrayList<Config>();
            ServiceLoader<Config> serviceLoader = ServiceLoader.load(Config.class);
            for (Config config : serviceLoader) {
                CONFIGS.add(config);
            }
            CONFIGS.sort(Comparator.comparing(Config::getOrder).reversed());
            CONFIGS.forEach(c -> log.debug("\u52a0\u8f7d\u914d\u7f6e\u7c7b: " + c.getClass().getName()));
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void reload() {
        CONFIGS = null;
        ConfigHelper.init();
    }
}

