/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.alias;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import lombok.NonNull;

public class CreateAliasParam {
    private final String collectionName;
    private final String databaseName;
    private final String alias;

    private CreateAliasParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.collectionName = builder.collectionName;
        this.databaseName = builder.databaseName;
        this.alias = builder.alias;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getAlias() {
        return this.alias;
    }

    public String toString() {
        return "CreateAliasParam(collectionName=" + this.getCollectionName() + ", databaseName=" + this.getDatabaseName() + ", alias=" + this.getAlias() + ")";
    }

    public static final class Builder {
        private String collectionName;
        private String databaseName;
        private String alias;

        private Builder() {
        }

        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder withAlias(@NonNull String alias) {
            if (alias == null) {
                throw new NullPointerException("alias is marked non-null but is null");
            }
            this.alias = alias;
            return this;
        }

        public CreateAliasParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            ParamUtils.CheckNullEmptyString(this.alias, "Alias");
            return new CreateAliasParam(this);
        }
    }
}

