/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.grpc;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import io.milvus.grpc.CheckHealthResponseOrBuilder;
import io.milvus.grpc.MilvusProto;
import io.milvus.grpc.QuotaState;
import io.milvus.grpc.Status;
import io.milvus.grpc.StatusOrBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class CheckHealthResponse
extends GeneratedMessageV3
implements CheckHealthResponseOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int STATUS_FIELD_NUMBER = 1;
    private Status status_;
    public static final int ISHEALTHY_FIELD_NUMBER = 2;
    private boolean isHealthy_ = false;
    public static final int REASONS_FIELD_NUMBER = 3;
    private LazyStringArrayList reasons_ = LazyStringArrayList.emptyList();
    public static final int QUOTA_STATES_FIELD_NUMBER = 4;
    private List<Integer> quotaStates_;
    private static final Internal.ListAdapter.Converter<Integer, QuotaState> quotaStates_converter_ = new Internal.ListAdapter.Converter<Integer, QuotaState>(){

        public QuotaState convert(Integer from) {
            QuotaState result = QuotaState.forNumber(from);
            return result == null ? QuotaState.UNRECOGNIZED : result;
        }
    };
    private int quotaStatesMemoizedSerializedSize;
    private byte memoizedIsInitialized = (byte)-1;
    private static final CheckHealthResponse DEFAULT_INSTANCE = new CheckHealthResponse();
    private static final Parser<CheckHealthResponse> PARSER = new AbstractParser<CheckHealthResponse>(){

        public CheckHealthResponse parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = CheckHealthResponse.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private CheckHealthResponse(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private CheckHealthResponse() {
        this.reasons_ = LazyStringArrayList.emptyList();
        this.quotaStates_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new CheckHealthResponse();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return MilvusProto.internal_static_milvus_proto_milvus_CheckHealthResponse_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return MilvusProto.internal_static_milvus_proto_milvus_CheckHealthResponse_fieldAccessorTable.ensureFieldAccessorsInitialized(CheckHealthResponse.class, Builder.class);
    }

    @Override
    public boolean hasStatus() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public Status getStatus() {
        return this.status_ == null ? Status.getDefaultInstance() : this.status_;
    }

    @Override
    public StatusOrBuilder getStatusOrBuilder() {
        return this.status_ == null ? Status.getDefaultInstance() : this.status_;
    }

    @Override
    public boolean getIsHealthy() {
        return this.isHealthy_;
    }

    public ProtocolStringList getReasonsList() {
        return this.reasons_;
    }

    @Override
    public int getReasonsCount() {
        return this.reasons_.size();
    }

    @Override
    public String getReasons(int index) {
        return this.reasons_.get(index);
    }

    @Override
    public ByteString getReasonsBytes(int index) {
        return this.reasons_.getByteString(index);
    }

    @Override
    public List<QuotaState> getQuotaStatesList() {
        return new Internal.ListAdapter(this.quotaStates_, quotaStates_converter_);
    }

    @Override
    public int getQuotaStatesCount() {
        return this.quotaStates_.size();
    }

    @Override
    public QuotaState getQuotaStates(int index) {
        return (QuotaState)((Object)quotaStates_converter_.convert((Object)this.quotaStates_.get(index)));
    }

    @Override
    public List<Integer> getQuotaStatesValueList() {
        return this.quotaStates_;
    }

    @Override
    public int getQuotaStatesValue(int index) {
        return this.quotaStates_.get(index);
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        this.getSerializedSize();
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(1, (MessageLite)this.getStatus());
        }
        if (this.isHealthy_) {
            output.writeBool(2, this.isHealthy_);
        }
        for (i = 0; i < this.reasons_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3, (Object)this.reasons_.getRaw(i));
        }
        if (this.getQuotaStatesList().size() > 0) {
            output.writeUInt32NoTag(34);
            output.writeUInt32NoTag(this.quotaStatesMemoizedSerializedSize);
        }
        for (i = 0; i < this.quotaStates_.size(); ++i) {
            output.writeEnumNoTag(this.quotaStates_.get(i).intValue());
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)this.getStatus());
        }
        if (this.isHealthy_) {
            size += CodedOutputStream.computeBoolSize((int)2, (boolean)this.isHealthy_);
        }
        int dataSize = 0;
        for (i = 0; i < this.reasons_.size(); ++i) {
            dataSize += CheckHealthResponse.computeStringSizeNoTag((Object)this.reasons_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getReasonsList().size();
        dataSize = 0;
        for (i = 0; i < this.quotaStates_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.quotaStates_.get(i));
        }
        size += dataSize;
        if (!this.getQuotaStatesList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.quotaStatesMemoizedSerializedSize = dataSize;
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CheckHealthResponse)) {
            return super.equals(obj);
        }
        CheckHealthResponse other = (CheckHealthResponse)obj;
        if (this.hasStatus() != other.hasStatus()) {
            return false;
        }
        if (this.hasStatus() && !this.getStatus().equals(other.getStatus())) {
            return false;
        }
        if (this.getIsHealthy() != other.getIsHealthy()) {
            return false;
        }
        if (!this.getReasonsList().equals(other.getReasonsList())) {
            return false;
        }
        if (!this.quotaStates_.equals(other.quotaStates_)) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + CheckHealthResponse.getDescriptor().hashCode();
        if (this.hasStatus()) {
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getStatus().hashCode();
        }
        hash = 37 * hash + 2;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getIsHealthy());
        if (this.getReasonsCount() > 0) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getReasonsList().hashCode();
        }
        if (this.getQuotaStatesCount() > 0) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.quotaStates_.hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static CheckHealthResponse parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (CheckHealthResponse)PARSER.parseFrom(data);
    }

    public static CheckHealthResponse parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (CheckHealthResponse)PARSER.parseFrom(data, extensionRegistry);
    }

    public static CheckHealthResponse parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (CheckHealthResponse)PARSER.parseFrom(data);
    }

    public static CheckHealthResponse parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (CheckHealthResponse)PARSER.parseFrom(data, extensionRegistry);
    }

    public static CheckHealthResponse parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (CheckHealthResponse)PARSER.parseFrom(data);
    }

    public static CheckHealthResponse parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (CheckHealthResponse)PARSER.parseFrom(data, extensionRegistry);
    }

    public static CheckHealthResponse parseFrom(InputStream input) throws IOException {
        return (CheckHealthResponse)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static CheckHealthResponse parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (CheckHealthResponse)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static CheckHealthResponse parseDelimitedFrom(InputStream input) throws IOException {
        return (CheckHealthResponse)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static CheckHealthResponse parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (CheckHealthResponse)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static CheckHealthResponse parseFrom(CodedInputStream input) throws IOException {
        return (CheckHealthResponse)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static CheckHealthResponse parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (CheckHealthResponse)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return CheckHealthResponse.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(CheckHealthResponse prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static CheckHealthResponse getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<CheckHealthResponse> parser() {
        return PARSER;
    }

    public Parser<CheckHealthResponse> getParserForType() {
        return PARSER;
    }

    public CheckHealthResponse getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements CheckHealthResponseOrBuilder {
        private int bitField0_;
        private Status status_;
        private SingleFieldBuilderV3<Status, Status.Builder, StatusOrBuilder> statusBuilder_;
        private boolean isHealthy_;
        private LazyStringArrayList reasons_ = LazyStringArrayList.emptyList();
        private List<Integer> quotaStates_ = Collections.emptyList();

        public static final Descriptors.Descriptor getDescriptor() {
            return MilvusProto.internal_static_milvus_proto_milvus_CheckHealthResponse_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return MilvusProto.internal_static_milvus_proto_milvus_CheckHealthResponse_fieldAccessorTable.ensureFieldAccessorsInitialized(CheckHealthResponse.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getStatusFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.status_ = null;
            if (this.statusBuilder_ != null) {
                this.statusBuilder_.dispose();
                this.statusBuilder_ = null;
            }
            this.isHealthy_ = false;
            this.reasons_ = LazyStringArrayList.emptyList();
            this.quotaStates_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFF7;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return MilvusProto.internal_static_milvus_proto_milvus_CheckHealthResponse_descriptor;
        }

        public CheckHealthResponse getDefaultInstanceForType() {
            return CheckHealthResponse.getDefaultInstance();
        }

        public CheckHealthResponse build() {
            CheckHealthResponse result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public CheckHealthResponse buildPartial() {
            CheckHealthResponse result = new CheckHealthResponse(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(CheckHealthResponse result) {
            if ((this.bitField0_ & 8) != 0) {
                this.quotaStates_ = Collections.unmodifiableList(this.quotaStates_);
                this.bitField0_ &= 0xFFFFFFF7;
            }
            result.quotaStates_ = this.quotaStates_;
        }

        private void buildPartial0(CheckHealthResponse result) {
            int from_bitField0_ = this.bitField0_;
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 1) != 0) {
                result.status_ = this.statusBuilder_ == null ? this.status_ : (Status)this.statusBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.isHealthy_ = this.isHealthy_;
            }
            if ((from_bitField0_ & 4) != 0) {
                this.reasons_.makeImmutable();
                result.reasons_ = this.reasons_;
            }
            CheckHealthResponse checkHealthResponse = result;
            checkHealthResponse.bitField0_ = checkHealthResponse.bitField0_ | to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof CheckHealthResponse) {
                return this.mergeFrom((CheckHealthResponse)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(CheckHealthResponse other) {
            if (other == CheckHealthResponse.getDefaultInstance()) {
                return this;
            }
            if (other.hasStatus()) {
                this.mergeStatus(other.getStatus());
            }
            if (other.getIsHealthy()) {
                this.setIsHealthy(other.getIsHealthy());
            }
            if (!other.reasons_.isEmpty()) {
                if (this.reasons_.isEmpty()) {
                    this.reasons_ = other.reasons_;
                    this.bitField0_ |= 4;
                } else {
                    this.ensureReasonsIsMutable();
                    this.reasons_.addAll((Collection)other.reasons_);
                }
                this.onChanged();
            }
            if (!other.quotaStates_.isEmpty()) {
                if (this.quotaStates_.isEmpty()) {
                    this.quotaStates_ = other.quotaStates_;
                    this.bitField0_ &= 0xFFFFFFF7;
                } else {
                    this.ensureQuotaStatesIsMutable();
                    this.quotaStates_.addAll(other.quotaStates_);
                }
                this.onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block13: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block13;
                        }
                        case 10: {
                            input.readMessage((MessageLite.Builder)this.getStatusFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 1;
                            continue block13;
                        }
                        case 16: {
                            this.isHealthy_ = input.readBool();
                            this.bitField0_ |= 2;
                            continue block13;
                        }
                        case 26: {
                            String s = input.readStringRequireUtf8();
                            this.ensureReasonsIsMutable();
                            this.reasons_.add((Object)s);
                            continue block13;
                        }
                        case 32: {
                            int tmpRaw = input.readEnum();
                            this.ensureQuotaStatesIsMutable();
                            this.quotaStates_.add(tmpRaw);
                            continue block13;
                        }
                        case 34: {
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                int tmpRaw = input.readEnum();
                                this.ensureQuotaStatesIsMutable();
                                this.quotaStates_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block13;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public boolean hasStatus() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public Status getStatus() {
            if (this.statusBuilder_ == null) {
                return this.status_ == null ? Status.getDefaultInstance() : this.status_;
            }
            return (Status)this.statusBuilder_.getMessage();
        }

        public Builder setStatus(Status value) {
            if (this.statusBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.status_ = value;
            } else {
                this.statusBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder setStatus(Status.Builder builderForValue) {
            if (this.statusBuilder_ == null) {
                this.status_ = builderForValue.build();
            } else {
                this.statusBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder mergeStatus(Status value) {
            if (this.statusBuilder_ == null) {
                if ((this.bitField0_ & 1) != 0 && this.status_ != null && this.status_ != Status.getDefaultInstance()) {
                    this.getStatusBuilder().mergeFrom(value);
                } else {
                    this.status_ = value;
                }
            } else {
                this.statusBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.status_ != null) {
                this.bitField0_ |= 1;
                this.onChanged();
            }
            return this;
        }

        public Builder clearStatus() {
            this.bitField0_ &= 0xFFFFFFFE;
            this.status_ = null;
            if (this.statusBuilder_ != null) {
                this.statusBuilder_.dispose();
                this.statusBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Status.Builder getStatusBuilder() {
            this.bitField0_ |= 1;
            this.onChanged();
            return (Status.Builder)this.getStatusFieldBuilder().getBuilder();
        }

        @Override
        public StatusOrBuilder getStatusOrBuilder() {
            if (this.statusBuilder_ != null) {
                return (StatusOrBuilder)this.statusBuilder_.getMessageOrBuilder();
            }
            return this.status_ == null ? Status.getDefaultInstance() : this.status_;
        }

        private SingleFieldBuilderV3<Status, Status.Builder, StatusOrBuilder> getStatusFieldBuilder() {
            if (this.statusBuilder_ == null) {
                this.statusBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getStatus(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.status_ = null;
            }
            return this.statusBuilder_;
        }

        @Override
        public boolean getIsHealthy() {
            return this.isHealthy_;
        }

        public Builder setIsHealthy(boolean value) {
            this.isHealthy_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearIsHealthy() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.isHealthy_ = false;
            this.onChanged();
            return this;
        }

        private void ensureReasonsIsMutable() {
            if (!this.reasons_.isModifiable()) {
                this.reasons_ = new LazyStringArrayList((LazyStringList)this.reasons_);
            }
            this.bitField0_ |= 4;
        }

        public ProtocolStringList getReasonsList() {
            this.reasons_.makeImmutable();
            return this.reasons_;
        }

        @Override
        public int getReasonsCount() {
            return this.reasons_.size();
        }

        @Override
        public String getReasons(int index) {
            return this.reasons_.get(index);
        }

        @Override
        public ByteString getReasonsBytes(int index) {
            return this.reasons_.getByteString(index);
        }

        public Builder setReasons(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureReasonsIsMutable();
            this.reasons_.set(index, value);
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder addReasons(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureReasonsIsMutable();
            this.reasons_.add((Object)value);
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder addAllReasons(Iterable<String> values) {
            this.ensureReasonsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.reasons_);
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearReasons() {
            this.reasons_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        public Builder addReasonsBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            CheckHealthResponse.checkByteStringIsUtf8((ByteString)value);
            this.ensureReasonsIsMutable();
            this.reasons_.add(value);
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        private void ensureQuotaStatesIsMutable() {
            if ((this.bitField0_ & 8) == 0) {
                this.quotaStates_ = new ArrayList<Integer>(this.quotaStates_);
                this.bitField0_ |= 8;
            }
        }

        @Override
        public List<QuotaState> getQuotaStatesList() {
            return new Internal.ListAdapter(this.quotaStates_, quotaStates_converter_);
        }

        @Override
        public int getQuotaStatesCount() {
            return this.quotaStates_.size();
        }

        @Override
        public QuotaState getQuotaStates(int index) {
            return (QuotaState)((Object)quotaStates_converter_.convert((Object)this.quotaStates_.get(index)));
        }

        public Builder setQuotaStates(int index, QuotaState value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureQuotaStatesIsMutable();
            this.quotaStates_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addQuotaStates(QuotaState value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureQuotaStatesIsMutable();
            this.quotaStates_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllQuotaStates(Iterable<? extends QuotaState> values) {
            this.ensureQuotaStatesIsMutable();
            for (QuotaState quotaState : values) {
                this.quotaStates_.add(quotaState.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearQuotaStates() {
            this.quotaStates_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getQuotaStatesValueList() {
            return Collections.unmodifiableList(this.quotaStates_);
        }

        @Override
        public int getQuotaStatesValue(int index) {
            return this.quotaStates_.get(index);
        }

        public Builder setQuotaStatesValue(int index, int value) {
            this.ensureQuotaStatesIsMutable();
            this.quotaStates_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addQuotaStatesValue(int value) {
            this.ensureQuotaStatesIsMutable();
            this.quotaStates_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllQuotaStatesValue(Iterable<Integer> values) {
            this.ensureQuotaStatesIsMutable();
            for (int value : values) {
                this.quotaStates_.add(value);
            }
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

