/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.vector.request;

import com.google.common.collect.Lists;
import io.milvus.v2.common.ConsistencyLevel;
import io.milvus.v2.common.IndexParam;
import io.milvus.v2.service.vector.request.data.BaseVector;
import java.util.List;

public class SearchIteratorReq {
    private String databaseName;
    private String collectionName;
    private List<String> partitionNames;
    private IndexParam.MetricType metricType;
    private String vectorFieldName;
    private int topK;
    private String expr;
    private List<String> outputFields;
    private List<BaseVector> vectors;
    private int roundDecimal;
    private String params;
    private ConsistencyLevel consistencyLevel;
    private boolean ignoreGrowing;
    private long batchSize;

    private static List<String> $default$partitionNames() {
        return Lists.newArrayList();
    }

    private static IndexParam.MetricType $default$metricType() {
        return IndexParam.MetricType.INVALID;
    }

    private static int $default$topK() {
        return -1;
    }

    private static String $default$expr() {
        return "";
    }

    private static List<String> $default$outputFields() {
        return Lists.newArrayList();
    }

    private static List<BaseVector> $default$vectors() {
        return Lists.newArrayList();
    }

    private static int $default$roundDecimal() {
        return -1;
    }

    private static String $default$params() {
        return "{}";
    }

    private static ConsistencyLevel $default$consistencyLevel() {
        return ConsistencyLevel.BOUNDED;
    }

    private static boolean $default$ignoreGrowing() {
        return false;
    }

    private static long $default$batchSize() {
        return 1000L;
    }

    protected SearchIteratorReq(SearchIteratorReqBuilder<?, ?> b) {
        this.databaseName = ((SearchIteratorReqBuilder)b).databaseName;
        this.collectionName = ((SearchIteratorReqBuilder)b).collectionName;
        this.partitionNames = ((SearchIteratorReqBuilder)b).partitionNames$set ? ((SearchIteratorReqBuilder)b).partitionNames$value : SearchIteratorReq.$default$partitionNames();
        this.metricType = ((SearchIteratorReqBuilder)b).metricType$set ? ((SearchIteratorReqBuilder)b).metricType$value : SearchIteratorReq.$default$metricType();
        this.vectorFieldName = ((SearchIteratorReqBuilder)b).vectorFieldName;
        this.topK = ((SearchIteratorReqBuilder)b).topK$set ? ((SearchIteratorReqBuilder)b).topK$value : SearchIteratorReq.$default$topK();
        this.expr = ((SearchIteratorReqBuilder)b).expr$set ? ((SearchIteratorReqBuilder)b).expr$value : SearchIteratorReq.$default$expr();
        this.outputFields = ((SearchIteratorReqBuilder)b).outputFields$set ? ((SearchIteratorReqBuilder)b).outputFields$value : SearchIteratorReq.$default$outputFields();
        this.vectors = ((SearchIteratorReqBuilder)b).vectors$set ? ((SearchIteratorReqBuilder)b).vectors$value : SearchIteratorReq.$default$vectors();
        this.roundDecimal = ((SearchIteratorReqBuilder)b).roundDecimal$set ? ((SearchIteratorReqBuilder)b).roundDecimal$value : SearchIteratorReq.$default$roundDecimal();
        this.params = ((SearchIteratorReqBuilder)b).params$set ? ((SearchIteratorReqBuilder)b).params$value : SearchIteratorReq.$default$params();
        this.consistencyLevel = ((SearchIteratorReqBuilder)b).consistencyLevel$set ? ((SearchIteratorReqBuilder)b).consistencyLevel$value : SearchIteratorReq.$default$consistencyLevel();
        this.ignoreGrowing = ((SearchIteratorReqBuilder)b).ignoreGrowing$set ? ((SearchIteratorReqBuilder)b).ignoreGrowing$value : SearchIteratorReq.$default$ignoreGrowing();
        this.batchSize = ((SearchIteratorReqBuilder)b).batchSize$set ? ((SearchIteratorReqBuilder)b).batchSize$value : SearchIteratorReq.$default$batchSize();
    }

    public static SearchIteratorReqBuilder<?, ?> builder() {
        return new SearchIteratorReqBuilderImpl();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public List<String> getPartitionNames() {
        return this.partitionNames;
    }

    public IndexParam.MetricType getMetricType() {
        return this.metricType;
    }

    public String getVectorFieldName() {
        return this.vectorFieldName;
    }

    public int getTopK() {
        return this.topK;
    }

    public String getExpr() {
        return this.expr;
    }

    public List<String> getOutputFields() {
        return this.outputFields;
    }

    public List<BaseVector> getVectors() {
        return this.vectors;
    }

    public int getRoundDecimal() {
        return this.roundDecimal;
    }

    public String getParams() {
        return this.params;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public boolean isIgnoreGrowing() {
        return this.ignoreGrowing;
    }

    public long getBatchSize() {
        return this.batchSize;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public void setPartitionNames(List<String> partitionNames) {
        this.partitionNames = partitionNames;
    }

    public void setMetricType(IndexParam.MetricType metricType) {
        this.metricType = metricType;
    }

    public void setVectorFieldName(String vectorFieldName) {
        this.vectorFieldName = vectorFieldName;
    }

    public void setTopK(int topK) {
        this.topK = topK;
    }

    public void setExpr(String expr) {
        this.expr = expr;
    }

    public void setOutputFields(List<String> outputFields) {
        this.outputFields = outputFields;
    }

    public void setVectors(List<BaseVector> vectors) {
        this.vectors = vectors;
    }

    public void setRoundDecimal(int roundDecimal) {
        this.roundDecimal = roundDecimal;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public void setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
    }

    public void setIgnoreGrowing(boolean ignoreGrowing) {
        this.ignoreGrowing = ignoreGrowing;
    }

    public void setBatchSize(long batchSize) {
        this.batchSize = batchSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchIteratorReq)) {
            return false;
        }
        SearchIteratorReq other = (SearchIteratorReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTopK() != other.getTopK()) {
            return false;
        }
        if (this.getRoundDecimal() != other.getRoundDecimal()) {
            return false;
        }
        if (this.isIgnoreGrowing() != other.isIgnoreGrowing()) {
            return false;
        }
        if (this.getBatchSize() != other.getBatchSize()) {
            return false;
        }
        String this$databaseName = this.getDatabaseName();
        String other$databaseName = other.getDatabaseName();
        if (this$databaseName == null ? other$databaseName != null : !this$databaseName.equals(other$databaseName)) {
            return false;
        }
        String this$collectionName = this.getCollectionName();
        String other$collectionName = other.getCollectionName();
        if (this$collectionName == null ? other$collectionName != null : !this$collectionName.equals(other$collectionName)) {
            return false;
        }
        List<String> this$partitionNames = this.getPartitionNames();
        List<String> other$partitionNames = other.getPartitionNames();
        if (this$partitionNames == null ? other$partitionNames != null : !((Object)this$partitionNames).equals(other$partitionNames)) {
            return false;
        }
        IndexParam.MetricType this$metricType = this.getMetricType();
        IndexParam.MetricType other$metricType = other.getMetricType();
        if (this$metricType == null ? other$metricType != null : !((Object)((Object)this$metricType)).equals((Object)other$metricType)) {
            return false;
        }
        String this$vectorFieldName = this.getVectorFieldName();
        String other$vectorFieldName = other.getVectorFieldName();
        if (this$vectorFieldName == null ? other$vectorFieldName != null : !this$vectorFieldName.equals(other$vectorFieldName)) {
            return false;
        }
        String this$expr = this.getExpr();
        String other$expr = other.getExpr();
        if (this$expr == null ? other$expr != null : !this$expr.equals(other$expr)) {
            return false;
        }
        List<String> this$outputFields = this.getOutputFields();
        List<String> other$outputFields = other.getOutputFields();
        if (this$outputFields == null ? other$outputFields != null : !((Object)this$outputFields).equals(other$outputFields)) {
            return false;
        }
        List<BaseVector> this$vectors = this.getVectors();
        List<BaseVector> other$vectors = other.getVectors();
        if (this$vectors == null ? other$vectors != null : !((Object)this$vectors).equals(other$vectors)) {
            return false;
        }
        String this$params = this.getParams();
        String other$params = other.getParams();
        if (this$params == null ? other$params != null : !this$params.equals(other$params)) {
            return false;
        }
        ConsistencyLevel this$consistencyLevel = this.getConsistencyLevel();
        ConsistencyLevel other$consistencyLevel = other.getConsistencyLevel();
        return !(this$consistencyLevel == null ? other$consistencyLevel != null : !((Object)((Object)this$consistencyLevel)).equals((Object)other$consistencyLevel));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SearchIteratorReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTopK();
        result = result * 59 + this.getRoundDecimal();
        result = result * 59 + (this.isIgnoreGrowing() ? 79 : 97);
        long $batchSize = this.getBatchSize();
        result = result * 59 + (int)($batchSize >>> 32 ^ $batchSize);
        String $databaseName = this.getDatabaseName();
        result = result * 59 + ($databaseName == null ? 43 : $databaseName.hashCode());
        String $collectionName = this.getCollectionName();
        result = result * 59 + ($collectionName == null ? 43 : $collectionName.hashCode());
        List<String> $partitionNames = this.getPartitionNames();
        result = result * 59 + ($partitionNames == null ? 43 : ((Object)$partitionNames).hashCode());
        IndexParam.MetricType $metricType = this.getMetricType();
        result = result * 59 + ($metricType == null ? 43 : ((Object)((Object)$metricType)).hashCode());
        String $vectorFieldName = this.getVectorFieldName();
        result = result * 59 + ($vectorFieldName == null ? 43 : $vectorFieldName.hashCode());
        String $expr = this.getExpr();
        result = result * 59 + ($expr == null ? 43 : $expr.hashCode());
        List<String> $outputFields = this.getOutputFields();
        result = result * 59 + ($outputFields == null ? 43 : ((Object)$outputFields).hashCode());
        List<BaseVector> $vectors = this.getVectors();
        result = result * 59 + ($vectors == null ? 43 : ((Object)$vectors).hashCode());
        String $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : $params.hashCode());
        ConsistencyLevel $consistencyLevel = this.getConsistencyLevel();
        result = result * 59 + ($consistencyLevel == null ? 43 : ((Object)((Object)$consistencyLevel)).hashCode());
        return result;
    }

    public String toString() {
        return "SearchIteratorReq(databaseName=" + this.getDatabaseName() + ", collectionName=" + this.getCollectionName() + ", partitionNames=" + this.getPartitionNames() + ", metricType=" + (Object)((Object)this.getMetricType()) + ", vectorFieldName=" + this.getVectorFieldName() + ", topK=" + this.getTopK() + ", expr=" + this.getExpr() + ", outputFields=" + this.getOutputFields() + ", vectors=" + this.getVectors() + ", roundDecimal=" + this.getRoundDecimal() + ", params=" + this.getParams() + ", consistencyLevel=" + (Object)((Object)this.getConsistencyLevel()) + ", ignoreGrowing=" + this.isIgnoreGrowing() + ", batchSize=" + this.getBatchSize() + ")";
    }

    private static final class SearchIteratorReqBuilderImpl
    extends SearchIteratorReqBuilder<SearchIteratorReq, SearchIteratorReqBuilderImpl> {
        private SearchIteratorReqBuilderImpl() {
        }

        @Override
        protected SearchIteratorReqBuilderImpl self() {
            return this;
        }

        @Override
        public SearchIteratorReq build() {
            return new SearchIteratorReq(this);
        }
    }

    public static abstract class SearchIteratorReqBuilder<C extends SearchIteratorReq, B extends SearchIteratorReqBuilder<C, B>> {
        private String databaseName;
        private String collectionName;
        private boolean partitionNames$set;
        private List<String> partitionNames$value;
        private boolean metricType$set;
        private IndexParam.MetricType metricType$value;
        private String vectorFieldName;
        private boolean topK$set;
        private int topK$value;
        private boolean expr$set;
        private String expr$value;
        private boolean outputFields$set;
        private List<String> outputFields$value;
        private boolean vectors$set;
        private List<BaseVector> vectors$value;
        private boolean roundDecimal$set;
        private int roundDecimal$value;
        private boolean params$set;
        private String params$value;
        private boolean consistencyLevel$set;
        private ConsistencyLevel consistencyLevel$value;
        private boolean ignoreGrowing$set;
        private boolean ignoreGrowing$value;
        private boolean batchSize$set;
        private long batchSize$value;

        protected abstract B self();

        public abstract C build();

        public B databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this.self();
        }

        public B collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this.self();
        }

        public B partitionNames(List<String> partitionNames) {
            this.partitionNames$value = partitionNames;
            this.partitionNames$set = true;
            return this.self();
        }

        public B metricType(IndexParam.MetricType metricType) {
            this.metricType$value = metricType;
            this.metricType$set = true;
            return this.self();
        }

        public B vectorFieldName(String vectorFieldName) {
            this.vectorFieldName = vectorFieldName;
            return this.self();
        }

        public B topK(int topK) {
            this.topK$value = topK;
            this.topK$set = true;
            return this.self();
        }

        public B expr(String expr) {
            this.expr$value = expr;
            this.expr$set = true;
            return this.self();
        }

        public B outputFields(List<String> outputFields) {
            this.outputFields$value = outputFields;
            this.outputFields$set = true;
            return this.self();
        }

        public B vectors(List<BaseVector> vectors) {
            this.vectors$value = vectors;
            this.vectors$set = true;
            return this.self();
        }

        public B roundDecimal(int roundDecimal) {
            this.roundDecimal$value = roundDecimal;
            this.roundDecimal$set = true;
            return this.self();
        }

        public B params(String params) {
            this.params$value = params;
            this.params$set = true;
            return this.self();
        }

        public B consistencyLevel(ConsistencyLevel consistencyLevel) {
            this.consistencyLevel$value = consistencyLevel;
            this.consistencyLevel$set = true;
            return this.self();
        }

        public B ignoreGrowing(boolean ignoreGrowing) {
            this.ignoreGrowing$value = ignoreGrowing;
            this.ignoreGrowing$set = true;
            return this.self();
        }

        public B batchSize(long batchSize) {
            this.batchSize$value = batchSize;
            this.batchSize$set = true;
            return this.self();
        }

        public String toString() {
            return "SearchIteratorReq.SearchIteratorReqBuilder(databaseName=" + this.databaseName + ", collectionName=" + this.collectionName + ", partitionNames$value=" + this.partitionNames$value + ", metricType$value=" + (Object)((Object)this.metricType$value) + ", vectorFieldName=" + this.vectorFieldName + ", topK$value=" + this.topK$value + ", expr$value=" + this.expr$value + ", outputFields$value=" + this.outputFields$value + ", vectors$value=" + this.vectors$value + ", roundDecimal$value=" + this.roundDecimal$value + ", params$value=" + this.params$value + ", consistencyLevel$value=" + (Object)((Object)this.consistencyLevel$value) + ", ignoreGrowing$value=" + this.ignoreGrowing$value + ", batchSize$value=" + this.batchSize$value + ")";
        }
    }
}

