/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.bulkwriter;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import io.milvus.bulkwriter.common.clientenum.BulkFileType;
import io.milvus.bulkwriter.common.utils.ParquetUtils;
import io.milvus.common.utils.ExceptionUtils;
import io.milvus.grpc.DataType;
import io.milvus.param.collection.CollectionSchemaParam;
import io.milvus.param.collection.FieldType;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.example.GroupWriteSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.MessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Buffer {
    private static final Logger logger = LoggerFactory.getLogger(Buffer.class);
    private CollectionSchemaParam collectionSchema;
    private BulkFileType fileType;
    private Map<String, List<Object>> buffer;
    private Map<String, FieldType> fields;
    private static final Gson GSON_INSTANCE = new Gson();

    public Buffer(CollectionSchemaParam collectionSchema, BulkFileType fileType) {
        this.collectionSchema = collectionSchema;
        this.fileType = fileType;
        this.buffer = new HashMap<String, List<Object>>();
        this.fields = new HashMap<String, FieldType>();
        for (FieldType fieldType : collectionSchema.getFieldTypes()) {
            if (fieldType.isPrimaryKey() && fieldType.isAutoID()) continue;
            this.buffer.put(fieldType.getName(), Lists.newArrayList());
            this.fields.put(fieldType.getName(), fieldType);
        }
        if (this.buffer.isEmpty()) {
            ExceptionUtils.throwUnExpectedException("Illegal collection schema: fields list is empty");
        }
        if (collectionSchema.isEnableDynamicField()) {
            this.buffer.put("$meta", Lists.newArrayList());
            this.fields.put("$meta", FieldType.newBuilder().withName("$meta").withDataType(DataType.JSON).build());
        }
    }

    public Integer getRowCount() {
        if (this.buffer.isEmpty()) {
            return 0;
        }
        Iterator<String> iterator = this.buffer.keySet().iterator();
        if (iterator.hasNext()) {
            String fieldName = iterator.next();
            return this.buffer.get(fieldName).size();
        }
        return null;
    }

    public void appendRow(Map<String, Object> row) {
        for (String key : row.keySet()) {
            if (key.equals("$meta") && !this.collectionSchema.isEnableDynamicField()) continue;
            this.buffer.get(key).add(row.get(key));
        }
    }

    public List<String> persist(String localPath, Integer bufferSize, Integer bufferRowCount) {
        int rowCount = -1;
        for (String key : this.buffer.keySet()) {
            if (rowCount < 0) {
                rowCount = this.buffer.get(key).size();
                continue;
            }
            if (rowCount == this.buffer.get(key).size()) continue;
            String msg = String.format("Column `%s` row count %s doesn't equal to the first column row count %s", key, this.buffer.get(key).size(), rowCount);
            ExceptionUtils.throwUnExpectedException(msg);
        }
        if (this.fileType == BulkFileType.PARQUET) {
            return this.persistParquet(localPath, bufferSize, bufferRowCount);
        }
        ExceptionUtils.throwUnExpectedException("Unsupported file type: " + (Object)((Object)this.fileType));
        return null;
    }

    private List<String> persistParquet(String localPath, Integer bufferSize, Integer bufferRowCount) {
        String filePath = localPath + ".parquet";
        int rowGroupSizeMin = 1000;
        int rowGroupSizeMax = 1000000;
        int rowGroupSize = 10000;
        int rowGroupBytes = 0x2000000;
        int sizePerRow = bufferSize / bufferRowCount + 1;
        rowGroupSize = rowGroupBytes / sizePerRow;
        rowGroupSize = Math.max(rowGroupSizeMin, Math.min(rowGroupSizeMax, rowGroupSize));
        MessageType messageType = ParquetUtils.parseCollectionSchema(this.collectionSchema);
        Path path = new Path(filePath);
        Configuration configuration = new Configuration();
        GroupWriteSupport.setSchema((MessageType)messageType, (Configuration)configuration);
        GroupWriteSupport writeSupport = new GroupWriteSupport();
        try (ParquetWriter writer = new ParquetWriter(path, ParquetFileWriter.Mode.CREATE, (WriteSupport)writeSupport, CompressionCodecName.UNCOMPRESSED, rowGroupBytes, 0x500000, 0x500000, true, false, ParquetWriter.DEFAULT_WRITER_VERSION, configuration);){
            Map<String, FieldType> nameFieldType = this.collectionSchema.getFieldTypes().stream().collect(Collectors.toMap(FieldType::getName, e -> e));
            if (this.collectionSchema.isEnableDynamicField()) {
                nameFieldType.put("$meta", FieldType.newBuilder().withName("$meta").withDataType(DataType.JSON).build());
            }
            ArrayList fieldNameList = Lists.newArrayList(this.buffer.keySet());
            int size = this.buffer.get(fieldNameList.get(0)).size();
            for (int i = 0; i < size; ++i) {
                Group group = new SimpleGroupFactory(messageType).newGroup();
                for (String fieldName : fieldNameList) {
                    this.appendGroup(group, fieldName, this.buffer.get(fieldName).get(i), nameFieldType.get(fieldName));
                }
                writer.write((Object)group);
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        String msg = String.format("Successfully persist file %s, total size: %s, row count: %s, row group size: %s", filePath, bufferSize, bufferRowCount, rowGroupSize);
        logger.info(msg);
        return Lists.newArrayList((Object[])new String[]{filePath});
    }

    private void appendGroup(Group group, String paramName, Object value, FieldType fieldType) {
        DataType dataType = fieldType.getDataType();
        block0 : switch (dataType) {
            case Int8: 
            case Int16: {
                group.append(paramName, (int)((Short)value).shortValue());
                break;
            }
            case Int32: {
                group.append(paramName, ((Integer)value).intValue());
                break;
            }
            case Int64: {
                group.append(paramName, ((Long)value).longValue());
                break;
            }
            case Float: {
                group.append(paramName, ((Float)value).floatValue());
                break;
            }
            case Double: {
                group.append(paramName, ((Double)value).doubleValue());
                break;
            }
            case Bool: {
                group.append(paramName, ((Boolean)value).booleanValue());
                break;
            }
            case String: 
            case VarChar: 
            case JSON: {
                group.append(paramName, (String)value);
                break;
            }
            case FloatVector: {
                Buffer.addFloatArray(group, paramName, (List)value);
                break;
            }
            case BinaryVector: {
                Buffer.addBinaryVector(group, paramName, (ByteBuffer)value);
                break;
            }
            case Array: {
                DataType elementType = fieldType.getElementType();
                switch (elementType) {
                    case Int8: 
                    case Int16: 
                    case Int32: {
                        Buffer.addIntArray(group, paramName, (List)value);
                        break block0;
                    }
                    case Int64: {
                        Buffer.addLongArray(group, paramName, (List)value);
                        break block0;
                    }
                    case Float: {
                        Buffer.addFloatArray(group, paramName, (List)value);
                        break block0;
                    }
                    case Double: {
                        Buffer.addDoubleArray(group, paramName, (List)value);
                        break block0;
                    }
                    case String: 
                    case VarChar: {
                        Buffer.addStringArray(group, paramName, (List)value);
                        break block0;
                    }
                    case Bool: {
                        Buffer.addBooleanArray(group, paramName, (List)value);
                    }
                }
            }
        }
    }

    private static void addLongArray(Group group, String fieldName, List<Long> values) {
        Group arrayGroup = group.addGroup(fieldName);
        for (long value : values) {
            Group addGroup = arrayGroup.addGroup(0);
            addGroup.add(0, value);
        }
    }

    private static void addStringArray(Group group, String fieldName, List<String> values) {
        Group arrayGroup = group.addGroup(fieldName);
        for (String value : values) {
            Group addGroup = arrayGroup.addGroup(0);
            addGroup.add(0, value);
        }
    }

    private static void addIntArray(Group group, String fieldName, List<Integer> values) {
        Group arrayGroup = group.addGroup(fieldName);
        for (int value : values) {
            Group addGroup = arrayGroup.addGroup(0);
            addGroup.add(0, value);
        }
    }

    private static void addFloatArray(Group group, String fieldName, List<Float> values) {
        Group arrayGroup = group.addGroup(fieldName);
        for (float value : values) {
            Group addGroup = arrayGroup.addGroup(0);
            addGroup.add(0, value);
        }
    }

    private static void addBinaryVector(Group group, String fieldName, ByteBuffer byteBuffer) {
        byte[] bytes;
        Group arrayGroup = group.addGroup(fieldName);
        for (byte value : bytes = byteBuffer.array()) {
            Group addGroup = arrayGroup.addGroup(0);
            addGroup.add(0, (int)value);
        }
    }

    private static void addDoubleArray(Group group, String fieldName, List<Double> values) {
        Group arrayGroup = group.addGroup(fieldName);
        for (double value : values) {
            Group addGroup = arrayGroup.addGroup(0);
            addGroup.add(0, value);
        }
    }

    private static void addBooleanArray(Group group, String fieldName, List<Boolean> values) {
        Group arrayGroup = group.addGroup(fieldName);
        for (boolean value : values) {
            Group addGroup = arrayGroup.addGroup(0);
            addGroup.add(0, value);
        }
    }
}

