/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.test.support.sql;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.test.support.sql.SqlHandler;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.Result;
import jakarta.inject.Singleton;
import java.util.List;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

@Singleton
@Internal
@Requires(classes={ConnectionFactory.class})
public class ConnectionFactoryHandler
implements SqlHandler<ConnectionFactory> {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionFactoryHandler.class);

    @Override
    public void handle(@NonNull ConnectionFactory connectionFactory, @NonNull String sql) {
        List rowsUpdated = (List)Mono.from((Publisher)connectionFactory.create()).flatMapMany(c -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}: Executing SQL: {}", (Object)connectionFactory, (Object)sql);
            }
            return c.createStatement(sql).execute();
        }).flatMap(Result::getRowsUpdated).collectList().block();
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: Updated rows: {}", (Object)connectionFactory, (Object)rowsUpdated);
        }
    }
}

