/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.model;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.sourcegen.model.AbstractElement;
import io.micronaut.sourcegen.model.AnnotationDef;
import io.micronaut.sourcegen.model.ClassDef;
import io.micronaut.sourcegen.model.ClassTypeDef;
import io.micronaut.sourcegen.model.EnumDef;
import io.micronaut.sourcegen.model.InterfaceDef;
import io.micronaut.sourcegen.model.MethodDef;
import io.micronaut.sourcegen.model.PropertyDef;
import io.micronaut.sourcegen.model.TypeDef;
import java.util.EnumSet;
import java.util.List;
import javax.lang.model.element.Modifier;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class ObjectDef
extends AbstractElement {
    protected final ClassTypeDef.ClassName className;
    protected final List<MethodDef> methods;
    protected final List<PropertyDef> properties;
    protected final List<TypeDef> superinterfaces;
    protected final List<ObjectDef> innerTypes;

    ObjectDef(ClassTypeDef.ClassName className, EnumSet<Modifier> modifiers, List<AnnotationDef> annotations, List<String> javadoc, List<MethodDef> methods, List<PropertyDef> properties, List<TypeDef> superinterfaces, List<ObjectDef> innerTypes, boolean synthetic) {
        super(className.getName(), modifiers, annotations, javadoc, synthetic);
        this.className = className;
        this.methods = methods;
        this.properties = properties;
        this.superinterfaces = superinterfaces;
        this.innerTypes = innerTypes;
    }

    public final List<MethodDef> getMethods() {
        return this.methods;
    }

    public final List<PropertyDef> getProperties() {
        return this.properties;
    }

    public final List<TypeDef> getSuperinterfaces() {
        return this.superinterfaces;
    }

    public final String getPackageName() {
        return this.className.getPackageName();
    }

    public final String getSimpleName() {
        return this.className.getSimpleName();
    }

    public final List<ObjectDef> getInnerTypes() {
        return this.innerTypes;
    }

    public abstract ObjectDef withClassName(ClassTypeDef.ClassName var1);

    public ClassTypeDef asTypeDef() {
        return ClassTypeDef.of(this);
    }

    @NonNull
    public TypeDef getContextualType(@NonNull TypeDef typeDef) {
        if (typeDef == TypeDef.THIS) {
            return this.asTypeDef();
        }
        if (typeDef == TypeDef.SUPER) {
            ObjectDef objectDef = this;
            if (objectDef instanceof ClassDef) {
                ClassDef classDef = (ClassDef)objectDef;
                if (classDef.getSuperclass() == null) {
                    return TypeDef.of(Object.class);
                }
                return classDef.getSuperclass();
            }
            if (this instanceof EnumDef) {
                return ClassTypeDef.of(Enum.class);
            }
            objectDef = this;
            if (objectDef instanceof InterfaceDef) {
                InterfaceDef interfaceDef = (InterfaceDef)objectDef;
                throw new IllegalStateException("Super class is not supported for interface def: " + interfaceDef);
            }
        }
        return typeDef;
    }

    @NonNull
    public static TypeDef getContextualType(@Nullable ObjectDef objectDef, @NonNull TypeDef typeDef) {
        if (objectDef == null) {
            if (typeDef == TypeDef.THIS || typeDef == TypeDef.SUPER) {
                throw new IllegalStateException("Cannot determine type: " + typeDef + " because object def is null");
            }
            return typeDef;
        }
        return objectDef.getContextualType(typeDef);
    }
}

