/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.model;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.sourcegen.model.AbstractElement;
import io.micronaut.sourcegen.model.AbstractElementBuilder;
import io.micronaut.sourcegen.model.AnnotationDef;
import io.micronaut.sourcegen.model.ExpressionDef;
import io.micronaut.sourcegen.model.ParameterDef;
import io.micronaut.sourcegen.model.StatementDef;
import io.micronaut.sourcegen.model.TypeDef;
import io.micronaut.sourcegen.model.VariableDef;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;

public final class MethodDef
extends AbstractElement {
    public static final String CONSTRUCTOR = "<init>";
    private final TypeDef returnType;
    private final List<ParameterDef> parameters;
    private final List<StatementDef> statements;
    private final boolean override;
    private final List<TypeDef.TypeVariable> typeVariables;
    private final List<TypeDef> throwTypes;

    MethodDef(String name, EnumSet<javax.lang.model.element.Modifier> modifiers, TypeDef returnType, List<ParameterDef> parameters, List<StatementDef> statements, List<AnnotationDef> annotations, List<String> javadoc, List<TypeDef.TypeVariable> typeVariables, boolean override, boolean synthetic, List<TypeDef> throwTypes) {
        super(name, modifiers, annotations, javadoc, synthetic);
        this.returnType = Objects.requireNonNullElse(returnType, TypeDef.VOID);
        this.parameters = Collections.unmodifiableList(parameters);
        this.statements = statements;
        this.override = override;
        this.typeVariables = Collections.unmodifiableList(typeVariables);
        this.throwTypes = throwTypes;
    }

    public static MethodDefBuilder constructor() {
        return MethodDef.builder(CONSTRUCTOR);
    }

    public static MethodDef constructor(Collection<ParameterDef> parameterDefs, javax.lang.model.element.Modifier ... modifiers) {
        MethodDefBuilder builder = MethodDef.builder(CONSTRUCTOR);
        int paramIndex = 0;
        for (ParameterDef parameterDef : parameterDefs) {
            builder.addParameter(parameterDef);
            int finalParamIndex = paramIndex++;
            builder.addStatement((aThis, methodParameters) -> aThis.field(parameterDef.getName(), parameterDef.getType()).put((ExpressionDef)methodParameters.get(finalParamIndex)));
        }
        builder.addModifiers(modifiers);
        return builder.build();
    }

    @NonNull
    public static MethodDef of(@NonNull MethodElement methodElement) {
        return MethodDef.of(methodElement, Map.of());
    }

    @NonNull
    public static MethodDef of(@NonNull MethodElement methodElement, Map<String, TypeDef> resolvedTypeVariables) {
        return MethodDef.builder(methodElement.getName()).addParameters((Collection<ParameterDef>)Arrays.stream(methodElement.getSuspendParameters()).map(p -> ParameterDef.of(p.getName(), TypeDef.erasure((TypedElement)p.getType(), resolvedTypeVariables))).toList()).addTypeVariables(methodElement.getTypeArguments().entrySet().stream().flatMap(e -> {
            TypeDef resolved = (TypeDef)resolvedTypeVariables.get(e.getKey());
            if (resolved != null) {
                return Stream.empty();
            }
            return Stream.of(TypeDef.variable((String)e.getKey(), TypeDef.erasure((TypedElement)e.getValue(), resolvedTypeVariables)));
        }).toList()).returns(methodElement.isSuspend() ? TypeDef.OBJECT : TypeDef.erasure((TypedElement)methodElement.getReturnType(), resolvedTypeVariables)).build();
    }

    @NonNull
    public static MethodDef of(@NonNull Method method) {
        return MethodDef.builder(method.getName()).addParameters((Collection<ParameterDef>)Arrays.stream(method.getParameters()).map(p -> ParameterDef.of(p.getName(), TypeDef.of(p.getType()))).toList()).returns(TypeDef.of(method.getReturnType())).build();
    }

    @NonNull
    public static MethodDefBuilder override(@NonNull MethodElement methodElement) {
        return MethodDef.override(methodElement, Map.of());
    }

    @NonNull
    public static MethodDefBuilder override(@NonNull MethodElement methodElement, Map<String, TypeDef> resolvedTypeVariables) {
        return ((MethodDefBuilder)MethodDef.builder(methodElement.getName()).overrides().addModifiers(MethodDef.toOverrideModifiers(methodElement))).addParameters((Collection<ParameterDef>)Arrays.stream(methodElement.getSuspendParameters()).map(p -> ParameterDef.of(p.getName(), TypeDef.erasure((TypedElement)p.getType(), resolvedTypeVariables))).toList()).returns(methodElement.isSuspend() ? TypeDef.OBJECT : TypeDef.erasure((TypedElement)methodElement.getReturnType(), resolvedTypeVariables));
    }

    @NonNull
    public static MethodDefBuilder overrideGeneric(@NonNull MethodElement methodElement) {
        return ((MethodDefBuilder)MethodDef.builder(methodElement.getName()).overrides().addModifiers(MethodDef.toOverrideModifiers(methodElement))).addParameters((Collection<ParameterDef>)Arrays.stream(methodElement.getSuspendParameters()).map(p -> ParameterDef.of(p.getName(), TypeDef.erasure((TypedElement)p.getGenericType(), Map.of()))).toList()).returns(methodElement.isSuspend() ? TypeDef.OBJECT : TypeDef.erasure((TypedElement)methodElement.getGenericReturnType(), Map.of()));
    }

    @NonNull
    public static MethodDefBuilder override(@NonNull Method method) {
        return ((MethodDefBuilder)MethodDef.builder(method.getName()).overrides().addModifiers(MethodDef.toOverrideModifiers(method.getModifiers()))).addParameters((Collection<ParameterDef>)Arrays.stream(method.getParameters()).map(p -> ParameterDef.of(p.getName(), TypeDef.of(p.getType()))).toList()).returns(TypeDef.of(method.getReturnType()));
    }

    @NonNull
    public static MethodDefBuilder override(@NonNull MethodDef method) {
        return ((MethodDefBuilder)MethodDef.builder(method.getName()).overrides().addModifiers(MethodDef.toOverrideModifiers(method))).addParameters((Collection<ParameterDef>)method.getParameters()).returns(method.getReturnType());
    }

    @NonNull
    public static MethodDefBuilder override(@NonNull Constructor<?> constructor) {
        return ((MethodDefBuilder)MethodDef.constructor().overrides().addModifiers(MethodDef.toOverrideModifiers(constructor.getModifiers()))).addParameters((Collection<ParameterDef>)Arrays.stream(constructor.getParameters()).map(p -> ParameterDef.of(p.getName(), TypeDef.of(p.getType()))).toList());
    }

    public MethodDef resolveTypeVariables(Map<String, TypeDef> resolvedTypeVariables) {
        if (!this.statements.isEmpty()) {
            throw new IllegalStateException("Method " + this + " resolving variables with statements not supported");
        }
        return ((MethodDefBuilder)((MethodDefBuilder)MethodDef.builder(this.name).addModifiers(this.modifiers)).addParameters((Collection<ParameterDef>)this.parameters.stream().map(p -> p.resolveTypeVariables(resolvedTypeVariables)).toList()).returns(this.returnType.resolveTypeVariables(resolvedTypeVariables)).addJavadoc(this.javadoc)).build();
    }

    private static javax.lang.model.element.Modifier[] toOverrideModifiers(MethodDef methodDef) {
        ArrayList<javax.lang.model.element.Modifier> modifiersList = new ArrayList<javax.lang.model.element.Modifier>();
        if (methodDef.modifiers.contains((Object)javax.lang.model.element.Modifier.PUBLIC)) {
            modifiersList.add(javax.lang.model.element.Modifier.PUBLIC);
        }
        if (methodDef.modifiers.contains((Object)javax.lang.model.element.Modifier.PROTECTED)) {
            modifiersList.add(javax.lang.model.element.Modifier.PROTECTED);
        }
        return modifiersList.toArray(new javax.lang.model.element.Modifier[0]);
    }

    private static javax.lang.model.element.Modifier[] toOverrideModifiers(int modifiers) {
        ArrayList<javax.lang.model.element.Modifier> modifiersList = new ArrayList<javax.lang.model.element.Modifier>();
        if (Modifier.isPublic(modifiers)) {
            modifiersList.add(javax.lang.model.element.Modifier.PUBLIC);
        }
        if (Modifier.isProtected(modifiers)) {
            modifiersList.add(javax.lang.model.element.Modifier.PROTECTED);
        }
        return modifiersList.toArray(new javax.lang.model.element.Modifier[0]);
    }

    private static javax.lang.model.element.Modifier[] toOverrideModifiers(MethodElement methodElement) {
        ArrayList<javax.lang.model.element.Modifier> modifiersList = new ArrayList<javax.lang.model.element.Modifier>();
        if (methodElement.isPublic()) {
            modifiersList.add(javax.lang.model.element.Modifier.PUBLIC);
        }
        if (methodElement.isProtected()) {
            modifiersList.add(javax.lang.model.element.Modifier.PROTECTED);
        }
        return modifiersList.toArray(new javax.lang.model.element.Modifier[0]);
    }

    public TypeDef getReturnType() {
        return this.returnType;
    }

    public List<ParameterDef> getParameters() {
        return this.parameters;
    }

    public List<StatementDef> getStatements() {
        return this.statements;
    }

    @Nullable
    public ParameterDef findParameter(String name) {
        for (ParameterDef parameter : this.parameters) {
            if (!parameter.getName().equals(name)) continue;
            return parameter;
        }
        return null;
    }

    @NonNull
    public ParameterDef getParameter(String name) {
        ParameterDef parameter = this.findParameter(name);
        if (parameter == null) {
            throw new IllegalStateException("Method: " + name + " doesn't have parameter: " + name);
        }
        return parameter;
    }

    public boolean isOverride() {
        return this.override;
    }

    public boolean isConstructor() {
        return CONSTRUCTOR.equals(this.getName());
    }

    public List<TypeDef.TypeVariable> getTypeVariables() {
        return this.typeVariables;
    }

    public List<TypeDef> getThrowTypes() {
        return this.throwTypes;
    }

    public static MethodDefBuilder builder(String name) {
        return new MethodDefBuilder(name);
    }

    public String toString() {
        return "MethodDef{name='" + this.name + "', modifiers=" + this.modifiers + ", returnType=" + this.returnType + ", parameters=" + this.parameters + ", statements=" + this.statements + ", override=" + this.override + "}";
    }

    public static final class MethodDefBuilder
    extends AbstractElementBuilder<MethodDefBuilder> {
        private final List<ParameterDef> parameters = new ArrayList<ParameterDef>();
        private TypeDef returnType;
        private final List<MethodBodyBuilder> bodyBuilders = new ArrayList<MethodBodyBuilder>();
        private final List<StatementDef> statements = new ArrayList<StatementDef>();
        private boolean overrides;
        private final List<TypeDef.TypeVariable> typeVariables = new ArrayList<TypeDef.TypeVariable>();
        private final List<TypeDef> throwTypes = new ArrayList<TypeDef>();

        private MethodDefBuilder(String name) {
            super(name);
        }

        public MethodDefBuilder addTypeVariable(TypeDef.TypeVariable typeVariable) {
            this.typeVariables.add(typeVariable);
            return this;
        }

        public MethodDefBuilder addTypeVariables(List<TypeDef.TypeVariable> typeVariables) {
            this.typeVariables.addAll(typeVariables);
            return this;
        }

        public MethodDefBuilder returns(TypeDef type) {
            this.returnType = type;
            return this;
        }

        public MethodDefBuilder overrides() {
            return this.overrides(true);
        }

        public MethodDefBuilder overrides(boolean overrides) {
            this.overrides = overrides;
            return this;
        }

        public MethodDefBuilder returns(Class<?> type) {
            return this.returns(TypeDef.of(type));
        }

        @NonNull
        public MethodDefBuilder addParameter(@NonNull String name, @NonNull TypeDef type) {
            ParameterDef parameterDef = ParameterDef.builder(name, type).build();
            return this.addParameter(parameterDef);
        }

        @NonNull
        public MethodDefBuilder addParameter(@NonNull TypeDef type) {
            return this.addParameter("arg" + (this.parameters.size() + 1), type);
        }

        @NonNull
        public MethodDefBuilder addParameter(@NonNull ParameterDef parameterDef) {
            Objects.requireNonNull(parameterDef, "Parameter cannot be null");
            this.parameters.add(parameterDef);
            return this;
        }

        @NonNull
        public MethodDefBuilder addParameters(@NonNull Collection<ParameterDef> parameters) {
            parameters.forEach(this::addParameter);
            return this;
        }

        @NonNull
        public MethodDefBuilder addParameter(@NonNull String name, @NonNull Class<?> type) {
            return this.addParameter(name, TypeDef.of(type));
        }

        @NonNull
        public MethodDefBuilder addParameter(@NonNull Class<?> type) {
            return this.addParameter(TypeDef.of(type));
        }

        @NonNull
        public MethodDefBuilder addParameters(Class<?> ... types) {
            for (Class<?> type : types) {
                this.addParameter(type);
            }
            return this;
        }

        @NonNull
        public MethodDefBuilder addParameters(TypeDef ... types) {
            return this.addParameters(List.of(types));
        }

        @NonNull
        public MethodDefBuilder addParameters(@NonNull List<TypeDef> types) {
            for (TypeDef type : types) {
                this.addParameter(type);
            }
            return this;
        }

        @NonNull
        public MethodDefBuilder addStaticStatement(@NonNull Function<List<VariableDef.MethodParameter>, StatementDef> bodyBuilder) {
            return this.addStatement((aThis, methodParameters) -> (StatementDef)bodyBuilder.apply((List<VariableDef.MethodParameter>)methodParameters));
        }

        @NonNull
        public MethodDefBuilder addStatement(@NonNull StatementDef statement) {
            if (statement instanceof StatementDef.Multi) {
                StatementDef.Multi multi = (StatementDef.Multi)statement;
                multi.statements().forEach(this::addStatement);
            } else {
                this.statements.add(statement);
            }
            return this;
        }

        @NonNull
        public MethodDefBuilder addStatement(@NonNull MethodBodyBuilder bodyBuilder) {
            this.bodyBuilders.add(bodyBuilder);
            return this;
        }

        @NonNull
        public MethodDefBuilder addStatements(@NonNull Collection<StatementDef> newStatements) {
            this.statements.addAll(newStatements);
            return this;
        }

        @NonNull
        public MethodDefBuilder addThrows(TypeDef ... types) {
            this.throwTypes.addAll(Arrays.asList(types));
            return this;
        }

        @NonNull
        public MethodDefBuilder addThrows(@NonNull List<TypeDef> types) {
            this.throwTypes.addAll(types);
            return this;
        }

        public MethodDef build() {
            List<VariableDef.MethodParameter> variables = this.parameters.stream().map(ParameterDef::asVariable).toList();
            for (MethodBodyBuilder bodyBuilder : this.bodyBuilders) {
                StatementDef statement = (StatementDef)bodyBuilder.apply(new VariableDef.This(), variables);
                if (statement == null) continue;
                this.addStatement(statement);
            }
            if (this.returnType == null && !this.statements.isEmpty()) {
                this.returnType = MethodDefBuilder.findReturnType((StatementDef)CollectionUtils.last(this.statements));
            }
            if (this.returnType == null && !this.name.equals(MethodDef.CONSTRUCTOR)) {
                this.returnType = TypeDef.VOID;
            }
            return new MethodDef(this.name, this.modifiers, this.returnType, this.parameters, this.statements, this.annotations, this.javadoc, this.typeVariables, this.overrides, this.synthetic, this.throwTypes);
        }

        private static TypeDef findReturnType(StatementDef statement) {
            if (statement instanceof StatementDef.Multi) {
                StatementDef.Multi multi = (StatementDef.Multi)statement;
                return MethodDefBuilder.findReturnType((StatementDef)CollectionUtils.last(multi.statements()));
            }
            if (statement instanceof StatementDef.Return) {
                StatementDef.Return aReturn = (StatementDef.Return)statement;
                return aReturn.expression().type();
            }
            if (statement instanceof StatementDef.Try) {
                StatementDef.Try aTry = (StatementDef.Try)statement;
                return MethodDefBuilder.findReturnType(aTry.statement());
            }
            if (statement instanceof StatementDef.Synchronized) {
                StatementDef.Synchronized aSynchronized = (StatementDef.Synchronized)statement;
                return MethodDefBuilder.findReturnType(aSynchronized.statement());
            }
            return null;
        }

        @NonNull
        public MethodDef build(@NonNull MethodBodyBuilder bodyBuilder) {
            this.bodyBuilders.add(bodyBuilder);
            return this.build();
        }

        @NonNull
        public MethodDef buildStatic(@NonNull Function<List<VariableDef.MethodParameter>, StatementDef> bodyBuilder) {
            this.modifiers.add(javax.lang.model.element.Modifier.STATIC);
            this.bodyBuilders.add((aThis, methodParameters) -> (StatementDef)bodyBuilder.apply((List<VariableDef.MethodParameter>)methodParameters));
            return this.build();
        }
    }

    public static interface MethodBodyBuilder
    extends BiFunction<VariableDef.This, List<VariableDef.MethodParameter>, StatementDef> {
    }
}

