/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.model;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.sourcegen.model.ClassTypeDef;
import io.micronaut.sourcegen.model.TypeDef;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class AnnotationDef {
    private final ClassTypeDef type;
    private final Map<String, Object> values;

    private AnnotationDef(ClassTypeDef type, Map<String, Object> values) {
        this.type = type;
        this.values = values;
    }

    public ClassTypeDef getType() {
        return this.type;
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public static AnnotationDefBuilder builder(ClassTypeDef type) {
        return new AnnotationDefBuilder(type);
    }

    public static AnnotationDefBuilder builder(Class<? extends Annotation> annotationType) {
        return new AnnotationDefBuilder(ClassTypeDef.of(annotationType));
    }

    public static AnnotationDef of(AnnotationValue<?> annotation, VisitorContext context) {
        ClassElement annotationElement = (ClassElement)context.getClassElement(annotation.getAnnotationName()).orElseThrow(() -> new RuntimeException("Could not create class element for " + annotation.getAnnotationName()));
        Map<String, ClassElement> fieldTypes = annotationElement.getMethods().stream().collect(Collectors.toMap(Element::getName, MethodElement::getReturnType));
        if (fieldTypes.isEmpty()) {
            fieldTypes = annotationElement.getFields().stream().collect(Collectors.toMap(Element::getName, TypedElement::getType));
        }
        ClassTypeDef annotationType = ClassTypeDef.of(annotation.getAnnotationName(), annotation.getAnnotationName().contains("$"));
        AnnotationDefBuilder builder = AnnotationDef.builder(annotationType);
        Map<String, ClassElement> finalFieldTypes = fieldTypes;
        annotation.getConvertibleValues().asMap().forEach((key, value) -> AnnotationDef.copyAnnotationValue(value, (ClassElement)finalFieldTypes.get(key), context).ifPresent(copiedValue -> builder.addMember((String)key, copiedValue)));
        return builder.build();
    }

    private static Optional<Object> copyAnnotationValue(Object value, ClassElement requiredType, VisitorContext context) {
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return Optional.of(collection.stream().map(v -> AnnotationDef.copyAnnotationValue(v, requiredType, context)).filter(Optional::isPresent).map(Optional::get).toList());
        }
        if (value instanceof AnnotationValue) {
            AnnotationValue annotationMember = (AnnotationValue)value;
            return Optional.of(AnnotationDef.of(annotationMember, context));
        }
        if (requiredType.isArray()) {
            return Optional.of(AnnotationDef.streamOfArray(value).map(v -> AnnotationDef.copyAnnotationValue(v, requiredType.fromArray(), context)).filter(Optional::isPresent).map(Optional::get).toList());
        }
        if (requiredType.isPrimitive() || requiredType.getName().equals("java.lang.String")) {
            return Optional.of(value);
        }
        if (requiredType.getName().equals("java.lang.Class")) {
            return context.getClassElement(value.toString()).map(type -> ClassTypeDef.of(type).getStaticField("class", TypeDef.of(Class.class)));
        }
        ClassTypeDef type2 = ClassTypeDef.of(requiredType);
        return Optional.of(type2.getStaticField(value.toString(), type2));
    }

    private static Stream<?> streamOfArray(Object value) {
        if (value instanceof boolean[]) {
            boolean[] values = (boolean[])value;
            return IntStream.range(0, values.length).mapToObj(i -> values[i]);
        }
        if (value instanceof byte[]) {
            byte[] values = (byte[])value;
            return IntStream.range(0, values.length).mapToObj(i -> values[i]);
        }
        if (value instanceof char[]) {
            char[] values = (char[])value;
            return IntStream.range(0, values.length).mapToObj(i -> Character.valueOf(values[i]));
        }
        if (value instanceof short[]) {
            short[] values = (short[])value;
            return IntStream.range(0, values.length).mapToObj(i -> values[i]);
        }
        if (value instanceof int[]) {
            int[] values = (int[])value;
            return IntStream.range(0, values.length).mapToObj(i -> values[i]);
        }
        if (value instanceof long[]) {
            long[] values = (long[])value;
            return IntStream.range(0, values.length).mapToObj(i -> values[i]);
        }
        if (value instanceof float[]) {
            float[] values = (float[])value;
            return IntStream.range(0, values.length).mapToObj(i -> Float.valueOf(values[i]));
        }
        if (value instanceof double[]) {
            double[] values = (double[])value;
            return IntStream.range(0, values.length).mapToObj(i -> values[i]);
        }
        return Arrays.stream((Object[])value);
    }

    public static final class AnnotationDefBuilder {
        private final ClassTypeDef type;
        private final Map<String, Object> values = new LinkedHashMap<String, Object>();

        public AnnotationDefBuilder(ClassTypeDef type) {
            this.type = type;
        }

        public AnnotationDefBuilder addMember(String member, Object value) {
            this.values.put(member, value);
            return this;
        }

        public AnnotationDefBuilder addMember(String member, Collection<Object> values) {
            this.values.put(member, values);
            return this;
        }

        public AnnotationDefBuilder addMember(String member, AnnotationDef annotationValue) {
            this.values.put(member, annotationValue);
            return this;
        }

        public AnnotationDef build() {
            return new AnnotationDef(this.type, Collections.unmodifiableMap(this.values));
        }
    }
}

