/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.model;

import io.micronaut.sourcegen.model.AnnotationDef;
import io.micronaut.sourcegen.model.ClassTypeDef;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.lang.model.element.Modifier;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class AbstractElementBuilder<ThisType> {
    protected final String name;
    protected final EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
    protected final List<AnnotationDef> annotations = new ArrayList<AnnotationDef>();
    protected final List<String> javadoc = new ArrayList<String>();
    protected final ThisType thisInstance;
    protected boolean synthetic;

    protected AbstractElementBuilder(String name) {
        this.name = name;
        this.thisInstance = this;
    }

    public final ThisType synthetic() {
        this.synthetic = true;
        return this.thisInstance;
    }

    public final ThisType synthetic(boolean synthetic) {
        this.synthetic = synthetic;
        return this.thisInstance;
    }

    public final ThisType addModifiers(Collection<Modifier> modifiers) {
        this.modifiers.addAll(modifiers);
        return this.thisInstance;
    }

    public final ThisType addModifiers(Modifier ... modifiers) {
        Collections.addAll(this.modifiers, modifiers);
        return this.thisInstance;
    }

    public final ThisType overrideModifiers(Modifier ... modifiers) {
        this.modifiers.clear();
        Collections.addAll(this.modifiers, modifiers);
        return this.thisInstance;
    }

    public final ThisType addAnnotation(String annotationName) {
        return this.addAnnotation(ClassTypeDef.of(annotationName));
    }

    public final ThisType addAnnotation(Class<? extends Annotation> annotationType) {
        return this.addAnnotation(ClassTypeDef.of(annotationType));
    }

    public final ThisType addAnnotation(ClassTypeDef typeDef) {
        return this.addAnnotation(AnnotationDef.builder(typeDef).build());
    }

    public final ThisType addAnnotation(AnnotationDef annotationDef) {
        this.annotations.add(annotationDef);
        return this.thisInstance;
    }

    public final ThisType addAnnotations(AnnotationDef ... annotationDefs) {
        return this.addAnnotations(Arrays.asList(annotationDefs));
    }

    public final ThisType addAnnotations(List<AnnotationDef> annotationDefs) {
        annotationDefs.forEach(this::addAnnotation);
        return this.thisInstance;
    }

    public final ThisType addJavadoc(String doc) {
        this.javadoc.add(doc);
        return this.thisInstance;
    }

    public final ThisType addJavadoc(List<String> doc) {
        this.javadoc.addAll(doc);
        return this.thisInstance;
    }
}

