/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.model;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.sourcegen.model.AbstractElement;
import io.micronaut.sourcegen.model.AbstractElementBuilder;
import io.micronaut.sourcegen.model.AnnotationDef;
import io.micronaut.sourcegen.model.ExpressionDef;
import io.micronaut.sourcegen.model.TypeDef;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.lang.model.element.Modifier;

public final class FieldDef
extends AbstractElement {
    private final TypeDef type;
    private final ExpressionDef initializer;

    private FieldDef(String name, EnumSet<Modifier> modifiers, TypeDef type, ExpressionDef initializer, List<AnnotationDef> annotations, List<String> javadoc, boolean synthetic) {
        super(name, modifiers, annotations, javadoc, synthetic);
        this.type = type;
        this.initializer = initializer;
    }

    @NonNull
    public static FieldDefBuilder builder(@NonNull String name) {
        return new FieldDefBuilder(name);
    }

    @NonNull
    public static FieldDefBuilder builder(@NonNull String name, @NonNull TypeDef type) {
        return new FieldDefBuilder(name, type);
    }

    @NonNull
    public static FieldDefBuilder builder(@NonNull String name, @NonNull Class<?> type) {
        return new FieldDefBuilder(name, TypeDef.of(type));
    }

    public TypeDef getType() {
        return this.type;
    }

    public Optional<ExpressionDef> getInitializer() {
        return Optional.ofNullable(this.initializer);
    }

    public static final class FieldDefBuilder
    extends AbstractElementBuilder<FieldDefBuilder> {
        private TypeDef type;
        private ExpressionDef initializer;

        private FieldDefBuilder(String name) {
            super(name);
        }

        private FieldDefBuilder(String name, TypeDef type) {
            this(name);
            this.type = type;
        }

        public FieldDefBuilder ofType(TypeDef type) {
            this.type = type;
            return this;
        }

        public FieldDef build() {
            Objects.requireNonNull(this.name, "Name cannot be null");
            Objects.requireNonNull(this.type, "Type cannot be null");
            return new FieldDef(this.name, this.modifiers, this.type, this.initializer, this.annotations, this.javadoc, this.synthetic);
        }

        public FieldDefBuilder initializer(ExpressionDef expr) {
            this.initializer = expr;
            return this;
        }
    }
}

