/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.bytecode.statement;

import io.micronaut.sourcegen.bytecode.AbstractConditionalWriter;
import io.micronaut.sourcegen.bytecode.MethodContext;
import io.micronaut.sourcegen.bytecode.statement.StatementWriter;
import io.micronaut.sourcegen.model.StatementDef;
import org.objectweb.asm.Label;
import org.objectweb.asm.commons.GeneratorAdapter;

final class IfElseStatementWriter
extends AbstractConditionalWriter
implements StatementWriter {
    private final StatementDef.IfElse ifStatement;

    public IfElseStatementWriter(StatementDef.IfElse ifStatement) {
        this.ifStatement = ifStatement;
    }

    @Override
    public void write(GeneratorAdapter generatorAdapter, MethodContext context, Runnable finallyBlock) {
        Label elseLabel = new Label();
        IfElseStatementWriter.pushElseConditionalExpression(generatorAdapter, context, this.ifStatement.condition(), elseLabel);
        Label end = new Label();
        StatementWriter.of(this.ifStatement.statement()).writeScoped(generatorAdapter, context, finallyBlock);
        generatorAdapter.visitLabel(end);
        generatorAdapter.visitLabel(elseLabel);
        StatementWriter.of(this.ifStatement.elseStatement()).writeScoped(generatorAdapter, context, finallyBlock);
    }
}

