/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.bytecode.statement;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.sourcegen.bytecode.MethodContext;
import io.micronaut.sourcegen.bytecode.statement.AssignVariableStatementWriter;
import io.micronaut.sourcegen.bytecode.statement.DefineAndAssignStatementWriter;
import io.micronaut.sourcegen.bytecode.statement.ExpressionAsStatementWriter;
import io.micronaut.sourcegen.bytecode.statement.IfElseStatementWriter;
import io.micronaut.sourcegen.bytecode.statement.IfStatementWriter;
import io.micronaut.sourcegen.bytecode.statement.MultiStatementWriter;
import io.micronaut.sourcegen.bytecode.statement.PutStaticFieldStatementWriter;
import io.micronaut.sourcegen.bytecode.statement.PutStaticStatementWriter;
import io.micronaut.sourcegen.bytecode.statement.ReturnStatementWriter;
import io.micronaut.sourcegen.bytecode.statement.SwitchStatementWriter;
import io.micronaut.sourcegen.bytecode.statement.SynchronizedStatementWriter;
import io.micronaut.sourcegen.bytecode.statement.ThrowStatementWriter;
import io.micronaut.sourcegen.bytecode.statement.TryCatchStatementWriter;
import io.micronaut.sourcegen.bytecode.statement.WhileLoopStatementWriter;
import io.micronaut.sourcegen.model.ExpressionDef;
import io.micronaut.sourcegen.model.StatementDef;
import java.util.LinkedHashMap;
import java.util.Map;
import org.objectweb.asm.Label;
import org.objectweb.asm.commons.GeneratorAdapter;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface StatementWriter {
    public static StatementWriter of(StatementDef statementDef) {
        if (statementDef instanceof StatementDef.Multi) {
            StatementDef.Multi statements = (StatementDef.Multi)statementDef;
            return new MultiStatementWriter(statements);
        }
        if (statementDef instanceof StatementDef.If) {
            StatementDef.If ifStatement = (StatementDef.If)statementDef;
            return new IfStatementWriter(ifStatement);
        }
        if (statementDef instanceof StatementDef.IfElse) {
            StatementDef.IfElse ifStatement = (StatementDef.IfElse)statementDef;
            return new IfElseStatementWriter(ifStatement);
        }
        if (statementDef instanceof StatementDef.Switch) {
            StatementDef.Switch aSwitch = (StatementDef.Switch)statementDef;
            return new SwitchStatementWriter(aSwitch);
        }
        if (statementDef instanceof StatementDef.While) {
            StatementDef.While aWhile = (StatementDef.While)statementDef;
            return new WhileLoopStatementWriter(aWhile);
        }
        if (statementDef instanceof StatementDef.Throw) {
            StatementDef.Throw aThrow = (StatementDef.Throw)statementDef;
            return new ThrowStatementWriter(aThrow);
        }
        if (statementDef instanceof StatementDef.Return) {
            StatementDef.Return aReturn = (StatementDef.Return)statementDef;
            return new ReturnStatementWriter(aReturn);
        }
        if (statementDef instanceof StatementDef.PutStaticField) {
            StatementDef.PutStaticField putStaticField = (StatementDef.PutStaticField)statementDef;
            return new PutStaticStatementWriter(putStaticField);
        }
        if (statementDef instanceof StatementDef.PutField) {
            StatementDef.PutField putField = (StatementDef.PutField)statementDef;
            return new PutStaticFieldStatementWriter(putField);
        }
        if (statementDef instanceof StatementDef.Assign) {
            StatementDef.Assign assign = (StatementDef.Assign)statementDef;
            return new AssignVariableStatementWriter(assign);
        }
        if (statementDef instanceof StatementDef.DefineAndAssign) {
            StatementDef.DefineAndAssign assign = (StatementDef.DefineAndAssign)statementDef;
            return new DefineAndAssignStatementWriter(assign);
        }
        if (statementDef instanceof StatementDef.Try) {
            StatementDef.Try aTry = (StatementDef.Try)statementDef;
            return new TryCatchStatementWriter(aTry);
        }
        if (statementDef instanceof StatementDef.Synchronized) {
            StatementDef.Synchronized aSynchronized = (StatementDef.Synchronized)statementDef;
            return new SynchronizedStatementWriter(aSynchronized);
        }
        if (statementDef instanceof ExpressionDef) {
            ExpressionDef expressionDef = (ExpressionDef)statementDef;
            return new ExpressionAsStatementWriter(expressionDef);
        }
        throw new UnsupportedOperationException("Unrecognized statement: " + String.valueOf(statementDef));
    }

    public void write(GeneratorAdapter var1, MethodContext var2, @Nullable Runnable var3);

    default public void writeScoped(GeneratorAdapter generatorAdapter, MethodContext context, @Nullable Runnable finallyBlock) {
        Map<String, MethodContext.LocalData> oldLocals = context.locals();
        LinkedHashMap<String, MethodContext.LocalData> newLocals = new LinkedHashMap<String, MethodContext.LocalData>(oldLocals);
        MethodContext newContext = new MethodContext(context.objectDef(), context.methodDef(), newLocals);
        this.write(generatorAdapter, newContext, finallyBlock);
        oldLocals.keySet().forEach(newLocals::remove);
        Label endMethod = new Label();
        if (!newLocals.isEmpty()) {
            generatorAdapter.visitLabel(endMethod);
        }
        for (MethodContext.LocalData localsDatum : newLocals.values()) {
            generatorAdapter.getDelegate().visitLocalVariable(localsDatum.name(), localsDatum.type().getDescriptor(), null, localsDatum.start(), endMethod, localsDatum.index());
        }
    }
}

