/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.bytecode.expression;

import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.sourcegen.bytecode.AbstractSwitchWriter;
import io.micronaut.sourcegen.bytecode.MethodContext;
import io.micronaut.sourcegen.bytecode.expression.ExpressionWriter;
import io.micronaut.sourcegen.model.ClassTypeDef;
import io.micronaut.sourcegen.model.ExpressionDef;
import io.micronaut.sourcegen.model.TypeDef;
import java.util.Map;
import java.util.stream.Collectors;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.commons.TableSwitchGenerator;

final class SwitchExpressionWriter
extends AbstractSwitchWriter
implements ExpressionWriter {
    private final ExpressionDef.Switch aSwitch;

    public SwitchExpressionWriter(ExpressionDef.Switch aSwitch) {
        this.aSwitch = aSwitch;
    }

    @Override
    public void write(GeneratorAdapter generatorAdapter, MethodContext context) {
        ClassTypeDef classTypeDef;
        boolean isStringSwitch;
        ExpressionDef expression = this.aSwitch.expression();
        TypeDef typeDef = expression.type();
        boolean bl = isStringSwitch = typeDef instanceof ClassTypeDef && (classTypeDef = (ClassTypeDef)typeDef).getName().equals(String.class.getName());
        if (isStringSwitch) {
            SwitchExpressionWriter.writeStringSwitch(generatorAdapter, context, this.aSwitch);
        } else {
            SwitchExpressionWriter.writeSwitch(generatorAdapter, context, this.aSwitch);
        }
    }

    private static void writeSwitch(final GeneratorAdapter generatorAdapter, final MethodContext context, final ExpressionDef.Switch aSwitch) {
        ExpressionDef expression = aSwitch.expression();
        SwitchExpressionWriter.pushSwitchExpression(generatorAdapter, context, expression);
        final Map<Integer, ExpressionDef> map = aSwitch.cases().entrySet().stream().map(e -> Map.entry(SwitchExpressionWriter.toSwitchKey((ExpressionDef.Constant)e.getKey()), (ExpressionDef)e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        int[] keys = map.keySet().stream().mapToInt(x -> x).sorted().toArray();
        generatorAdapter.tableSwitch(keys, new TableSwitchGenerator(){

            public void generateCase(int key, Label end) {
                ExpressionDef exp = (ExpressionDef)map.get(key);
                ExpressionWriter.writeExpressionCheckCast(generatorAdapter, context, exp, aSwitch.type());
                generatorAdapter.goTo(end);
            }

            public void generateDefault() {
                ExpressionWriter.writeExpressionCheckCast(generatorAdapter, context, aSwitch.defaultCase(), aSwitch.type());
            }
        });
    }

    private static void writeStringSwitch(final GeneratorAdapter generatorAdapter, final MethodContext context, final ExpressionDef.Switch aSwitch) {
        ExpressionDef expression = aSwitch.expression();
        ExpressionWriter.writeExpression(generatorAdapter, context, expression);
        final Type stringType = Type.getType(String.class);
        final int switchValueLocal = generatorAdapter.newLocal(stringType);
        generatorAdapter.storeLocal(switchValueLocal, stringType);
        generatorAdapter.loadLocal(switchValueLocal, stringType);
        generatorAdapter.invokeVirtual(stringType, Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredMethod(String.class, (String)"hashCode", (Class[])new Class[0])));
        final Map<Integer, Map.Entry> map = aSwitch.cases().entrySet().stream().map(e -> Map.entry(SwitchExpressionWriter.toSwitchKey((ExpressionDef.Constant)e.getKey()), Map.entry((ExpressionDef.Constant)e.getKey(), (ExpressionDef)e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        int[] keys = map.keySet().stream().mapToInt(x -> x).sorted().toArray();
        final Label defaultEnd = new Label();
        final Label finalEnd = new Label();
        generatorAdapter.tableSwitch(keys, new TableSwitchGenerator(){

            public void generateCase(int key, Label end) {
                Map.Entry e = (Map.Entry)map.get(key);
                Object object = ((ExpressionDef.Constant)e.getKey()).value();
                if (!(object instanceof String)) {
                    throw new IllegalStateException("Expected a switch string value got " + String.valueOf(e.getKey()));
                }
                String stringValue = (String)object;
                generatorAdapter.loadLocal(switchValueLocal, stringType);
                generatorAdapter.push(stringValue);
                generatorAdapter.invokeVirtual(stringType, Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredMethod(String.class, (String)"equals", (Class[])new Class[]{Object.class})));
                generatorAdapter.push(true);
                generatorAdapter.ifCmp(Type.BOOLEAN_TYPE, 154, defaultEnd);
                ExpressionWriter.writeExpressionCheckCast(generatorAdapter, context, (ExpressionDef)e.getValue(), aSwitch.type());
                generatorAdapter.goTo(finalEnd);
            }

            public void generateDefault() {
                generatorAdapter.goTo(defaultEnd);
            }
        });
        generatorAdapter.visitLabel(defaultEnd);
        ExpressionWriter.writeExpressionCheckCast(generatorAdapter, context, aSwitch.defaultCase(), aSwitch.type());
        generatorAdapter.visitLabel(finalEnd);
    }
}

