/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.bytecode.expression;

import io.micronaut.sourcegen.bytecode.MethodContext;
import io.micronaut.sourcegen.bytecode.TypeUtils;
import io.micronaut.sourcegen.bytecode.expression.AbstractStatementAwareExpressionWriter;
import io.micronaut.sourcegen.bytecode.expression.ExpressionWriter;
import io.micronaut.sourcegen.model.ClassDef;
import io.micronaut.sourcegen.model.ClassTypeDef;
import io.micronaut.sourcegen.model.EnumDef;
import io.micronaut.sourcegen.model.ExpressionDef;
import io.micronaut.sourcegen.model.MethodDef;
import io.micronaut.sourcegen.model.ObjectDef;
import io.micronaut.sourcegen.model.ParameterDef;
import io.micronaut.sourcegen.model.TypeDef;
import io.micronaut.sourcegen.model.VariableDef;
import java.util.Iterator;
import java.util.Objects;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

final class InvokeInstanceMethodExpressionWriter
extends AbstractStatementAwareExpressionWriter
implements ExpressionWriter {
    private final ExpressionDef.InvokeInstanceMethod invokeInstanceMethod;

    public InvokeInstanceMethodExpressionWriter(ExpressionDef.InvokeInstanceMethod invokeInstanceMethod) {
        this.invokeInstanceMethod = invokeInstanceMethod;
    }

    @Override
    public void write(GeneratorAdapter generatorAdapter, MethodContext context) {
        ExpressionDef instance = this.invokeInstanceMethod.instance();
        ExpressionWriter.writeExpression(generatorAdapter, context, instance);
        Iterator iterator = this.invokeInstanceMethod.method().getParameters().iterator();
        for (ExpressionDef parameter : this.invokeInstanceMethod.values()) {
            ExpressionWriter.writeExpressionCheckCast(generatorAdapter, context, parameter, ((ParameterDef)iterator.next()).getType());
        }
        TypeDef instanceType = instance.type();
        Type methodOwnerType = TypeUtils.getType(instanceType, context.objectDef());
        MethodDef methodDef = this.invokeInstanceMethod.method();
        Method method = new Method(methodDef.getName(), TypeUtils.getMethodDescriptor(context.objectDef(), methodDef));
        if (instanceType instanceof ClassTypeDef) {
            ClassTypeDef classTypeDef = (ClassTypeDef)instanceType;
            if (instance instanceof VariableDef.Super) {
                VariableDef.Super aSuper = (VariableDef.Super)instance;
                ClassTypeDef superType = this.getSuperType(context, aSuper);
                methodOwnerType = TypeUtils.getType((TypeDef)superType, context.objectDef());
                generatorAdapter.visitMethodInsn(183, methodOwnerType.getSort() == 9 ? methodOwnerType.getDescriptor() : methodOwnerType.getInternalName(), method.getName(), method.getDescriptor(), superType.isInterface() && this.invokeInstanceMethod.isDefault());
            } else if (this.invokeInstanceMethod.method().isConstructor()) {
                generatorAdapter.invokeConstructor(methodOwnerType, method);
            } else if (classTypeDef.isInterface()) {
                generatorAdapter.invokeInterface(methodOwnerType, method);
            } else {
                generatorAdapter.invokeVirtual(methodOwnerType, method);
            }
        } else if (instanceType instanceof TypeDef.Array) {
            generatorAdapter.invokeVirtual(methodOwnerType, method);
        }
        this.popValueIfNeeded(generatorAdapter, this.invokeInstanceMethod.method().getReturnType());
    }

    private ClassTypeDef getSuperType(MethodContext context, VariableDef.Super aSuper) {
        ClassTypeDef superClass;
        if (aSuper.type() == TypeDef.SUPER) {
            if (context.objectDef() instanceof EnumDef) {
                superClass = ClassTypeDef.of(Enum.class);
            } else {
                ObjectDef objectDef = context.objectDef();
                if (objectDef instanceof ClassDef) {
                    ClassDef classDef = (ClassDef)objectDef;
                    superClass = Objects.requireNonNullElse(classDef.getSuperclass(), TypeDef.OBJECT);
                } else {
                    superClass = TypeDef.OBJECT;
                }
            }
        } else {
            superClass = aSuper.type();
        }
        return superClass;
    }
}

