/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.bytecode;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.processing.JavaModelUtils;
import io.micronaut.sourcegen.model.ClassDef;
import io.micronaut.sourcegen.model.ClassTypeDef;
import io.micronaut.sourcegen.model.InterfaceDef;
import io.micronaut.sourcegen.model.MethodDef;
import io.micronaut.sourcegen.model.ObjectDef;
import io.micronaut.sourcegen.model.ParameterDef;
import io.micronaut.sourcegen.model.TypeDef;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.objectweb.asm.Type;

@Internal
public final class TypeUtils {
    public static final Type OBJECT_TYPE = Type.getType(Object.class);
    private static final Pattern ARRAY_PATTERN = Pattern.compile("(\\[])+$");

    public static String getMethodDescriptor(@Nullable ObjectDef objectDef, MethodDef methodDef) {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (ParameterDef parameterDef : methodDef.getParameters()) {
            builder.append(TypeUtils.getType(parameterDef.getType(), objectDef));
        }
        builder.append(')');
        builder.append(TypeUtils.getType((TypeDef)Objects.requireNonNullElse(methodDef.getReturnType(), TypeDef.VOID), objectDef));
        return builder.toString();
    }

    public static Type getType(TypeDef typeDef, @Nullable ObjectDef objectDef) {
        if ((typeDef = ObjectDef.getContextualType((ObjectDef)objectDef, (TypeDef)typeDef)) instanceof TypeDef.Array) {
            TypeDef.Array array = (TypeDef.Array)typeDef;
            return Type.getType((String)("[".repeat(array.dimensions()) + TypeUtils.getType(array.componentType(), objectDef).getDescriptor()));
        }
        if (typeDef instanceof ClassTypeDef.Parameterized) {
            ClassTypeDef.Parameterized parameterized = (ClassTypeDef.Parameterized)typeDef;
            return TypeUtils.getType(parameterized.rawType().getName());
        }
        if (typeDef instanceof ClassTypeDef) {
            ClassTypeDef classTypeDef = (ClassTypeDef)typeDef;
            return TypeUtils.getType(classTypeDef.getName());
        }
        if (typeDef instanceof TypeDef.Primitive) {
            TypeDef.Primitive primitive = (TypeDef.Primitive)typeDef;
            return TypeUtils.getType(primitive);
        }
        if (typeDef instanceof TypeDef.Wildcard) {
            TypeDef.Wildcard wildcard = (TypeDef.Wildcard)typeDef;
            if (!wildcard.lowerBounds().isEmpty()) {
                return TypeUtils.getBoundsType(wildcard.lowerBounds(), objectDef);
            }
            if (!wildcard.upperBounds().isEmpty()) {
                return TypeUtils.getBoundsType(wildcard.upperBounds(), objectDef);
            }
            return OBJECT_TYPE;
        }
        if (typeDef instanceof TypeDef.TypeVariable) {
            TypeDef.TypeVariable typeVariable = (TypeDef.TypeVariable)typeDef;
            if (typeVariable.bounds().isEmpty()) {
                InterfaceDef interfaceDef;
                ClassDef classDef;
                TypeDef.TypeVariable tvDef;
                if (objectDef instanceof ClassDef && (tvDef = (TypeDef.TypeVariable)(classDef = (ClassDef)objectDef).getTypeVariables().stream().filter(tv -> tv.name().equals(typeVariable.name())).findFirst().orElse(null)) != null) {
                    return TypeUtils.getBoundsType(tvDef.bounds(), objectDef);
                }
                if (objectDef instanceof InterfaceDef && (tvDef = (TypeDef.TypeVariable)(interfaceDef = (InterfaceDef)objectDef).getTypeVariables().stream().filter(tv -> tv.name().equals(typeVariable.name())).findFirst().orElse(null)) != null) {
                    return TypeUtils.getBoundsType(tvDef.bounds(), objectDef);
                }
                return OBJECT_TYPE;
            }
            return TypeUtils.getBoundsType(typeVariable.bounds(), objectDef);
        }
        throw new IllegalStateException("Unsupported type: " + String.valueOf(typeDef));
    }

    private static Type getBoundsType(List<TypeDef> bounds, ObjectDef objectDef) {
        for (TypeDef bound : bounds) {
            Type type = TypeUtils.getType(bound, objectDef);
            if (type.equals((Object)OBJECT_TYPE)) continue;
            return type;
        }
        return OBJECT_TYPE;
    }

    public static Type getType(TypeDef.Primitive primitive) {
        return Type.getType((String)((String)JavaModelUtils.NAME_TO_TYPE_MAP.get(primitive.name())));
    }

    private static String getTypeDescriptor(String className, Type ... genericTypes) {
        String internalName = TypeUtils.getInternalName(className);
        StringBuilder start = new StringBuilder(40);
        Matcher matcher = ARRAY_PATTERN.matcher(className);
        if (matcher.find()) {
            int dimensions = matcher.group(0).length() / 2;
            start.append("[".repeat(dimensions));
        }
        start.append('L').append(internalName);
        if (genericTypes != null && genericTypes.length > 0) {
            start.append('<');
            for (Type genericType : genericTypes) {
                start.append(genericType.getInternalName());
            }
            start.append('>');
        }
        return start.append(';').toString();
    }

    public static Type getType(String className, Type ... genericTypes) {
        return Type.getType((String)TypeUtils.getTypeDescriptor(className, genericTypes));
    }

    public static Type getType(ClassTypeDef classTypeDef) {
        return TypeUtils.getType(classTypeDef.getName());
    }

    public static Type getType(String className) {
        return Type.getType((String)TypeUtils.getTypeDescriptor(className, new Type[0]));
    }

    private static String getInternalName(String className) {
        String newClassName = className.replace('.', '/');
        Matcher matcher = ARRAY_PATTERN.matcher(newClassName);
        if (matcher.find()) {
            newClassName = matcher.replaceFirst("");
        }
        return newClassName;
    }
}

