/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.bytecode;

import io.micronaut.core.annotation.Internal;
import io.micronaut.sourcegen.bytecode.MethodContext;
import io.micronaut.sourcegen.bytecode.TypeUtils;
import io.micronaut.sourcegen.bytecode.expression.ExpressionWriter;
import io.micronaut.sourcegen.model.ExpressionDef;
import io.micronaut.sourcegen.model.JavaIdioms;
import io.micronaut.sourcegen.model.TypeDef;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

@Internal
public abstract class AbstractConditionalWriter {
    protected static void pushElseConditionalExpression(GeneratorAdapter generatorAdapter, MethodContext context, ExpressionDef expressionDef, Label elseLabel) {
        if (expressionDef instanceof ExpressionDef.ConditionExpressionDef) {
            ExpressionDef.ConditionExpressionDef conditionExpressionDef = (ExpressionDef.ConditionExpressionDef)expressionDef;
            if (expressionDef instanceof ExpressionDef.InstanceOf) {
                ExpressionDef.InstanceOf instanceOf = (ExpressionDef.InstanceOf)expressionDef;
                ExpressionWriter.writeExpression(generatorAdapter, context, instanceOf.expression());
                generatorAdapter.instanceOf(TypeUtils.getType((TypeDef)instanceOf.instanceType(), context.objectDef()));
                generatorAdapter.push(true);
                generatorAdapter.ifCmp(Type.BOOLEAN_TYPE, 154, elseLabel);
                return;
            }
            if (conditionExpressionDef instanceof ExpressionDef.And) {
                ExpressionDef.And andExpressionDef = (ExpressionDef.And)conditionExpressionDef;
                AbstractConditionalWriter.pushElseConditionalExpression(generatorAdapter, context, (ExpressionDef)andExpressionDef.left(), elseLabel);
                AbstractConditionalWriter.pushElseConditionalExpression(generatorAdapter, context, (ExpressionDef)andExpressionDef.right(), elseLabel);
                return;
            }
            if (conditionExpressionDef instanceof ExpressionDef.Or) {
                ExpressionDef.Or orExpressionDef = (ExpressionDef.Or)conditionExpressionDef;
                Label ifLabel = new Label();
                AbstractConditionalWriter.pushIfConditionalExpression(generatorAdapter, context, (ExpressionDef)orExpressionDef.left(), ifLabel);
                AbstractConditionalWriter.pushIfConditionalExpression(generatorAdapter, context, (ExpressionDef)orExpressionDef.right(), ifLabel);
                generatorAdapter.goTo(elseLabel);
                generatorAdapter.visitLabel(ifLabel);
                return;
            }
            if (conditionExpressionDef instanceof ExpressionDef.ComparisonOperation) {
                ExpressionDef.ComparisonOperation comparisonOperation = (ExpressionDef.ComparisonOperation)conditionExpressionDef;
                ExpressionWriter.writeExpression(generatorAdapter, context, comparisonOperation.left());
                ExpressionWriter.writeExpression(generatorAdapter, context, comparisonOperation.right());
                Type conditionType = TypeUtils.getType(comparisonOperation.left().type(), context.objectDef());
                generatorAdapter.ifCmp(conditionType, AbstractConditionalWriter.getInvertConditionOp(comparisonOperation.opType()), elseLabel);
                return;
            }
            if (conditionExpressionDef instanceof ExpressionDef.IsNull) {
                ExpressionDef.IsNull isNull = (ExpressionDef.IsNull)conditionExpressionDef;
                ExpressionWriter.writeExpression(generatorAdapter, context, isNull.expression());
                generatorAdapter.ifNonNull(elseLabel);
                return;
            }
            if (conditionExpressionDef instanceof ExpressionDef.IsNotNull) {
                ExpressionDef.IsNotNull isNotNull = (ExpressionDef.IsNotNull)conditionExpressionDef;
                ExpressionWriter.writeExpression(generatorAdapter, context, isNotNull.expression());
                generatorAdapter.ifNull(elseLabel);
                return;
            }
            if (conditionExpressionDef instanceof ExpressionDef.IsTrue) {
                ExpressionDef.IsTrue isTrue = (ExpressionDef.IsTrue)conditionExpressionDef;
                ExpressionWriter.writeExpression(generatorAdapter, context, isTrue.expression());
                generatorAdapter.push(true);
                generatorAdapter.ifCmp(Type.BOOLEAN_TYPE, 154, elseLabel);
                return;
            }
            if (conditionExpressionDef instanceof ExpressionDef.IsFalse) {
                ExpressionDef.IsFalse isFalse = (ExpressionDef.IsFalse)conditionExpressionDef;
                ExpressionWriter.writeExpression(generatorAdapter, context, isFalse.expression());
                generatorAdapter.push(true);
                generatorAdapter.ifCmp(Type.BOOLEAN_TYPE, 153, elseLabel);
                return;
            }
            if (conditionExpressionDef instanceof ExpressionDef.EqualsReferentially) {
                ExpressionDef.EqualsReferentially equalsReferentially = (ExpressionDef.EqualsReferentially)conditionExpressionDef;
                AbstractConditionalWriter.pushEqualsReferentially(generatorAdapter, context, equalsReferentially.instance(), equalsReferentially.other(), elseLabel, 154);
                return;
            }
            if (expressionDef instanceof ExpressionDef.EqualsStructurally) {
                ExpressionDef.EqualsStructurally equalsStructurally = (ExpressionDef.EqualsStructurally)expressionDef;
                AbstractConditionalWriter.pushEqualsStructurally(generatorAdapter, context, equalsStructurally.instance(), equalsStructurally.other(), elseLabel, 154);
                return;
            }
            if (conditionExpressionDef instanceof ExpressionDef.NotEqualsReferentially) {
                ExpressionDef.NotEqualsReferentially notEqualsReferentially = (ExpressionDef.NotEqualsReferentially)conditionExpressionDef;
                AbstractConditionalWriter.pushEqualsReferentially(generatorAdapter, context, notEqualsReferentially.instance(), notEqualsReferentially.other(), elseLabel, 153);
                return;
            }
            if (expressionDef instanceof ExpressionDef.NotEqualsStructurally) {
                ExpressionDef.NotEqualsStructurally notEqualsStructurally = (ExpressionDef.NotEqualsStructurally)expressionDef;
                AbstractConditionalWriter.pushEqualsStructurally(generatorAdapter, context, notEqualsStructurally.instance(), notEqualsStructurally.other(), elseLabel, 153);
                return;
            }
            throw new UnsupportedOperationException("Unrecognized conditional expression: " + String.valueOf(conditionExpressionDef));
        }
        if (!expressionDef.type().equals(TypeDef.Primitive.BOOLEAN) && !expressionDef.type().equals(TypeDef.Primitive.BOOLEAN.wrapperType())) {
            throw new IllegalStateException("Conditional expression should produce a boolean: " + String.valueOf(expressionDef));
        }
        ExpressionWriter.writeExpressionCheckCast(generatorAdapter, context, expressionDef, (TypeDef)TypeDef.Primitive.BOOLEAN);
        generatorAdapter.push(true);
        generatorAdapter.ifCmp(Type.BOOLEAN_TYPE, 154, elseLabel);
    }

    private static void pushIfConditionalExpression(GeneratorAdapter generatorAdapter, MethodContext context, ExpressionDef expressionDef, Label ifLabel) {
        if (expressionDef instanceof ExpressionDef.ConditionExpressionDef) {
            ExpressionDef.ConditionExpressionDef conditionExpressionDef = (ExpressionDef.ConditionExpressionDef)expressionDef;
            if (expressionDef instanceof ExpressionDef.InstanceOf) {
                ExpressionDef.InstanceOf instanceOf = (ExpressionDef.InstanceOf)expressionDef;
                ExpressionWriter.writeExpression(generatorAdapter, context, instanceOf.expression());
                generatorAdapter.instanceOf(TypeUtils.getType((TypeDef)instanceOf.instanceType(), context.objectDef()));
                generatorAdapter.push(true);
                generatorAdapter.ifCmp(Type.BOOLEAN_TYPE, 153, ifLabel);
                return;
            }
            if (conditionExpressionDef instanceof ExpressionDef.And) {
                ExpressionDef.And andExpressionDef = (ExpressionDef.And)conditionExpressionDef;
                Label elseLabel = new Label();
                AbstractConditionalWriter.pushElseConditionalExpression(generatorAdapter, context, (ExpressionDef)andExpressionDef.left(), elseLabel);
                AbstractConditionalWriter.pushElseConditionalExpression(generatorAdapter, context, (ExpressionDef)andExpressionDef.right(), elseLabel);
                generatorAdapter.goTo(ifLabel);
                generatorAdapter.visitLabel(elseLabel);
                return;
            }
            if (conditionExpressionDef instanceof ExpressionDef.Or) {
                ExpressionDef.Or orExpressionDef = (ExpressionDef.Or)conditionExpressionDef;
                AbstractConditionalWriter.pushIfConditionalExpression(generatorAdapter, context, (ExpressionDef)orExpressionDef.left(), ifLabel);
                AbstractConditionalWriter.pushIfConditionalExpression(generatorAdapter, context, (ExpressionDef)orExpressionDef.right(), ifLabel);
                return;
            }
            if (conditionExpressionDef instanceof ExpressionDef.ComparisonOperation) {
                ExpressionDef.ComparisonOperation comparisonOperation = (ExpressionDef.ComparisonOperation)conditionExpressionDef;
                ExpressionWriter.writeExpression(generatorAdapter, context, comparisonOperation.left());
                ExpressionWriter.writeExpression(generatorAdapter, context, comparisonOperation.right());
                Type conditionType = TypeUtils.getType(comparisonOperation.left().type(), context.objectDef());
                generatorAdapter.ifCmp(conditionType, AbstractConditionalWriter.getConditionOp(comparisonOperation.opType()), ifLabel);
                return;
            }
            if (conditionExpressionDef instanceof ExpressionDef.IsNull) {
                ExpressionDef.IsNull isNull = (ExpressionDef.IsNull)conditionExpressionDef;
                ExpressionWriter.writeExpression(generatorAdapter, context, isNull.expression());
                generatorAdapter.ifNull(ifLabel);
                return;
            }
            if (conditionExpressionDef instanceof ExpressionDef.IsNotNull) {
                ExpressionDef.IsNotNull isNotNull = (ExpressionDef.IsNotNull)conditionExpressionDef;
                ExpressionWriter.writeExpression(generatorAdapter, context, isNotNull.expression());
                generatorAdapter.ifNonNull(ifLabel);
                return;
            }
            if (conditionExpressionDef instanceof ExpressionDef.IsTrue) {
                ExpressionDef.IsTrue isTrue = (ExpressionDef.IsTrue)conditionExpressionDef;
                ExpressionWriter.writeExpression(generatorAdapter, context, isTrue.expression());
                generatorAdapter.push(true);
                generatorAdapter.ifCmp(Type.BOOLEAN_TYPE, 153, ifLabel);
                return;
            }
            if (conditionExpressionDef instanceof ExpressionDef.IsFalse) {
                ExpressionDef.IsFalse isFalse = (ExpressionDef.IsFalse)conditionExpressionDef;
                ExpressionWriter.writeExpression(generatorAdapter, context, isFalse.expression());
                generatorAdapter.push(true);
                generatorAdapter.ifCmp(Type.BOOLEAN_TYPE, 154, ifLabel);
                return;
            }
            if (conditionExpressionDef instanceof ExpressionDef.EqualsReferentially) {
                ExpressionDef.EqualsReferentially equalsReferentially = (ExpressionDef.EqualsReferentially)conditionExpressionDef;
                AbstractConditionalWriter.pushEqualsReferentially(generatorAdapter, context, equalsReferentially.instance(), equalsReferentially.other(), ifLabel, 153);
                return;
            }
            if (expressionDef instanceof ExpressionDef.EqualsStructurally) {
                ExpressionDef.EqualsStructurally equalsStructurally = (ExpressionDef.EqualsStructurally)expressionDef;
                AbstractConditionalWriter.pushEqualsStructurally(generatorAdapter, context, equalsStructurally.instance(), equalsStructurally.other(), ifLabel, 153);
                return;
            }
            if (conditionExpressionDef instanceof ExpressionDef.NotEqualsReferentially) {
                ExpressionDef.NotEqualsReferentially notEqualsReferentially = (ExpressionDef.NotEqualsReferentially)conditionExpressionDef;
                AbstractConditionalWriter.pushEqualsReferentially(generatorAdapter, context, notEqualsReferentially.instance(), notEqualsReferentially.other(), ifLabel, 154);
                return;
            }
            if (expressionDef instanceof ExpressionDef.NotEqualsStructurally) {
                ExpressionDef.NotEqualsStructurally notEqualsStructurally = (ExpressionDef.NotEqualsStructurally)expressionDef;
                AbstractConditionalWriter.pushEqualsStructurally(generatorAdapter, context, notEqualsStructurally.instance(), notEqualsStructurally.other(), ifLabel, 154);
                return;
            }
            throw new UnsupportedOperationException("Unrecognized conditional expression: " + String.valueOf(conditionExpressionDef));
        }
        if (!expressionDef.type().equals(TypeDef.Primitive.BOOLEAN) && !expressionDef.type().equals(TypeDef.Primitive.BOOLEAN.wrapperType())) {
            throw new IllegalStateException("Conditional expression should produce a boolean: " + String.valueOf(expressionDef));
        }
        ExpressionWriter.writeExpressionCheckCast(generatorAdapter, context, expressionDef, (TypeDef)TypeDef.Primitive.BOOLEAN);
        generatorAdapter.push(true);
        generatorAdapter.ifCmp(Type.BOOLEAN_TYPE, 153, ifLabel);
    }

    private static void pushEqualsStructurally(GeneratorAdapter generatorAdapter, MethodContext context, ExpressionDef left, ExpressionDef right, Label ifLabel, int op) {
        TypeDef leftType = left.type();
        TypeDef rightType = right.type();
        if (leftType.isPrimitive()) {
            AbstractConditionalWriter.pushEqualsReferentially(generatorAdapter, context, left, (ExpressionDef)right.cast(leftType), ifLabel, op);
            return;
        }
        if (rightType.isPrimitive()) {
            AbstractConditionalWriter.pushEqualsReferentially(generatorAdapter, context, (ExpressionDef)left.cast(rightType), right, ifLabel, op);
            return;
        }
        ExpressionWriter.writeExpressionCheckCast(generatorAdapter, context, JavaIdioms.equalsStructurally((ExpressionDef)left, (ExpressionDef)right), (TypeDef)TypeDef.Primitive.BOOLEAN);
        generatorAdapter.push(true);
        generatorAdapter.ifCmp(Type.BOOLEAN_TYPE, op, ifLabel);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void pushEqualsReferentially(GeneratorAdapter generatorAdapter, MethodContext context, ExpressionDef left, ExpressionDef right, Label label, int op) {
        TypeDef leftType = left.type();
        ExpressionWriter.writeExpression(generatorAdapter, context, left);
        TypeDef rightType = right.type();
        ExpressionWriter.writeExpression(generatorAdapter, context, right);
        if (leftType instanceof TypeDef.Primitive) {
            TypeDef.Primitive p1 = (TypeDef.Primitive)leftType;
            if (rightType instanceof TypeDef.Primitive) {
                generatorAdapter.ifCmp(TypeUtils.getType(p1), op, label);
                return;
            }
        }
        generatorAdapter.ifCmp(TypeUtils.OBJECT_TYPE, op, label);
    }

    private static int getInvertConditionOp(ExpressionDef.ComparisonOperation.OpType op) {
        return switch (op) {
            default -> throw new IncompatibleClassChangeError();
            case ExpressionDef.ComparisonOperation.OpType.EQUAL_TO -> 154;
            case ExpressionDef.ComparisonOperation.OpType.NOT_EQUAL_TO -> 153;
            case ExpressionDef.ComparisonOperation.OpType.GREATER_THAN -> 158;
            case ExpressionDef.ComparisonOperation.OpType.LESS_THAN -> 156;
            case ExpressionDef.ComparisonOperation.OpType.GREATER_THAN_OR_EQUAL -> 155;
            case ExpressionDef.ComparisonOperation.OpType.LESS_THAN_OR_EQUAL -> 157;
        };
    }

    private static int getConditionOp(ExpressionDef.ComparisonOperation.OpType op) {
        return switch (op) {
            default -> throw new IncompatibleClassChangeError();
            case ExpressionDef.ComparisonOperation.OpType.EQUAL_TO -> 153;
            case ExpressionDef.ComparisonOperation.OpType.NOT_EQUAL_TO -> 154;
            case ExpressionDef.ComparisonOperation.OpType.GREATER_THAN -> 157;
            case ExpressionDef.ComparisonOperation.OpType.LESS_THAN -> 155;
            case ExpressionDef.ComparisonOperation.OpType.GREATER_THAN_OR_EQUAL -> 156;
            case ExpressionDef.ComparisonOperation.OpType.LESS_THAN_OR_EQUAL -> 158;
        };
    }
}

