/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.scheduling.instrument;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.scheduling.instrument.Instrumentation;
import io.micronaut.scheduling.instrument.InstrumentedExecutor;
import io.micronaut.scheduling.instrument.InstrumentedExecutorService;
import io.micronaut.scheduling.instrument.InstrumentedScheduledExecutorService;
import io.micronaut.scheduling.instrument.InvocationInstrumenterWrappedCallable;
import io.micronaut.scheduling.instrument.InvocationInstrumenterWrappedRunnable;
import io.micronaut.scheduling.instrument.MultipleInvocationInstrumenter;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

public interface InvocationInstrumenter {
    public static final InvocationInstrumenter NOOP = Instrumentation::noop;

    @NonNull
    public Instrumentation newInstrumentation();

    @NonNull
    public static InvocationInstrumenter combine(Collection<InvocationInstrumenter> invocationInstrumenters) {
        if (CollectionUtils.isEmpty(invocationInstrumenters)) {
            return NOOP;
        }
        if (invocationInstrumenters.size() == 1) {
            return invocationInstrumenters.iterator().next();
        }
        return new MultipleInvocationInstrumenter(invocationInstrumenters);
    }

    @NonNull
    public static Runnable instrument(@NonNull Runnable runnable, Collection<InvocationInstrumenter> invocationInstrumenters) {
        if (CollectionUtils.isEmpty(invocationInstrumenters)) {
            return runnable;
        }
        return InvocationInstrumenter.instrument(runnable, InvocationInstrumenter.combine(invocationInstrumenters));
    }

    @NonNull
    public static <V> Callable<V> instrument(@NonNull Callable<V> callable, Collection<InvocationInstrumenter> invocationInstrumenters) {
        if (CollectionUtils.isEmpty(invocationInstrumenters)) {
            return callable;
        }
        return InvocationInstrumenter.instrument(callable, InvocationInstrumenter.combine(invocationInstrumenters));
    }

    @NonNull
    public static Runnable instrument(@NonNull Runnable runnable, InvocationInstrumenter invocationInstrumenter) {
        if (runnable instanceof InvocationInstrumenterWrappedRunnable) {
            return runnable;
        }
        return new InvocationInstrumenterWrappedRunnable(invocationInstrumenter, runnable);
    }

    @NonNull
    public static <V> Callable<V> instrument(@NonNull Callable<V> callable, InvocationInstrumenter invocationInstrumenter) {
        if (callable instanceof InvocationInstrumenterWrappedCallable) {
            return callable;
        }
        return new InvocationInstrumenterWrappedCallable<V>(invocationInstrumenter, callable);
    }

    public static Executor instrument(final @NonNull Executor executor, final @NonNull InvocationInstrumenter invocationInstrumenter) {
        ArgumentUtils.requireNonNull((String)"executor", (Object)executor);
        ArgumentUtils.requireNonNull((String)"invocationInstrumenter", (Object)invocationInstrumenter);
        if (executor instanceof ScheduledExecutorService) {
            return new InstrumentedScheduledExecutorService(){

                @Override
                public ScheduledExecutorService getTarget() {
                    return (ScheduledExecutorService)executor;
                }

                @Override
                public <T> Callable<T> instrument(Callable<T> callable) {
                    return InvocationInstrumenter.instrument(callable, invocationInstrumenter);
                }

                @Override
                public Runnable instrument(Runnable runnable) {
                    return InvocationInstrumenter.instrument(runnable, invocationInstrumenter);
                }
            };
        }
        if (executor instanceof ExecutorService) {
            return new InstrumentedExecutorService(){

                @Override
                public ExecutorService getTarget() {
                    return (ExecutorService)executor;
                }

                @Override
                public <T> Callable<T> instrument(Callable<T> callable) {
                    return InvocationInstrumenter.instrument(callable, invocationInstrumenter);
                }

                @Override
                public Runnable instrument(Runnable runnable) {
                    return InvocationInstrumenter.instrument(runnable, invocationInstrumenter);
                }
            };
        }
        return new InstrumentedExecutor(){

            @Override
            public Executor getTarget() {
                return executor;
            }

            @Override
            public Runnable instrument(Runnable runnable) {
                return InvocationInstrumenter.instrument(runnable, invocationInstrumenter);
            }
        };
    }
}

